/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ykhr.eclipse.plugin.chocoxslt;

import jp.gr.java_conf.ykhr.eclipse.plugin.chocoxslt.Activator;
import jp.gr.java_conf.ykhr.eclipse.plugin.chocoxslt.InputCache;
import jp.gr.java_conf.ykhr.eclipse.plugin.chocoxslt.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class XsltDialog
extends Dialog {
    private IProject project;
    private InputCache cache;
    private Text inText = null;
    private Text outText = null;
    private Text propText = null;
    private String input;
    private String output;
    private String property;

    public XsltDialog(Shell parentShell, IFile xslFile, InputCache cache) {
        super(parentShell);
        this.project = xslFile.getProject();
        this.cache = cache;
        if (cache.hasLastConfig()) {
            this.input = cache.getStoreValue(".input");
            this.output = cache.getStoreValue(".output");
            this.property = cache.getStoreValue(".property");
        } else {
            this.input = "";
            this.output = "";
            this.property = "";
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.Dialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(comp, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label inLabel = new Label(composite, 0);
        inLabel.setText(Messages.Dialog_Xslt_Input);
        this.inText = new Text(composite, 2052);
        this.inText.setText(this.input);
        GridData inTextData = new GridData(768);
        inTextData.widthHint = 200;
        this.inText.setLayoutData((Object)inTextData);
        Button inButton = new Button(composite, 8);
        inButton.setLayoutData((Object)new GridData(768));
        inButton.setText(Messages.Dialog_Browse);
        SelectResourceListener inListener = new SelectResourceListener(this.project, this.inText, ".xml", Messages.Dialog_Title_SelectXml);
        inButton.addSelectionListener((SelectionListener)inListener);
        new Label(composite, 0).setText(Messages.Dialog_Xslt_Output);
        this.outText = new Text(composite, 2052);
        this.outText.setText(this.output);
        this.outText.setLayoutData((Object)new GridData(768));
        new Label(composite, 0);
        new Label(composite, 0).setText(Messages.Dialog_Xslt_Parameter);
        this.propText = new Text(composite, 2052);
        this.propText.setText(this.property);
        this.propText.setLayoutData((Object)new GridData(768));
        Button propButton = new Button(composite, 8);
        propButton.setLayoutData((Object)new GridData(768));
        propButton.setText(Messages.Dialog_Browse);
        SelectResourceListener propListener = new SelectResourceListener(this.project, this.propText, ".properties", Messages.Dialog_Title_SelectProperty);
        propButton.addSelectionListener((SelectionListener)propListener);
        return composite;
    }

    protected void okPressed() {
        this.input = this.inText.getText();
        this.output = this.outText.getText();
        this.property = this.propText.getText();
        this.cache.storeLastValue(".input", this.input);
        this.cache.storeLastValue(".output", this.output);
        this.cache.storeLastValue(".property", this.property);
        super.okPressed();
    }

    public String getInput() {
        return this.input;
    }

    public String getOutput() {
        return this.output;
    }

    public String getProperty() {
        return this.property;
    }

    private static class FileExtensionFilter
    extends ViewerFilter {
        private String ext;

        public FileExtensionFilter(String ext) {
            this.ext = ext;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IContainer) {
                return true;
            }
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                return file.getName().endsWith(this.ext);
            }
            return false;
        }
    }

    private static class SelectResourceListener
    extends SelectionAdapter {
        private IProject project;
        private Text replText;
        private String filterExt;
        private String dialogTitle;

        public SelectResourceListener(IProject project, Text text, String filterExt, String title) {
            this.project = project;
            this.replText = text;
            this.filterExt = filterExt;
            this.dialogTitle = title;
        }

        public void widgetSelected(SelectionEvent e) {
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(Activator.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
            dialog.setTitle(this.dialogTitle);
            dialog.setInput((Object)this.project);
            dialog.setAllowMultiple(false);
            dialog.setHelpAvailable(false);
            dialog.addFilter((ViewerFilter)new FileExtensionFilter(this.filterExt));
            dialog.setSorter((ViewerSorter)new ResourceSorter(2));
            int code = dialog.open();
            if (code == 0) {
                IFile file = (IFile)dialog.getResult()[0];
                this.replText.setText(file.getProjectRelativePath().toPortableString());
            }
        }
    }
}

