package org.kaoriha.jspbp.renderer.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableSource implements Source<Column, String> {

	public Data<Column, String> getData(Query<Column> query) {
		List<Map<Column, String>> cell = new ArrayList<Map<Column, String>>();
		{
			Map<Column, String> row = new HashMap<Column, String>();
			row.put(Column.A, "a1");
			row.put(Column.B, "b1");
			row.put(Column.C, "c1");
			cell.add(row);
		}
		Map<Column, String> header = new HashMap<Column, String>();
		header.put(Column.A, "A");
		header.put(Column.B, "B");
		header.put(Column.C, "C");
		Map<Column, String> footer = new HashMap<Column, String>();
		footer.put(Column.A, "fa");
		footer.put(Column.B, "fb");
		footer.put(Column.C, "fc");
		Data<Column, String> data = new Data<Column, String>(query, "caption", cell, header,
				footer, Arrays.asList(Column.A, Column.B, Column.C), 1);
		return data;
	}

	public Column valueOfEnum(String name) {
		return Column.valueOf(name);
	}
}
