package org.kaoriha.jspbp.renderer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class MockViewState implements ViewState {
	private static final Pattern SPLITTER = Pattern.compile("&|\\?");
	private final Map<String, List<String>> queryMap = new HashMap<String, List<String>>();
	{
		queryMap.put("s", Arrays.asList("aA"));
		queryMap.put("o", Arrays.asList("10"));
	}
	private final String requestURL = "http://localhost:8080/test?table=s.aA&table=o.10";
	private final String viewStateId = "table";

	public String getNewUrl(String key, List<String> values) {
		StringBuilder sb = new StringBuilder();
		String starts = viewStateId + "=" + key + ".";
		boolean isFirst = true;
		for (String s : SPLITTER.split(requestURL)) {
			if (s.startsWith(starts)) {
				continue;
			}
			if (sb.length() == 0) {
				sb.append(s);
				continue;
			}
			if (isFirst) {
				sb.append("?");
				isFirst = false;
			} else {
				sb.append("&");
			}
			sb.append(s);
		}

		for (String s : values) {
			if (isFirst) {
				sb.append("?");
				isFirst = false;
			} else {
				sb.append("&");
			}
			sb.append(starts + s);
		}

		return sb.toString();
	}

	public Map<String, List<String>> getQueryMap() {
		return queryMap;
	}

	public String getViewStateId() {
		return viewStateId;
	}

	public HttpServletRequest getRequest() {
		return null;
	}

	public String getNewUrl(Map<String, List<String>> kv) {
		return null;
	}

	public ServletContext getServletContext() {
		return null;
	}
}
