package org.kaoriha.jspbp.renderer.table;

import org.jdom.Element;
import org.kaoriha.jspbp.renderer.AbstractRenderer;
import org.kaoriha.jspbp.renderer.ViewState;

public class Tr<ColT extends Enum<ColT>, CellT> extends AbstractRenderer<DataRow<ColT, CellT>> {
	public Tr(ViewState viewState) {
		super(viewState);
	}

	private AbstractRenderer<DataCell<ColT, CellT>> cell = new Td<ColT, CellT>(viewState);

	@Override
	public void render(Element parent) {
		Element tr = new Element("tr");
		parent.addContent(tr);
		for (ColT t : source.getData().getColumnList()) {
			cell.setSource(new DataCell<ColT, CellT>(source, t));
			cell.render(tr);
		}
	}

	public AbstractRenderer<DataCell<ColT, CellT>> getCell() {
		return cell;
	}

	public void setCell(AbstractRenderer<DataCell<ColT, CellT>> cell) {
		this.cell = cell;
	}
}
