package org.kaoriha.jspbp.renderer.table;

import java.util.ArrayList;
import java.util.List;

import org.jdom.Element;
import org.kaoriha.jspbp.renderer.AbstractRenderer;
import org.kaoriha.jspbp.renderer.ViewState;

public class Th<ColT extends Enum<ColT>, CellT> extends
		AbstractRenderer<DataCell<ColT, CellT>> {
	public Th(ViewState viewState) {
		super(viewState);
	}

	private AbstractRenderer<CellT> cell = new SimpleRenderer<CellT>(viewState);

	@Override
	public void render(Element parent) {
		Element th = new Element("th");
		parent.addContent(th);
		Element a = new Element("a");
		th.addContent(a);

		List<String> qsList = new ArrayList<String>();
		CellT content = source.getDataRow().getData().getHeader().get(
				source.getColumn());

		List<Sort<ColT>> sl = source.getDataRow().getData().getQuery()
				.getSortList();
		if (sl.size() > 0) {
			Sort<ColT> s = sl.get(sl.size() - 1);
			if (s.getColumn() == source.getColumn()) {
				if (s.isAsc()) {
					qsList.add(Constant.PRE_DSC + source.getColumn().name());
				} else {
					qsList.add(Constant.PRE_ASC + source.getColumn().name());
				}
				a.setAttribute("href", viewState.getNewUrl(Constant.QN_SORT,
						qsList));

				cell.setSource(content);
				cell.render(a);

				if (s.isAsc()) {
					a.addContent(" \u25b2");
				} else {
					a.addContent(" \u25bc");
				}

				return;
			}
		}

		qsList.add(Constant.PRE_ASC + source.getColumn().name());
		a.setAttribute("href", viewState.getNewUrl(Constant.QN_SORT, qsList));

		cell.setSource(content);
		cell.render(a);
	}

	public AbstractRenderer<CellT> getCell() {
		return cell;
	}

	public void setCell(AbstractRenderer<CellT> cell) {
		this.cell = cell;
	}
}