package org.kaoriha.jspbp.renderer.table;

import org.jdom.Element;
import org.kaoriha.jspbp.renderer.AbstractRenderer;
import org.kaoriha.jspbp.renderer.ViewState;

public class Tfoot<ColT extends Enum<ColT>, CellT> extends AbstractRenderer<Data<ColT, CellT>> {
	public Tfoot(ViewState viewState) {
		super(viewState);
	}

	private Tr<ColT, CellT> tr = new Tr<ColT, CellT>(viewState);

	@Override
	public void render(Element parent) {
		Element tfoot = new Element("tfoot");
		parent.addContent(tfoot);
		tr.setSource(new DataRow<ColT, CellT>(source, source.getFooter()));
		tr.render(tfoot);
	}

	public Tr<ColT, CellT> getTr() {
		return tr;
	}

	public void setTr(Tr<ColT, CellT> tr) {
		this.tr = tr;
	}
}
