package org.kaoriha.jspbp.renderer.table;

import org.jdom.Element;
import org.kaoriha.jspbp.renderer.AbstractRenderer;
import org.kaoriha.jspbp.renderer.ViewState;

public class Td<ColT extends Enum<ColT>, CellT> extends AbstractRenderer<DataCell<ColT, CellT>> {
	public Td(ViewState viewState) {
		super(viewState);
	}

	private AbstractRenderer<CellT> cell = new SimpleRenderer<CellT>(
			viewState);

	@Override
	public void render(Element parent) {
		Element td = new Element("td");
		parent.addContent(td);
		cell.setSource(source.getDataRow().getRow().get(source.getColumn()));
		cell.render(td);
	}

	public AbstractRenderer<CellT> getCell() {
		return cell;
	}

	public void setCell(AbstractRenderer<CellT> cell) {
		this.cell = cell;
	}
}
