package org.kaoriha.jspbp.renderer.table;

import java.util.Map;

import org.jdom.Element;
import org.kaoriha.jspbp.renderer.AbstractRenderer;
import org.kaoriha.jspbp.renderer.ViewState;

public class Tbody<ColT extends Enum<ColT>, CellT> extends AbstractRenderer<Data<ColT, CellT>> {
	public Tbody(ViewState viewState) {
		super(viewState);
	}

	private Tr<ColT, CellT> tr = new Tr<ColT, CellT>(viewState);

	@Override
	public void render(Element parent) {
		Element tbody = new Element("tbody");
		parent.addContent(tbody);
		for (Map<ColT, CellT> row : source.getCell()) {
			tr.setSource(new DataRow<ColT, CellT>(source, row));
			tr.render(tbody);
		}
	}

	public Tr<ColT, CellT> getTr() {
		return tr;
	}

	public void setTr(Tr<ColT, CellT> tr) {
		this.tr = tr;
	}
}
