package org.kaoriha.jspbp.renderer;

import java.util.List;

import org.jdom.Content;

/**
 * Renderer class for root node.
 * 
 * @author NAKAZATO Hajime
 * 
 * @param <T>
 *            Source class.
 */
public abstract class AbstractRootRenderer<T> {
	protected final ViewState viewState;
	protected T source;

	protected AbstractRootRenderer(ViewState viewState) {
		this.viewState = viewState;
	}

	/**
	 * Render from source.
	 * 
	 * @return <code>List</code> of <code>org.jdom.Content</code>.
	 */
	abstract public List<Content> render();

	public void setSource(T source) {
		this.source = source;
	}
}
