/*
 * Decompiled with CFR 0.152.
 */
package org.kaoriha.jspbp.renderer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.kaoriha.jspbp.renderer.ViewState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewStateImpl
implements ViewState {
    private static final Pattern SPLITTER = Pattern.compile("&|\\?");
    private final Map<String, List<String>> queryMap = new HashMap<String, List<String>>();
    private final HttpServletRequest request;
    private final String viewStateId;
    private final ServletContext servletContext;

    public ViewStateImpl(String viewStateId, HttpServletRequest request, ServletContext servletContext) {
        this.viewStateId = viewStateId;
        this.request = request;
        this.servletContext = servletContext;
        if (!request.getParameterMap().containsKey(viewStateId)) {
            return;
        }
        for (String s : request.getParameterValues(viewStateId)) {
            String[] kv = s.split("\\.");
            if (kv.length <= 1) continue;
            this.put(kv[0], kv[1]);
        }
    }

    private void put(String key, String value) {
        if (this.queryMap.containsKey(key)) {
            List<String> sl = this.queryMap.get(key);
            sl.add(value);
        } else {
            ArrayList<String> sl = new ArrayList<String>();
            sl.add(value);
            this.queryMap.put(key, sl);
        }
    }

    @Override
    public Map<String, List<String>> getQueryMap() {
        return this.queryMap;
    }

    @Override
    public String getNewUrl(String key, List<String> values) {
        HashMap<String, List<String>> kv = new HashMap<String, List<String>>();
        kv.put(key, values);
        return this.getNewUrl(kv);
    }

    @Override
    public String getViewStateId() {
        return this.viewStateId;
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.request;
    }

    private boolean isStartsWithContains(String s, Set<String> values) {
        for (String v : values) {
            if (!s.startsWith(v)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getNewUrl(Map<String, List<String>> kv) {
        String[] sp;
        StringBuilder sb = new StringBuilder();
        HashSet<String> startsSet = new HashSet<String>();
        for (String key : kv.keySet()) {
            startsSet.add(this.viewStateId + "=" + key + ".");
        }
        boolean isFirst = true;
        String req = this.request.getRequestURL().toString();
        if (this.request.getQueryString() != null) {
            req = req + "?" + this.request.getQueryString();
        }
        for (String s : sp = SPLITTER.split(req)) {
            if (this.isStartsWithContains(s, startsSet)) continue;
            if (sb.length() == 0) {
                sb.append(s);
                continue;
            }
            if (isFirst) {
                sb.append("?");
                isFirst = false;
            } else {
                sb.append("&");
            }
            sb.append(s);
        }
        for (Map.Entry<String, List<String>> entry : kv.entrySet()) {
            String starts = this.viewStateId + "=" + entry.getKey() + ".";
            List<String> values = entry.getValue();
            for (String s : values) {
                if (isFirst) {
                    sb.append("?");
                    isFirst = false;
                } else {
                    sb.append("&");
                }
                sb.append(starts + s);
            }
        }
        return sb.toString();
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }
}

