#
# initrd-tools.sh	Unmount and free the initrd.
#
# Version:		$Id: initrd-tools.sh,v 1.2 2002/04/04 09:51:34 herbert Exp $
#

. /etc/default/initrd-tools.sh

[ "$KEEPINITRD" = yes ] && exit
command -v blockdev > /dev/null 2>&1 || exit 0

mount -n /proc || exit

# Let the user worry about unmounting everything under /initrd.
grep -q '^[^ ]* /initrd ' /proc/mounts || exit 0

umount -n /proc

umount /initrd || exit

if [ -b /dev/ram0 ]; then
	blockdev --flushbufs /dev/ram0
elif [ -b /dev/rd/0 ]; then
	blockdev --flushbufs /dev/rd/0
else
	echo "freeinitrd.sh: Cannot find initrd device" >&2
	exit 1
fi
