<?php
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
// ------------------------------------------------------------------------- //
// Author: Tobias Liegl (AKA CHAPI)                                          //
// Site: http://www.chapi.de                                                 //
// Project: The XOOPS Project                                                //
// ------------------------------------------------------------------------- //
// Hacker: GIJ=CHECKMATE (AKA GIJOE)                                         //
// Site: http://www.peak.ne.jp/xoops/                                        //
// ------------------------------------------------------------------------- //

// check modulesless rewrite
if( ! empty( $_SERVER['REQUEST_URI'] ) && ! stristr( $_SERVER['REQUEST_URI'] , 'modules' ) ) {
	$xPage_vmod_dir = $_SERVER['REQUEST_URI'] ;
	$_SERVER['REQUEST_URI'] = $_SERVER['SCRIPT_NAME'] . '?' . $_SERVER['QUERY_STRING'] ;
}

/* echo "<pre>" ;
var_dump( $_SERVER ) ;
exit ; */

include( '../../mainfile.php' ) ;
include_once( 'class/xPage.textsanitizer.php' ) ;
include_once( 'include/render_function.inc.php' ) ;
include_once( 'include/constants.inc.php' ) ;

// for "Duplicatable"
$mydirname = basename( dirname( __FILE__ ) ) ;
if( ! preg_match( '/^(\D+)(\d*)$/' , $mydirname , $regs ) ) echo ( "invalid dirname: " . htmlspecialchars( $mydirname ) ) ;
$mydirnumber = $regs[2] === '' ? '' : intval( $regs[2] ) ;

// utility variables
$mymodpath = XOOPS_ROOT_PATH."/modules/$mydirname" ;
$mytablename = $xoopsDB->prefix( "tinycontent{$mydirnumber}" ) ;
$id = $homepage_id = 0;
// check if $_GET['id'] is specified
$id = empty( $_GET['id'] ) ? 0 : intval( $_GET['id'] ) ;

if($id<0) {
	$wstr = "visible='1' ORDER BY submenu ASC, blockid ASC";
}elseif($id==0) {
	$_REQUEST['id'] = $_GET['id'] = $id = $homepage_id ;
	$wstr = "visible='1' ORDER BY homepage DESC, blockid";
}else{
	$wstr = "storyid='$id' AND visible";
}
if( $id >= 0 )  {
	$sql = "SELECT storyid,title,text,visible,nohtml,nosmiley,nobreaks,nocomments,link,address,UNIX_TIMESTAMP(last_modified) AS last_modified,html_header FROM "
		. $mytablename ." WHERE " . $wstr;
	$result = $xoopsDB->query( $sql ) ;
	if( ( $result_array = $xoopsDB->fetchArray( $result ) ) == false ) {
		redirect_header( XOOPS_URL.'/' , 2 , _TC_FILENOTFOUND ) ;
		exit ;
	}
	// redirect if its base of wrapping is wrap_path (content)
	if( ! $xoopsModuleConfig['tc_force_mod_rewrite'] && $result_array['link'] == TC_WRAPTYPE_CONTENTBASE ) {
		if( headers_sent() ) {
			redirect_header( XOOPS_URL . "/modules/$mydirname/content/index.php?id={$result_array['storyid']}" , 0 , '&nbsp;' ) ;
		} else {
			header( "Location: content/index.php?id={$result_array['storyid']}" ) ;
		}
		exit ;
	}
	$homepage_id = $result_array['storyid'];
	$homepage_link_type = $result_array['link'];
	include( "include/display.inc.php" ) ;
}else{
	$sitemap = $chank = $parent = $child = array();
	$sql = "SELECT submenu,blockid,storyid,title FROM " . $mytablename ." WHERE " . $wstr;
	$result = $xoopsDB->query( $sql ) ;
	while ( $myrow = $xoopsDB->fetchArray($result) ){
		if ($myrow['submenu']==0)
			$parent[] = array('storyid'=>$myrow['storyid'],'title'=>$myrow['title']);
		else
			$child[] = array('submenu'=>$myrow['submenu'],'storyid'=>$myrow['storyid'],'title'=>$myrow['title']);
	}
	foreach($parent as $p){
		$sitemap[] = array( "storyid"=> $p['storyid'], "title" => $p['title'], "level" => 0 );
		foreach($child as $c1){
			if ($c1['submenu']==$p['storyid']){
				$sitemap[] = array( "storyid"=> $c1['storyid'], "title" => $c1['title'], "level" => 1 );
				foreach($child as $c2){
					if ($c2['submenu']==$c1['storyid'])
						$sitemap[] = array( "storyid"=> $c2['storyid'], "title" => $c2['title'], "level" => 2 );
				}
			}
		}
	}
	$xoopsTpl->assign( 'sitemap' , $sitemap ) ;
	$xoopsTpl->assign( 'title' , _TC_SITEMAP) ;
	//var_dump($sitemap);die;
}

// XOOPS Header
include( XOOPS_ROOT_PATH . '/header.php' ) ;



$xoopsTpl->assign( 'edit_link' , XOOPS_URL . "/modules/$mydirname/edit.php?id=$id&amp;op=edit" ) ;
$xoopsTpl->assign( 'addnew_link' , XOOPS_URL . "/modules/$mydirname/edit.php?op=addnew" ) ;

$xoopsOption['template_main'] = "tinycontent{$mydirnumber}_index.html" ;
include( XOOPS_ROOT_PATH.'/footer.php' ) ;
?>