<?php
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
// ------------------------------------------------------------------------- //
// Author: Tobias Liegl (AKA CHAPI)                                          //
// Site: http://www.chapi.de                                                 //
// Project: The XOOPS Project                                                //
// ------------------------------------------------------------------------- //
// Hacker: GIJ=CHECKMATE (AKA GIJOE)                                         //
// Site: http://www.peak.ne.jp/xoops/                                        //
// ------------------------------------------------------------------------- //

include( '../../mainfile.php' ) ;

if( ! defined( 'XOOPS_ROOT_PATH' ) ) exit ;

include_once( 'class/tc_table.class.php' ) ;
include_once( 'class/xPage.textsanitizer.php' ) ;
include_once( 'include/render_function.inc.php' ) ;
include_once( 'include/constants.inc.php' ) ;
include_once( 'include/gtickets.php' );

require_once( XOOPS_ROOT_PATH.'/class/template.php' ) ;

// $myts
$myts =& MyTextSanitizer::getInstance() ;

// for "Duplicatable"
$mydirname = basename( dirname( __FILE__ ) ) ;
if( ! preg_match( '/^(\D+)(\d*)$/' , $mydirname , $regs ) ) 
	echo ( "invalid dirname: " . htmlspecialchars( $mydirname ) ) ;
$mydirnumber = $regs[2] === '' ? '' : intval( $regs[2] ) ;
$mod_url = XOOPS_URL."/modules/$mydirname" ;

// utility variables
$mymodpath = XOOPS_ROOT_PATH."/modules/$mydirname" ;
$mytablename = $xoopsDB->prefix( "tinycontent{$mydirnumber}" ) ;


if( !$xoopsUser->isAdmin() ){
	redirect_header(XOOPS_URL, 2, _NOPERM);
}
/*
 * initial parameter for addnew
 */
$id = 0;
$visible = $nobreaks = $nosmiley = $submenu = 1;
$nocomments = 0;

$op = isset($_GET['op']) ? htmlspecialchars($_GET['op'], ENT_QUOTES) : 'edit';
$op = isset($_POST['op']) ? htmlspecialchars($_POST['op'], ENT_QUOTES) : $op;
// check if $_GET['id'] is specified
$id = empty( $_GET['id'] ) ? 0 : intval( $_GET['id'] ) ;
$id = empty( $_POST['id'] ) ? $id : intval( $_POST['id'] ) ;
if ($op == "edit" && $id==0) $id=1;

$storyid = null;
$title = null;
$message = null;
$homepage = null;
$nohtml = null;
$link = null;
$address = null;
$last_modified = null;
$created = null;
$html_header = null;
$link = null;
$text = null;
$nohtml = null;
	
if ($op=="editit"){
	// Ticket Check
	if ( ! $xoopsGTicket->check( true , $mydirname ) ) {
		redirect_header(XOOPS_URL.'/',3,$xoopsGTicket->getErrors());
	}
	$tb = new tc_table();
	$ret = $tb->post2table($mytablename);
	if( $ret==false ) die ( _TC_ERRORINSERT ) ;
	if( $id==0 ) $id = $tb->new_id();
} elseif( !$op )  {
	redirect_header( XOOPS_URL.'/' , 2 , _TC_FILENOTFOUND ) ;
	exit ;
}
if( $id > 0 )  {
	// main query
	$sql = "SELECT * FROM $mytablename WHERE storyid=".$id." AND visible";
	$result = $xoopsDB->query( $sql ) ;
	if( ( $result_array = $xoopsDB->fetchArray( $result ) ) == false ) {
		redirect_header( XOOPS_URL.'/' , 2 , _TC_FILENOTFOUND ) ;
		exit ;
	}
	extract( $result_array ) ;
}
$comments = $nocomments == 1 ? 0 : 1;

// header part
header( 'Content-Type:text/html; charset='._CHARSET ) ;
$tpl = new XoopsTpl();
$tpl->xoops_setTemplateDir(XOOPS_ROOT_PATH.'/themes');
$tpl->xoops_setCaching(2);
$tpl->xoops_setCacheTime(0);

$tpl->assign('charset', _CHARSET);
$tpl->assign('sitename', $xoopsConfig['sitename']);
$tpl->assign('site_url', XOOPS_URL);
$tpl->assign('content_url', XOOPS_URL."/modules/$mydirname/index.php?id=$storyid");
$tpl->assign('lang_comesfrom', sprintf(_TC_THISCOMESFROM, $xoopsConfig['sitename']));
$tpl->assign('lang_contentfrom', _TC_URLFORSTORY);
$myts =& MyTextSanitizer::getInstance() ;
$tpl->assign( 'id' ,  $id ) ;
$tpl->assign( 'title' , $myts->makeTboxData4Show( $title ) ) ;
$tpl->assign( 'visible', $visible);
$tpl->assign( 'homepage', $homepage);
$tpl->assign( 'nohtml', $nohtml);
$tpl->assign( 'nosmiley', $nosmiley);
$tpl->assign( 'nobreaks', $nobreaks);
$tpl->assign( 'comments', $comments);
$tpl->assign( 'link', $link);
$tpl->assign( 'address', $address);
$tpl->assign( 'submenu', $submenu);
$tpl->assign( 'blockid', $blockid);
$tpl->assign( 'last_modified' , $last_modified  ) ;
$tpl->assign( 'created' ,  $created ) ;
$tpl->assign( 'html_header' , $myts->makeTboxData4Show( $html_header ) ) ;

$tpl->assign( 'modulename' , $xoopsModule->getVar('name') ) ;
$tpl->assign( 'mod_url' , $mod_url );
$tpl->assign( 'gticket' , 
	$xoopsGTicket->getTicketHtml( __LINE__ , 1800 , $mydirname ) );


// getting "content"
if( $link > 0 ) {

	// external (=wrapped) content
	$wrap_file = "$mymodpath/content/$address" ;
	if( ! file_exists( $wrap_file ) ) {
		redirect_header( XOOPS_URL.'/' , 2 , _TC_FILENOTFOUND ) ;
		exit ;
	}

	ob_start() ;
	include( $wrap_file ) ;
	$content = tc_convert_wrap_to_ie( ob_get_contents() ) ;
	if( $link == TC_WRAPTYPE_CHANGESRCHREF ) 
		$content = tc_change_srchref( $content , XOOPS_URL . "/modules/$mydirname/content" ) ;
	ob_end_clean() ;

} else {

	$content = tc_content_render( $text , $nohtml , $nosmiley , $nobreaks ,  $xoopsModuleConfig['tc_space2nbsp'] ) ;
}

// convert from {X_SITEURL} to XOOPS_URL
$content = str_replace( '{X_SITEURL}' , XOOPS_URL , $content ) ;

$tpl->assign( 'content' , $content ) ;

$main_template = empty( $xPage_singlecontent ) ? "db:tinycontent{$mydirnumber}_edit.html" : "db:tinycontent{$mydirnumber}_index.html" ;

$tpl->display( $main_template ) ;

?>