<?php
// $Id: search.php,v 1.4 2005/08/03 12:39:11 onokazu Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

$xoopsOption['pagetype'] = "search";

include 'mainfile.php';
$config_handler =& xoops_gethandler('config');
$xoopsConfigSearch =& $config_handler->getConfigsByCat(XOOPS_CONF_SEARCH);

$xoopsOption['template_main'] = 'system_search.html';

if ($xoopsConfigSearch['enable_search'] != 1) {
    header('Location: ' . XOOPS_URL . '/index.php');
    exit();
}
$action = "search";
if (!empty($_GET['action'])) {
    $action = $_GET['action'];
} elseif (!empty($_POST['action'])) {
    $action = $_POST['action'];
}

$query = "";
if (!empty($_GET['query'])) {
    $query = trim($_GET['query']);
} elseif (!empty($_POST['query'])) {
    $query = trim($_POST['query']);
}
$andor = "AND";
if (!empty($_GET['andor'])) {
    $andor = $_GET['andor'];
} elseif (!empty($_POST['andor'])) {
    $andor = $_POST['andor'];
}
$mid = $uid = $start = 0;
if (!empty($_GET['mid'])) {
    $mid = intval($_GET['mid']);
} elseif (!empty($_POST['mid'])) {
    $mid = intval($_POST['mid']);
}
if (!empty($_GET['uid'])) {
    $uid = intval($_GET['uid']);
} elseif (!empty($_POST['uid'])) {
    $uid = intval($_POST['uid']);
}
if (!empty($_GET['start'])) {
    $start = intval($_GET['start']);
} elseif (!empty($_POST['start'])) {
    $start = intval($_POST['start']);
}
if (!empty($_GET['mids'])) {
    $mids = $_GET['mids'];
} elseif (!empty($_POST['mids'])) {
    $mids = $_POST['mids'];
}

$queries = array();

if ($action == "results") {
    if ($query == "") {
        redirect_header("search.php", 1, _SR_PLZENTER);
        exit();
    }
} elseif ($action == "showall") {
    if ($query == "" || empty($mid)) {
        redirect_header("search.php", 1, _SR_PLZENTER);
        exit();
    }
} elseif ($action == "showallbyuser") {
    if (empty($mid) || empty($uid)) {
        redirect_header("search.php", 1, _SR_PLZENTER);
        exit();
    }
}

$query = mb_convert_kana($query, 's', _CHARSET);

$groups = is_object($xoopsUser) ? $xoopsUser->getGroups() : XOOPS_GROUP_ANONYMOUS;
$gperm_handler =& xoops_gethandler('groupperm');
$available_modules = $gperm_handler->getItemIds('module_read', $groups);

if ($andor != "OR" && $andor != "exact" && $andor != "AND") {
    $andor = "AND";
}

$myts =& MyTextSanitizer::getInstance();

if ($action == 'search') {
    include XOOPS_ROOT_PATH . '/header.php';
    include 'include/searchform.php';
    $xoopsTpl->assign('formenter', sprintf(_FORM_ENTER, _SR_KEYWORDS));
    $xoopsTpl->assign('keyignore', $xoopsConfigSearch['keyword_min'] == 0 ? '' : sprintf(_SR_KEYIGNORE, $xoopsConfigSearch['keyword_min']));
    include XOOPS_ROOT_PATH . '/footer.php';
    exit();
}

if ($action != 'showallbyuser') {
    if ($andor != "exact") {
        $ignored_queries = array(); // holds kewords that are shorter than allowed minmum length
        $temp_queries = preg_split('/[\s,]+/', $query);
        foreach ($temp_queries as $q) {
            $q = trim($q);
            $length = mb_strlen($q, _CHARSET);
            if ($length >= $xoopsConfigSearch['keyword_min']) {
                $queries[] = $myts->addSlashes($q);
            } else {
                $ignored_queries[] = $myts->addSlashes($q);
            }
        }
        if (count($queries) == 0) {
            redirect_header('search.php', 2, sprintf(_SR_KEYTOOSHORT, $xoopsConfigSearch['keyword_min']));
            exit();
        }
    } else {
        $query = trim($query);
        $length = mb_strlen($query, _CHARSET);
        if ($length < $xoopsConfigSearch['keyword_min']) {
            redirect_header('search.php', 2, sprintf(_SR_KEYTOOSHORT, $xoopsConfigSearch['keyword_min']));
            exit();
        }
        $queries = array($myts->addSlashes($query));
    }
}

switch ($action) {
    case "results":
        $module_handler =& xoops_gethandler('module');
        $criteria = new CriteriaCompo(new Criteria('hassearch', 1));
        $criteria->add(new Criteria('isactive', 1));
        $criteria->add(new Criteria('mid', "(" . implode(',', $available_modules) . ")", 'IN'));
        $modules =& $module_handler->getObjects($criteria, true);
        if (empty($mids) || !is_array($mids)) {
            unset($mids);
            $mids = array_keys($modules);
        }
        include XOOPS_ROOT_PATH . "/header.php";
        $xoopsTpl->assign('action', $myts->htmlSpecialChars($action));
        if ($andor != 'exact') {
            $queries_var = '';
            foreach ($queries as $q) {
                $queries_var .= ' ' . htmlspecialchars(stripslashes($q));
            }
            $xoopsTpl->assign('queries', $queries_var);
            if (!empty($ignored_queries)) {
                $xoopsTpl->assign('ignoredwords', sprintf(_SR_IGNOREDWORDS, $xoopsConfigSearch['keyword_min']));
                foreach ($ignored_queries as $q) {
                    $ignored_queries_var = ' ' . htmlspecialchars(stripslashes($q));
                }
                $xoopsTpl->assign('ignored_queries', $ignored_queries_var);
            }
        } else {
            $xoopsTpl->assign('queries', htmlspecialchars(stripslashes($queries[0])));
        }
        $mod_results = array();
        foreach ($mids as $mid) {
            $mid = intval($mid);
            if (in_array($mid, $available_modules)) {
                $module =& $modules[$mid];
                $results =& $module->search($queries, $andor, 5, 0);
                $mod_results[$mid]['title'] = $myts->makeTboxData4Show($module->getVar('name'));
                $count = count($results);
                if (!is_array($results) || $count == 0) {
                    $mod_results[$mid]['count'] = 0;
                } else {
                    $mod_results[$mid]['count'] = $count;
                    $search_results = array();
                    for ($i = 0; $i < $count; $i++) {
                        $search_results[$i]['dirname'] = $module->getVar('dirname');
                        $search_results[$i]['name'] = $myts->makeTboxData4Show($module->getVar('name'));
                        if (isset($results[$i]['image']) && $results[$i]['image'] != "") {
                            $search_results[$i]['image'] = XOOPS_URL . '/modules/' . $search_results[$i]['dirname'] . '/' . $results[$i]['image'];
                        } else {
                            $search_results[$i]['image'] = XOOPS_URL . "/images/icons/posticon2.gif";
                        }
                        $search_results[$i]['link'] = $results[$i]['link'];
                        $search_results[$i]['title'] = $myts->makeTboxData4Show($results[$i]['title']);
                        $results[$i]['uid'] = intval($results[$i]['uid']);
                        if (!empty($results[$i]['uid'])) {
                            $search_results[$i]['uid'] = $results[$i]['uid'];
                            $search_results[$i]['uname'] = XoopsUser::getUnameFromId($results[$i]['uid']);
                        }
                        $search_results[$i]['time'] = $results[$i]['time'] ? ' (' . formatTimestamp(intval($results[$i]['time'])) . ')' : '';
                    }
                    if ($count == 5) {
                        $mod_results[$mid]['search_url'] = XOOPS_URL . '/search.php?query=' . urlencode(stripslashes(implode(' ', $queries))) . "&amp;mid=$mid&amp;action=showall&amp;andor=$andor";
                    }
                    $mod_results[$mid]['search_results'] = $search_results;
                }
            }
            unset($results);
            unset($module);
        }
        $xoopsTpl->assign('mod_results', $mod_results);

        include 'include/searchform.php';
        $xoopsTpl->assign('formenter', sprintf(_FORM_ENTER, _SR_KEYWORDS));
        $xoopsTpl->assign('keyignore', $xoopsConfigSearch['keyword_min'] == 0 ? '' : sprintf(_SR_KEYIGNORE, $xoopsConfigSearch['keyword_min']));
        break;
    case "showall":
    case 'showallbyuser':
        include XOOPS_ROOT_PATH . "/header.php";
        $module_handler =& xoops_gethandler('module');
        $module =& $module_handler->get($mid);
        $results =& $module->search($queries, $andor, 20, $start, $uid);
        $count = count($results);
        $xoopsTpl->assign('action', $myts->htmlSpecialChars($action));
        if (is_array($results) && $count > 0) {
            $xoopsTpl->assign('count', $count);
            $next_results =& $module->search($queries, $andor, 1, $start + 20, $uid);
            $next_count = count($next_results);
            $has_next = false;
            if (is_array($next_results) && $next_count == 1) {
                $has_next = true;
            }
            if ($action == 'showall') {
                if ($andor != 'exact') {
                    $queries_var = '';
                    foreach ($queries as $q) {
                        $queries_var .= ' ' . htmlspecialchars(stripslashes($q));
                    }
                    $xoopsTpl->assign('queries', $queries_var);
                } else {
                    $xoopsTpl->assign('queries', htmlspecialchars(stripslashes($queries[0])));
                }
            }
            $xoopsTpl->assign('showing', sprintf(_SR_SHOWING, $start + 1, $start + $count));
            $xoopsTpl->assign('mod_name', $myts->makeTboxData4Show($module->getVar('name')));
            $xoopsTpl->assign('mod_dirname', $myts->makeTboxData4Show($module->getVar('dirname')));

            $mod_results = array();
            for ($i = 0; $i < $count; $i++) {
                if (isset($results[$i]['image']) && $results[$i]['image'] != "") {
                    $mod_results[$i]['image'] = XOOPS_URL . '/modules/' . $module->getVar('dirname') . '/' . $results[$i]['image'];
                } else {
                    $mod_results[$i]['image'] = XOOPS_URL . "/images/icons/posticon2.gif";
                }
                $mod_results[$i]['link'] = $results[$i]['link'];
                $mod_results[$i]['title'] = $myts->makeTboxData4Show($results[$i]['title']);
                $results[$i]['uid'] = intval($results[$i]['uid']);
                if (!empty($results[$i]['uid'])) {
                    $mod_results[$i]['uid'] = $results[$i]['uid'];
                    $mod_results[$i]['uname'] = XoopsUser::getUnameFromId($results[$i]['uid']);
                }
                $mod_results[$i]['time'] = $results[$i]['time'] ? ' (' . formatTimestamp(intval($results[$i]['time'])) . ')' : '';
            }
            $xoopsTpl->assign('mod_results', $mod_results);

            $search_url = XOOPS_URL . '/search.php?query=' . urlencode(stripslashes(implode(' ', $queries)));
            $search_url .= "&amp;mid=$mid&amp;action=$action&amp;andor=$andor";
            if ($action == 'showallbyuser') {
                $search_url .= "&amp;uid=$uid";
            }
            $xoopsTpl->assign('start', $start);
            $xoopsTpl->assign('has_next', $has_next);
            if ($start > 0) {
                $prev = $start - 20;
                $xoopsTpl->assign('search_url_prev', htmlspecialchars($search_url . "&amp;start=$prev"));
            }
            if (false != $has_next) {
                $next = $start + 20;
                $xoopsTpl->assign('search_url_next', htmlspecialchars($search_url . "&amp;start=$next"));
            }
        } else {
            $xoopsTpl->assign('count', 0);
        }

        include 'include/searchform.php';
        $xoopsTpl->assign('formenter', sprintf(_FORM_ENTER, _SR_KEYWORDS));
        $xoopsTpl->assign('keyignore', $xoopsConfigSearch['keyword_min'] == 0 ? '' : sprintf(_SR_KEYIGNORE, $xoopsConfigSearch['keyword_min']));
        break;
}
include XOOPS_ROOT_PATH . "/footer.php";
?>