<?php
// $Id: xfsection.php,v 1.3 2006/05/26 21:40:09 ohwada Exp $

//=========================================================
// SmartSection Module
// Convert from XFSection 1.10 to SmartSection 1.05
// 2006-05-25 K.OHWADA
//=========================================================

include_once("admin_header.php");

$importFromModuleName = "XF-Section " . $_POST['from_module_version'];

$scriptname = "xfsection.php";

$op = 'start';

if (isset($_POST['op']) && ($_POST['op'] == 'go'))
{
	$op = $_POST['op'];
}

if ($op == 'start')
{
	include_once XOOPS_ROOT_PATH.'/class/xoopsformloader.php';

	smartsection_xoops_cp_header();
	smartsection_adminMenu(-1, _AM_SSECTION_IMPORT);
	smartsection_collapsableBar('xfsectionimport', 'xfsectionimporticon',  sprintf(_AM_SSECTION_IMPORT_FROM, $importFromModuleName), _AM_SSECTION_IMPORT_INFO);

	$result = $xoopsDB->query ("SELECT COUNT(*) FROM ".$xoopsDB->prefix("xfs_category"));
	list ($totalCat) = $xoopsDB->fetchRow ($result);
	
	if ($totalCat == 0)
	{
		echo "<span style=\"color: #567; margin: 3px 0 12px 0; font-size: small; display: block; \">" . _AM_SSECTION_IMPORT_NOCATSELECTED . "</span>";
	}
	else
	{
		include_once XOOPS_ROOT_PATH . "/class/xoopstree.php";
		
		$result = $xoopsDB->query ("SELECT COUNT(*) FROM ".$xoopsDB->prefix("xfs_article"));
		list ($totalArticles) = $xoopsDB->fetchRow ($result);
		
		If ($totalArticles == 0) {
			echo "<span style=\"color: #567; margin: 3px 0 12px 0; font-size: small; display: block; \">" . sprintf(_AM_SSECTION_IMPORT_MODULE_FOUND_NO_ITEMS, $importFromModuleName, $totalArticles) . "</span>";
		} else {
			echo "<span style=\"color: #567; margin: 3px 0 12px 0; font-size: small; display: block; \">" . sprintf(_AM_SSECTION_IMPORT_MODULE_FOUND, $importFromModuleName, $totalArticles, $totalCat) . "</span>";
			
			$form = new XoopsThemeForm (_AM_SSECTION_IMPORT_SETTINGS, 'import_form',  SMARTSECTION_ADMIN_URL . "/$scriptname");
			
			// Categories to be imported
			$sql = "SELECT cat.id, cat.pid, cat.title, COUNT(art.articleid) FROM ".$xoopsDB->prefix("xfs_category") . " AS cat INNER JOIN ".$xoopsDB->prefix("xfs_article") . " AS art ON cat.id=art.categoryid GROUP BY art.categoryid";
			$result = $xoopsDB->query ($sql);
			$cat_cbox_values = array();
			$cat_cbox_options= array();
			while (list ($cid, $pid, $cat_title, $art_count) = $xoopsDB->fetchRow ($result))
			{
				$cat_title = $myts->displayTarea($cat_title);
				$cat_cbox_options[$cid] = "$cat_title ($art_count)";
			}
			$cat_label = new XoopsFormLabel(_AM_SSECTION_IMPORT_CATEGORIES, implode("<br />", $cat_cbox_options));
			$cat_label->setDescription(_AM_SSECTION_IMPORT_CATEGORIES_DSC);
			$form->addElement ($cat_label);
			
			// SmartFAQ parent category
			$mytree = new XoopsTree($xoopsDB->prefix("smartsection_categories"), "categoryid", "parentid");
			ob_start();
			$mytree->makeMySelBox("name", "weight", $preset_id=0, $none=1, $sel_name="parent_category");
			
			$parent_cat_sel = new XoopsFormLabel(_AM_SSECTION_IMPORT_PARENT_CATEGORY, ob_get_contents());
			$parent_cat_sel->setDescription(_AM_SSECTION_IMPORT_PARENT_CATEGORY_DSC);
			$form->addElement($parent_cat_sel);
			ob_end_clean();
			
			$form->addElement (new XoopsFormHidden('op', 'go'));
			$form->addElement (new XoopsFormButton ('', 'import', _AM_SSECTION_IMPORT, 'submit'));
			
			$form->addElement(new XoopsFormHidden('from_module_version', $_POST['from_module_version']));
			
			$form->display();
		}
	}
	
	smartsection_close_collapsable('xfsectionimport', 'xfsectionimporticon');
	
	exit ();
}

if ($op == 'go')
{
	smartsection_xoops_cp_header();
	smartsection_adminMenu(-1, _AM_SSECTION_IMPORT);
	smartsection_collapsableBar('xfsectionimportgo', 'xfsectionimportgoicon',  sprintf(_AM_SSECTION_IMPORT_FROM, $importFromModuleName), _AM_SSECTION_IMPORT_RESULT);
	
	$cnt_imported_cat = 0;
	$cnt_imported_articles = 0;
	
	$parentId = $_POST['parent_category'];
	
	
	$sql = "SELECT * FROM ".$xoopsDB->prefix("xfs_category")." ORDER by orders";

	$resultCat = $xoopsDB->query ($sql);
	
	$newCatArray = array();
	while ($arrCat = $xoopsDB->fetchArray ($resultCat))
	{
		// insert category into SmartFAQ
		$categoryObj = $smartsection_category_handler->create();

		$newCat = array();
		
		$newCat['oldid'] = $arrCat['id'];
		$newCat['oldpid'] = $arrCat['pid'];		
		
		$categoryObj->setVar ('parentid', $arrCat['pid']);	
		
		$categoryObj->setVar ('weight', $arrCat['orders']);
		$categoryObj->setGroups_read (explode (" ", trim ($arrCat['groupid'])));
		$categoryObj->setGroups_submit (explode (" ", trim ($arrCat['editaccess'])));
		$categoryObj->setVar ('name', $arrCat['title']);
		$categoryObj->setVar ('description', $arrCat['description']);
		
		// Category image
		if (($arrCat['imgurl'] != 'blank.gif') && ($arrCat['imgurl'])) {
			if (copy(XOOPS_ROOT_PATH . "/modules/xfsection/images/category/" . $arrCat['imgurl'], XOOPS_ROOT_PATH . "/uploads/smartsection/images/category/" . $arrCat['imgurl'])) {
				$categoryObj->setVar('image', $arrCat['imgurl']);
			}
		}
		
		if (!$categoryObj->store(false))
		{
			echo sprintf(_AM_SSECTION_IMPORT_CATEGORY_ERROR, $arrCat['title']) . "<br/>";
			continue;
		}
		
		$newCat['newid'] = $categoryObj->categoryid();
		// Saving category permissions
		smartsection_saveCategory_Permissions($categoryObj->getGroups_read(), $categoryObj->categoryid(), 'category_read');
		smartsection_saveCategory_Permissions($categoryObj->getGroups_submit(), $categoryObj->categoryid(), 'item_submit');
		
		$cnt_imported_cat++;
		
		echo sprintf(_AM_SSECTION_IMPORT_CATEGORY_SUCCESS, $categoryObj->name()) . "<br\>";
		
		$sql = "SELECT * FROM ".$xoopsDB->prefix("xfs_article")." WHERE categoryid=" . $arrCat['id'] . " ORDER BY weight";
		$resultArticles = $xoopsDB->query ($sql);
		while ($arrArticle = $xoopsDB->fetchArray ($resultArticles))
		{
			// insert article
			$itemObj =& $smartsection_item_handler->create();
			
			$itemObj->setVar('categoryid', $categoryObj->categoryid());
			$itemObj->setVar('title',     $arrArticle['title']);
			$itemObj->setVar('uid',       $arrArticle['uid']);
			$itemObj->setVar('summary',   $arrArticle['summary']);
			$itemObj->setVar('body',      $arrArticle['maintext']);
			$itemObj->setVar('counter',   $arrArticle['counter']);
			$itemObj->setVar('datesub',   $arrArticle['created']);
			$itemObj->setVar('weight',    $arrArticle['weight']);
			$itemObj->setVar('dohtml',   !$arrArticle['nohtml']);
			$itemObj->setVar('dosmiley', !$arrArticle['nosmiley']);
			$itemObj->setVar('dobr',     !$arrArticle['nobr']);
			$itemObj->setGroups_read (explode (" ", trim ($arrArticle['groupid'])));

// status
			$status = _SSECTION_STATUS_PUBLISHED;
			if ( $arrArticle['offline'] )
			{
				$status = _SSECTION_STATUS_OFFLINE;
			}
			$itemObj->setVar('status', $status);

// HTML Wrap
			if ($arrArticle['htmlpage']) {
				$pagewrap_filename	= XOOPS_ROOT_PATH . "/modules/xfsection/html/" .$arrArticle['htmlpage'];
				if (file_exists($pagewrap_filename)) {
					if (copy($pagewrap_filename, XOOPS_ROOT_PATH . "/uploads/smartsection/content/" . $arrArticle['htmlpage'])) {
						$itemObj->setVar('body', "[pagewrap=" . $arrArticle['htmlpage'] . "]");	
						echo sprintf("&nbsp;&nbsp;&nbsp;&nbsp;" . _AM_SSECTION_IMPORT_ARTICLE_WRAP, $arrArticle['htmlpage']) . "<br/>";
					}
				}
			}
			
			if (!$itemObj->store())
			{
				echo sprintf("  " . _AM_SSECTION_IMPORT_ARTICLE_ERROR, $arrArticle['title']) . "<br/>";
				continue;
			} else {
				// Linkes files
				
				$sql = "SELECT * FROM ".$xoopsDB->prefix("xfs_files")." WHERE articleid=" . $arrArticle['articleid'];
				$resultFiles = $xoopsDB->query ($sql);
				$allowed_mimetypes = '';
				while ($arrFile = $xoopsDB->fetchArray ($resultFiles)) {

					$filename = XOOPS_ROOT_PATH . "/modules/xfsection/cache/uploaded/" . $arrFile['filerealname'];
					if (file_exists($filename)) {
						if (copy($filename, XOOPS_ROOT_PATH . "/uploads/smartsection/" . $arrFile['filerealname'])) {
							$fileObj = $smartsection_file_handler->create();
							$fileObj->setVar('name', $arrFile['fileshowname']);
							$fileObj->setVar('description', $arrFile['filedescript']);
							$fileObj->setVar('status', _SSECTION_STATUS_FILE_ACTIVE);
							$fileObj->setVar('uid', $arrArticle['uid']);
							$fileObj->setVar('itemid', $itemObj->itemid()); 
							$fileObj->setVar('mimetype', $arrFile['minetype']); 
							$fileObj->setVar('datesub', $arrFile['date']); 
							$fileObj->setVar('counter', $arrFile['counter']); 
							$fileObj->setVar('filename', $arrFile['filerealname']); 
							
							if ($fileObj->store($allowed_mimetypes, true, false)) {
								echo "&nbsp;&nbsp;&nbsp;&nbsp;"  . sprintf(_AM_SSECTION_IMPORTED_ARTICLE_FILE, $arrFile['filerealname']) . "<br />";						
							}
						}
					}
				}
				
				$newArticleArray[$arrArticle['articleid']] = $itemObj->itemid();
				echo "&nbsp;&nbsp;"  . sprintf(_AM_SSECTION_IMPORTED_ARTICLE, $itemObj->title()) . "<br />";
				$cnt_imported_articles++;
			}
		}
		$newCatArray[$newCat['oldid']] = $newCat;
		unset($newCat);
		echo "<br/>";
	}
	// Looping through cat to change the pid to the new pid
	foreach($newCatArray as $oldid => $newCat) {
		$criteria = new CriteriaCompo();
		$criteria->add(new Criteria('categoryid', $newCat['newid']));
		$oldpid = $newCat['oldpid'];
		if ($oldpid == 0) {
			$newpid = $parentId;	
		} else {
			$newpid = $newCatArray[$oldpid]['newid'];
		}
		$smartsection_category_handler->updateAll('parentid', $newpid, $criteria);
		unset($criteria);
	}
	
	// Looping through the comments to link them to the new articles and module
	echo "" . _AM_SSECTION_IMPORT_COMMENTS . "<br />";
	
	$module_handler =& xoops_gethandler ('module');
	$moduleObj = $module_handler->getByDirname('xfsection');
	$news_module_id = $moduleObj->getVar('mid');
	
	$moduleObj = $module_handler->getByDirname('smartsection');
	$smartsection_module_id = $moduleObj->getVar('mid');
	
	$comment_handler = xoops_gethandler('comment');
	$criteria = new CriteriaCompo();
	$criteria->add(new Criteria('com_modid', $news_module_id));
	$comments = $comment_handler->getObjects($criteria);
	foreach ($comments as $comment) {
		$comment->setVar('com_itemid', $newArticleArray[$comment->getVar('com_itemid')]);
		$comment->setVar('com_modid', $smartsection_module_id);
		$comment->setNew();
		if (!$comment_handler->insert($comment)) {
			echo "&nbsp;&nbsp;"  . sprintf(_AM_SSECTION_IMPORTED_COMMENT_ERROR, $comment->getVar('com_title')) . "<br />";
		} else {
			echo "&nbsp;&nbsp;"  . sprintf(_AM_SSECTION_IMPORTED_COMMENT, $comment->getVar('com_title')) . "<br />";	
		}
	
	}
	
	echo "<br/><br/>Done.<br/>";
	echo sprintf(_AM_SSECTION_IMPORTED_CATEGORIES, $cnt_imported_cat) . "<br/>";
	echo sprintf(_AM_SSECTION_IMPORTED_ARTICLES, $cnt_imported_articles) . "<br/>";
	echo "<br/><a href='" . SMARTSECTION_URL . "'>" . _AM_SSECTION_IMPORT_GOTOMODULE . "</a><br/>";
	
	smartsection_close_collapsable('xfsectionimportgo', 'xfsectionimportgoicon');
	
	exit ();
}

?>