<?php
// $Id: admin_config_class.php,v 1.14 2007/11/16 15:12:13 ohwada Exp $

// 2007-11-11 K.OHWADA
// build_block_handler
// banner cache_time
// whatsnew_install

// 2007-06-01 K.OHWADA
// check_multi_plugin()

// 2007-05-12 K.OHWADA
// module dupulication
// XC 2.1 system comment
// add class admin_config_store
// WHATSNEW_FIELD_PLUGIN -> 'plugin'

// 2006-06-25 K.OHWADA
// add show_form_plugins() print_form_plugin() more
// change name flag_both to flag_plural_plugins

// 2006-06-20 K.OHWADA
// REQ 3873: login user can read RSS.
// add check_version()

// 2005-11-06 K.OHWADA
// BUG 3169: need to sanitaize $_SERVER['PHP_SELF']

// 2005-10-01 K.OHWADA
// change index.php to class

//=========================================================
// What's New Module
// this file contain 2 class
//   admin_config_form 
//   admin_config_store
// 2004/08/20 K.OHWADA
//=========================================================

//================================================================
// class admin_config_form
//================================================================
class admin_config_form extends whatsnew_config_form
{
// constant
	var $LIMIT_MODULE_DEFAULT = 5;
	var $MAX_ICON_COL         = 5;

// icon
	var $_DIR_ICON_REL = "images/icons";
	var $_DIR_ICON;
	var $_URL_ICON;

// class
	var $_module_handler;
	var $_module_store_handler;
	var $_build_block_handler;
	var $_system;

	var $icon_array;

// variable
	var $_system_module_array;
	var $_line_count = 0;
	var $_is_active_legacy_module = false;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_config_form()
{
	$this->whatsnew_config_form();

	$define =& whatsnew_config_define::getInstance( WHATSNEW_DIRNAME );
	$this->set_config_handler('config', WHATSNEW_DIRNAME, 'whatsnew');
	$this->set_config_define( $define );

// icon
	$this->_DIR_ICON = WHATSNEW_ROOT_PATH . '/' . $this->_DIR_ICON_REL;
	$this->_URL_ICON = WHATSNEW_URL       . '/' . $this->_DIR_ICON_REL;

// class
	$this->_module_handler       =& whatsnew_get_handler('module',       WHATSNEW_DIRNAME );
	$this->_module_store_handler =& whatsnew_get_handler('module_store', WHATSNEW_DIRNAME );
	$this->_build_block_handler  =& whatsnew_get_handler('build_block',  WHATSNEW_DIRNAME );
	$this->_system               =& happy_linux_system::getInstance();

	$this->_is_active_legacy_module = $this->_system->is_active_legacy_module();

// init
	$this->load();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_config_form();
	}
	return $instance;
}

//=========================================================
// main function
//=========================================================
function show_form()
{
// system module config
	$this->_module_store_handler->load_system_module();
	$system_arr  = $this->_module_store_handler->get_system_module();
	$weight_arr  = $this->_module_store_handler->get_system_module_weight();
	$flag_plural = $this->_module_store_handler->get_flag_plural_plugins();

// this modulue'e guest permission
	$mid        = $this->_system->get_mid();
	$perm_guest = $system_arr[$mid]['perm_guest'];

	if (!$perm_guest)
	{
		echo "<h4><font color='red'>"._WHATSNEW_NOTICE."</font></h4>\n";
		echo _WHATSNEW_NOTICE_PERM."\n";
	}

	if ( $flag_plural )
	{
		echo "<h4><font color='red'>"._WHATSNEW_NOTICE."</font></h4>\n";
		echo _WHATSNEW_NOTICE_PLURAL."\n";
		echo "<br />\n";
		$this->show_form_plugins($system_arr, $weight_arr);
	}

	$this->get_icon_array();
	$this->show_form_modules($system_arr, $weight_arr);
}

function show_form_plugins($system_arr, $weight_arr)
{
	echo $this->build_form_begin('whatsnew_plugin');
	echo $this->build_token();
	echo $this->build_html_input_hidden('op',   'save');
	echo $this->build_html_input_hidden('mode', 'module');

	echo '<table class="outer" width="100%">'."\n";
	echo '<tr>';
	echo '<th align="center">'._WHATSNEW_MID.'</th>'."\n";
	echo '<th align="center">'._WHATSNEW_MNAME.'</th>'."\n";
	echo '<th align="center">'._WHATSNEW_MDIR.'</th>'."\n";
	echo '<th align="center">'._WHATSNEW_MOD_VERSION.'</th>'."\n";
	echo '<th align="center">'._WHATSNEW_PLUGIN.'</th>'."\n";
	echo '</tr>'."\n";

// list from system module
	foreach ( $weight_arr as $mid => $weight ) 
	{
		if ($mid != 1)
		{
			$system = $system_arr[$mid];

			if ( $this->check_multi_plugin($system) )
			{
				$this->print_form_plugin($mid, $system);
			}
		}
	}

	echo '<tr class="foot"><td></td><td></td><td colspan="3">';
	echo $this->build_form_submit( 'submit', _HAPPY_LINUX_UPDATE );
	echo '</tr>'."\n";
	echo '</table>'."\n";
	echo $this->build_form_end();
	echo '<br />'."\n";
}

function check_multi_plugin($system)
{
	if (($system['in_module'] && $system['in_whatsnew']) || $system['in_version'])
	{
		return true;
	}
	return false;
}

function show_form_modules($system_arr, $weight_arr)
{
	$this->print_form_top();

// list from system module
	foreach ( $weight_arr as $mid => $weight ) 
	{
		$system = $system_arr[$mid];
		$this->print_form_mod($mid, $system, $weight);
	}

	$this->print_form_middle();

	$this->print_form_conf_two('block_cache_time', 'rss_cache_time');
	$this->print_form_conf_two('block_max_show',   'rss_max_show');
	$this->print_form_conf_two('block_min_show',   'rss_min_show');
	$this->print_form_conf_one('block_limit_summary');
	$this->print_form_conf_two('block_max_summary', 'rss_max_summary');
	$this->print_form_conf_one('block_max_title');
	$this->print_form_conf_checkbox('block_summary_html');

	$this->print_form_conf_checkbox('block_image_flag');
	$this->print_form_conf_one('block_image_width');
	$this->print_form_conf_one('block_image_height');

	$this->print_form_conf_checkbox('block_banner_flag');
	$this->print_form_conf_one('block_banner_width');
	$this->print_form_conf_one('block_banner_height');

	$this->print_form_conf_checkbox('block_ping');
	$this->print_form_conf_icon('block_icon_default');
	$this->print_form_conf_radio('block_module');

	$this->print_form_bottom();
}

function show_icon_list()
{
	$icon_arr = $this->icon_array;

	$count   = count($icon_arr) ;
	$max_col = $count / $this->MAX_ICON_COL;

	echo "<table>\n";

	for ($i=0; $i<$max_col; $i++)
	{
		echo "<tr>";

		for ($j=0; $j<$this->MAX_ICON_COL; $j++)
		{
			$ii   = $this->MAX_ICON_COL * $i + $j;
			$icon = array_shift( $icon_arr );

			if ($icon)
			{
				$url_icon  = $this->_URL_ICON."/".$icon;
				echo "<td> ";
				echo $this->build_html_img_tag($url_icon, 0, 0, 0, $icon);
				echo " $icon </td>";
			}
			else
			{
				echo "<td></td>";
			}
		}

		echo "</tr>\n";

		if ($ii > $count)  break;
	}

	echo "</table>\n";

}

//---------------------------------------------------------
// print html
//---------------------------------------------------------
function print_form_top()
{
	echo $this->build_form_begin('whatsnew_module');
	echo $this->build_token();
	echo $this->build_html_input_hidden('op',   'save');
	echo $this->build_html_input_hidden('mode', 'module');

	echo '<table class="outer" width="100%">'."\n";
	echo '</tr>'."\n";
	echo '<th align="center">'._WHATSNEW_MID.'</th>'."\n";
	echo '<th align="center">'._WHATSNEW_MNAME.'</th>'."\n";
	echo '<th align="center">'._WHATSNEW_MDIR.'</th>'."\n";
	echo '<th align="center">'._WHATSNEW_WEIGHT.'</th>'."\n";
	echo '<th align="center" colspan="2">'._WHATSNEW_NEW.'</th>'."\n";
	echo '<th align="center">'._WHATSNEW_RSS.'</th>'."\n";
	echo '</tr>'."\n";
}

function print_form_mod($mid, $system, $weight)
{
	$this->print_form_even_odd();
	$this->print_form_mod_item( $mid, $system, $weight);
	echo "</tr>\n";
}

function print_form_plugin($mid, $system)
{
	$dirname     = $system['dirname'];
	$name        = $system['name'];
	$version     = $system['version'];

	$name_show    = $this->sanitize_text($name);
	$dirname_show = $this->sanitize_text($dirname);
	$version_show = round($version / 100, 2);
	$plugin_show  = $this->build_form_plugin_select($mid, $dirname);

	$mod_ids = $this->build_html_input_hidden('mod_ids[]', $mid);

	$this->print_form_even_odd();
	echo '<td>'.$mid.' '.$mod_ids.'</td>';
	echo '<td>'.$name_show.'</td>';
	echo '<td>'.$dirname_show.'</td>';
	echo '<td>'.$version_show.'</td>'."\n";
	echo '<td>'.$plugin_show.'</td>';
	echo '</tr>'."\n";
}

function build_form_plugin_select($mid, $dirname)
{
	$text   = '';

	$plugin_file = '';
	$block_show  = 0;
	$rss_show    = 0;
	$block_limit = $this->LIMIT_MODULE_DEFAULT;
	$rss_limit   = $this->LIMIT_MODULE_DEFAULT;
	$block_icon  = '';

	$module =& $this->_module_handler->get($mid);
	if ( is_object($module) )
	{
		$plugin_file = $module->getVar('plugin');
		$block_show  = $module->getVar('block_show');
		$block_limit = $module->getVar('block_limit');
		$rss_show    = $module->getVar('rss_show');
		$rss_limit   = $module->getVar('rss_limit');
		$block_icon  = $module->getVar('block_icon');
	}

	$bracket  = '['.$mid.']';
	$plugins  = $this->_build_block_handler->get_plugins($dirname);
	$flag_checked = false;

	foreach ($plugins as $plug)
	{
		$num   = $plug['num']; 
		$file  = $plug['file']; 
		$title = $plug['title']; 

		$checked    = $this->build_html_checked($plugin_file, $file);
		$file_show  = $this->sanitize_text($file);
		$title_show = $this->sanitize_text($title);
		$url        = 'view_plugin.php?dirname='. $dirname .'&amp;num='. $num;

		if ($checked)
		{
			$flag_checked = true;
		}

		$text .= $this->build_html_input_radio('plugins'.$bracket, $file_show, $checked);
		$text .= $title_show." \n";
		$text .= $this->build_html_a_href_name($url, '[view]', '_blank');
		$text .= "<br />\n";
	}

	if ( !$flag_checked )
	{
		$text .= '<span style="color:#ff0000">Not Select</span> <br />'."\n";
	}

	$text .= $this->build_html_input_hidden('block_shows'.$bracket,  $block_show);
	$text .= $this->build_html_input_hidden('block_limits'.$bracket, $block_limit);
	$text .= $this->build_html_input_hidden('rss_shows'.$bracket,    $rss_show);
	$text .= $this->build_html_input_hidden('rss_limits'.$bracket,   $rss_limit);
	$text .= $this->build_html_input_hidden('block_icons'.$bracket,  $block_icon);

	return $text;
}

function print_form_even_odd()
{
	if ($this->_line_count % 2 == 0) 
	{
		$class = 'even';
	}
	else 
	{
		$class = 'odd';
	}

	$this->_line_count ++;

	echo "<tr class='$class'>";
}

function print_form_mod_item($mid, $system, $weight)
{
	$dirname     = $system['dirname'];
	$name        = $system['name'];
	$in_module   = $system['in_module'];
	$in_whatsnew = $system['in_whatsnew'];
	$in_version  = $system['in_version'];

	$dirname_show = $this->sanitize_text($dirname);
	$mod_ids = $this->build_html_input_hidden('mod_ids[]', $mid);

	$flag_rss     = false;
	$flag_comment = false;

// XC2.1 legacy module exist
	if ( $this->_is_active_legacy_module )
	{
		if ($dirname == 'legacy')
		{
			$flag_comment = true;
			$flag_rss     = true;
		}
		elseif ($dirname == 'system')
		{
			$flag_rss     = false;
		}
		else
		{
			if ($in_module || $in_whatsnew || $in_version) 
			{
				$flag_rss = true;
			}
		}
	}
// xoops 2.0 system module exist	
	else
	{
		if ($dirname == 'system')
		{
			$flag_comment = true;
			$flag_rss     = true;
		}
		else
		{
			if ($in_module || $in_whatsnew || $in_version) 
			{
				$flag_rss = true;
			}
		}
	}

// system comment
	if ($flag_comment)
	{
		$name_show   = $this->build_conf_textbox_by_name('comment_name', 20);
		$weight_show = $this->build_conf_textbox_by_name('comment_weight');
	}
	else
	{
		$name_show   = $this->sanitize_text($name);
		$weight_show = $this->sanitize_text($weight);
	}

	echo "<td>$mid $mod_ids</td>";
	echo "<td>$name_show</td>";
	echo "<td>$dirname_show</td>";
	echo "<td align='center'>$weight_show</td>";

	if ( $flag_rss )
	{
		$this->print_form_mod_block_rss($mid, $system);
	}
	else
	{
		echo "<td></td><td></td><td></td>";
	}
}

function print_form_mod_block_rss($mid, $system)
{
	$perm_guest = $system['perm_guest'];
	$dirname    = $system['dirname'];

	$block_show  = 0;
	$rss_show    = 0;
	$block_limit = $this->LIMIT_MODULE_DEFAULT;
	$rss_limit   = $this->LIMIT_MODULE_DEFAULT;
	$block_icon  = '';
	$plugin_file = '';

	$module =& $this->_module_handler->get($mid);
	if ( is_object($module) )
	{
		$block_show  = $module->getVar('block_show');
		$block_limit = $module->getVar('block_limit');
		$rss_show    = $module->getVar('rss_show');
		$rss_limit   = $module->getVar('rss_limit');
		$block_icon  = $module->getVar('block_icon');
		$plugin_file = $module->getVar('plugin');
	}

	$block_show_show  = $this->make_mod_checkbox($mid, 'block_shows',  $block_show);
	$block_limit_show = $this->make_mod_textbox( $mid, 'block_limits', $block_limit);
	$block_icon_show  = $this->make_mod_icon($mid, $block_icon);
	$rss_show_show    = $this->make_mod_checkbox($mid, 'rss_shows',  $rss_show);
	$rss_limit_show   = $this->make_mod_textbox( $mid, 'rss_limits', $rss_limit);
	$perm_guest_show  = $this->make_mod_perm($perm_guest);

// plugin
	if ( empty($plugin_file) && !$this->check_multi_plugin($system) )
	{
		$plugins = $this->_build_block_handler->get_plugins($dirname);
		if ( isset($plugins[0]['file']) )
		{
			$plugin_file = $plugins[0]['file'];
		}
	}

	$plugin_name   = 'plugins['.$mid.']';
	$plugin_value  = $this->sanitize_text($plugin_file);
	$plugin_hidden = $this->build_html_input_hidden($plugin_name, $plugin_value);

	echo '<td align="right">';
	echo $block_show_show.' '.$block_limit_show.' '.$plugin_hidden;
	echo ' </td><td align="right">';
	echo $block_icon_show;
	echo ' </td>';
	echo '<td align="right">';
	echo $perm_guest_show.' '.$rss_show_show.' '.$rss_limit_show;
	echo ' </td>';
}

function print_form_middle()
{
	echo "<tr><th></th>";
	echo "<th align='center'>"._WHATSNEW_ITEM."</th>";
	echo "<th></th><th></th>";
	echo "<th align='center' colspan='2'>"._WHATSNEW_NEW."</th>";
	echo "<th align='center'>"._WHATSNEW_RSS."</th></tr>\n";
}

function print_form_conf_two($name1, $name2)
{
	$this->print_form_even_odd();

	$name1_show = $this->build_conf_textbox_by_name($name1);
	$name2_show = $this->build_conf_textbox_by_name($name2);
	$this->print_conf_line($name1, $name1_show, $name2_show);
}

function print_form_conf_one($name)
{
	$this->print_form_even_odd();

	$name_show = $this->build_conf_textbox_by_name($name);
	$this->print_conf_line($name, $name_show);
}

function print_form_conf_checkbox($name)
{
	$this->print_form_even_odd();

	$name_show = $this->build_conf_checkbox_by_name($name);
	$this->print_conf_line($name, $name_show);
}

function print_form_conf_radio($name)
{
	$this->print_form_even_odd();

	$title_show = $this->build_conf_title_by_name($name);
	$name_show  = $this->build_conf_radio_select_by_name($name);

	echo "<td></td><td>$title_show</td><td></td><td></td>";
	echo "<td align='left' colspan='2'>$name_show</td>";
	echo "<td></td></tr>\n";
}

function print_form_conf_icon($name)
{
	$this->print_form_even_odd();

	$title_show = $this->build_conf_title_by_name($name);
	$name_show  = $this->build_conf_icon_select_by_name($name);

	echo "<td></td><td>$title_show</td><td></td><td></td>";
	echo "<td></td><td align='right'>$name_show</td>";
	echo "<td></td></tr>\n";
}

function print_conf_line($name, $name1_show, $name2_show='')
{
	$title_show = $this->build_conf_title_by_name($name);

	echo "<td></td><td>$title_show</td><td></td><td></td>";
	echo "<td align='right'>$name1_show</td><td></td>";
	echo "<td align='right'>$name2_show</td></tr>\n";
}

function print_form_bottom()
{
	echo "<tr class='foot' ><td></td><td></td><td colspan='5'>";
	echo $this->build_form_submit( 'submit', _HAPPY_LINUX_UPDATE );
	echo "</tr></table>\n";
	echo $this->build_form_end();
	echo "<br />\n";
}

function print_msg($title)
{
	echo "<h4>$title</h4>\n";
}

function print_error($title, $msg)
{
	echo "<h3><font color='red'>$title</font></h3>\n";
	echo "$msg<br /><br />\n";
}

//---------------------------------------------------------
// make config form
//---------------------------------------------------------
function make_mod_checkbox($mid, $name, $value)
{
	$name_show = $name."[".$mid."]";
	$text = $this->build_form_checkbox_yesno($name_show, $value);
	return $text;
}

function make_mod_textbox($mid, $name, $value, $size=5)
{
	$name_show = $name."[".$mid."]";
	return $this->build_html_input_text($name_show, $value, $size);
}

function make_mod_icon($mid, $block_icon)
{
	$text = '';
	$text .= $this->make_mod_icon_img($block_icon)."\n";
	$text .= $this->make_mod_icon_select($mid, $block_icon);
	return $text;
}

function make_mod_icon_img($icon)
{
	$file_icon = $this->_DIR_ICON."/".$icon;
	$url_icon  = $this->_URL_ICON."/".$icon;

	if ( empty($icon) || !file_exists($file_icon) )  return '';

	$text = $this->build_html_img_tag($url_icon, 0, 0, 0, $icon);
	return $text;
}

function make_mod_icon_select($mid, $value)
{
	$name_show = "block_icons[".$mid."]";
	return $this->build_html_select($name_show, $value, $this->icon_array, 1);
}

function make_mod_perm($perm)
{
	if ($perm)
	{
		return "<b>#</b>";
	}
	return '';
}

//---------------------------------------------------------
// make config by name
//---------------------------------------------------------

function build_conf_icon_select_by_name($name)
{
	$id    = $this->get_by_name($name, 'conf_id');
	$value = $this->get_by_name($name, 'value');
	$text  = $this->make_mod_icon_img($value);
	$text .= $this->build_html_select($name, $value, $this->icon_array);
	$text .= $this->build_conf_hidden($id);
	return $text;
}

//---------------------------------------------------------
// icon
//---------------------------------------------------------
function get_icon_array()
{
	$this->icon_array =& $this->_system->get_img_list_as_array( $this->_DIR_ICON );
}

//---------------------------------------------------------
// view_plugin
//---------------------------------------------------------
function view_plugin($dirname, $num)
{
	$plugins = $this->_build_block_handler->get_plugins($dirname);

	if ( isset($plugins[$num]['file']) )
	{
		$file = $plugins[$num]['file'];
	}
	else
	{
		echo "no plugin file: $dirname";
		return false;
	}

	$file_plugin  = XOOPS_ROOT_PATH.'/'.$file;

	if ( file_exists($file_plugin) )
	{
		highlight_file($file_plugin);
	}
	else
	{
		echo "no plugin file: $file_plugin";
		return false;
	}

	return;
}

//---------------------------------------------------------
// show form rss cache clear
//---------------------------------------------------------
function show_form_rss_cache_clear( $title )
{
	$time = sprintf( "%.1f", ( $this->get_value_by_name('rss_cache_time')/3600 ) );
	$desc = sprintf( _HAPPY_LINUX_CONF_RSS_CACHE_CLEAR_TIME, $time );

	echo $this->build_lib_box_button_style( $title, $desc, 'rss_cache_clear', _HAPPY_LINUX_CLEAR );
	echo "<br />\n";
}

function show_form_template_compiled_clear( $title )
{
	$desc = sprintf( _HAPPY_LINUX_CONF_TPL_COMPILED_CLEAR_DIR, 'template/parts/ template/xml/' );
	echo $this->build_lib_box_button_style( $title, $desc, 'template_compiled_clear', _HAPPY_LINUX_CLEAR );
	echo "<br />\n";
}

// --- class end ---
}

//================================================================
// class admin_config_store
//================================================================
class admin_config_store extends happy_linux_error
{

// handler
	var $_config_store_handler;
	var $_module_store_handler;
	var $_install;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_config_store()
{
	$this->happy_linux_error();

	$this->_config_store_handler =& whatsnew_get_handler('config_store', WHATSNEW_DIRNAME );
	$this->_module_store_handler =& whatsnew_get_handler('module_store', WHATSNEW_DIRNAME );
	$this->_install              =& whatsnew_install::getInstance(       WHATSNEW_DIRNAME );
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_config_store();
	}
	return $instance;
}

//---------------------------------------------------------
// init config
//---------------------------------------------------------
function check_init()
{
	if ( !$this->_install->check_install() )
	{	return false;	}

	if ( !$this->_check_init_module() )
	{	return false;	}

	return true;
}

function init()
{
	$this->_clear_errors();

	$ret = $this->_install->install();
	if ( !$ret )
	{
		$this->_set_errors( $this->_install_handler->get_message() );
	}

	if ( !$this->_check_init_module() )
	{
		$ret = $this->_module_store_handler->init();
		if ( !$ret )
		{
			$this->_set_errors( $this->_module_store_handler->getErrors() );
		}
	}

	return $this->returnExistError();
}

//---------------------------------------------------------
// upgrade config
//---------------------------------------------------------
function check_version()
{
	if ( !$this->_install->check_update() )
	{	return false;	}

	return true;
}

function upgrade()
{
	$this->_clear_errors();

	$ret = $this->_install->update();
	if ( !$ret )
	{
		$this->_set_errors( $this->_install_handler->get_message() );
	}

	return $this->returnExistError();
}

//---------------------------------------------------------
// save config
//---------------------------------------------------------
function save()
{
	$ret = $this->_module_store_handler->save();
	if ( !$ret )
	{
		$this->_set_errors( $this->_module_store_handler->getErrors() );
	}

	$ret = $this->_config_store_handler->save();
	if ( !$ret )
	{
		$this->_set_errors( $this->_config_store_handler->getErrors() );
	}

	if ( $this->_config_store_handler->check_post_form_catid(3) )
	{
		$ret = $this->_config_store_handler->save_siteinfo();
		if ( !$ret )
		{
			$this->_set_errors( $this->_config_store_handler->getErrors() );
		}
	}

	return true;
}

//---------------------------------------------------------
// check module
//---------------------------------------------------------
function _check_init_module()
{
	$num = $this->_module_store_handler->_handler->getCount();
// no record
	if ( $num == 0 )
	{
		$this->_module_store_handler->load_system_module();
		$flag_exist = $this->_module_store_handler->get_flag_exist();
// module exist
		if ($flag_exist)
		{
			return false;
		}
	}
	return true;
}

//---------------------------------------------------------
// rss cache clear
//---------------------------------------------------------
function rss_cache_clear()
{
	include_once WHATSNEW_ROOT_PATH.'/api/api_pda.php';

	$rss_builder =& whatsnew_rss_builder::getInstance( WHATSNEW_DIRNAME );
	$pda_builder =& whatsnew_pda_builder::getInstance( WHATSNEW_DIRNAME );

	$rss_builder->clear_all_guest_cache();
	$pda_builder->clear_all_guest_cache();
}

function template_compiled_clear()
{
	include_once XOOPS_ROOT_PATH.'/modules/happy_linux/api/module_install.php';
	include_once WHATSNEW_ROOT_PATH.'/class/whatsnew_install.php';

	$install =& whatsnew_install::getInstance( WHATSNEW_DIRNAME );
	$install->clear_all_template();

}

// --- class end ---
}

?>