<?php
// $Id: rssc_view_param.php,v 1.7 2007/08/09 11:08:37 ohwada Exp $

// 2007-08-01 K.OHWADA
// get_module_header()

// 2007-06-01 K.OHWADA
// happy_linux_rss_viewer
// add create() view_format_sanitize_feed_rows()
// use get_cache_ltype_by_item()

// 2006-09-01 K.OHWADA
// add view_format_sanitize_single_feed_obj() : remove view_format_sanitize_feeds()
// add get_get_keywords()
// highlight_keyword

// 2006-07-22 K.OHWADA
// page title

// 2006-07-10 K.OHWADA
// use happy_linux_error happy_linux_post etc

// 2006-06-04 K.OHWADA
// add view_format_sanitize() etc

//=========================================================
// Rss Center Module
// 2006-01-01 K.OHWADA
//=========================================================

// === class begin ===
if( !class_exists('rssc_view_param') ) 
{

//=========================================================
// class rssc_view_param
//=========================================================
class rssc_view_param extends happy_linux_rss_viewer
{
	var $_DIRNAME;

// handler
	var $_link_handler;
	var $_feed_handler;

// input parameter
	var $_feed_order = RSSC_C_ORDER_TEXT_UPDATED;
	var $_feed_start =  0;
	var $_feed_limit = 10;
	var $_flag_sanitize  = false;
	var $_flag_ltype     = false;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rssc_view_param( $dirname )
{
	$this->_DIRNAME = $dirname;

	$this->happy_linux_rss_viewer();

// handler
	$this->_link_handler =& rssc_get_handler('link_basic',  $dirname);
	$this->_feed_handler =& rssc_get_handler('feed_basic',  $dirname);
}

function &getInstance( $dirname )
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new rssc_view_param( $dirname );
	}
	return $instance;
}

//---------------------------------------------------------
// view sanitize
//---------------------------------------------------------
function &view_format_sanitize_feed_objs( &$feed_objs, $flag_sanitize=true )
{
	$feeds = array();
	if ( is_array($feed_objs) && ( count($feed_objs) > 0 ) )
	{
		foreach ($feed_objs as $obj)
		{
			$feeds[] =& $this->view_format_sanitize_single_feed_obj( $obj, $flag_sanitize );
		}
	}
	return $feeds;
}

function &view_format_sanitize_single_feed_obj( &$feed_obj, $flag_sanitize=true )
{
	$feed = array();
	if ( is_object($feed_obj) )
	{
		$feed =& $this->view_format_sanitize_single_feed( $feed_obj->getVarAll(), $flag_sanitize );
	}
	return $feed;
}

function &view_format_sanitize_feed_rows( &$feed_rows, $flag_sanitize=true )
{
	$feeds = array();
	if ( is_array($feed_rows) && ( count($feed_rows) > 0 ) )
	{
		foreach ($feed_rows as $row)
		{
			$feeds[] =& $this->view_format_sanitize_single_feed_row( $row, $flag_sanitize );
		}
	}
	return $feeds;
}

function &view_format_sanitize_single_feed_row( &$feed_row, $flag_sanitize=true )
{
	$feed = array();
	if ( is_array($feed_row) )
	{
		$feed =& $this->view_format_sanitize_single_feed( $feed_row, $flag_sanitize );
	}
	return $feed;
}

function &view_format_sanitize_single_feed( &$item, $flag_sanitize=true )
{
	$feed =& $this->view_format_sanitize_single_item( $item, $flag_sanitize );
	if ( $this->_flag_ltype && isset($item['lid']) )
	{
		$feed['ltype'] = $this->_link_handler->get_cache_ltype_by_lid( $item['lid'] );
	}
	return $feed;
}

//---------------------------------------------------------
// set and get property
//---------------------------------------------------------
function setFeedOrder($value)
{
	switch ( intval($value) )
	{
		case RSSC_C_ORDER_INT_PUBLISHED:
			$order = RSSC_C_ORDER_TEXT_PUBLISHED;
			break;

		case RSSC_C_ORDER_INT_UPDATED:
		default:
			$order = RSSC_C_ORDER_TEXT_UPDATED;
			break;
	}

	$this->_feed_order = $order;
}

function setFeedStart($value)
{
	$this->_feed_start = intval($value);
}

function setFeedLimit($value)
{
	$this->_feed_limit = intval($value);
}

function setFlagSanitize($value)
{
	$this->_flag_sanitize = (bool)$value;
}

function set_flag_ltype($value)
{
	$this->_flag_ltype = (bool)$value;
}

function setFutureDays($value)
{
	$this->_feed_handler->set_future($value);
}

//---------------------------------------------------------
// xoops_module_header
//---------------------------------------------------------
function get_module_header()
{
	$url  = XOOPS_URL . '/modules/' . $this->_DIRNAME . '/rssc.css';
	$text = '<link href="'. $url . '" rel="stylesheet" type="text/css" media="all" />';
	return $text."\n";
}

// --- class end ---
}

// === class end ===
}

?>