<?php

//=========================================================
// myalbum Module
// 2007-07-16 K.OHWADA <http://linux2.ohwada.net/>
//=========================================================

//---------------------------------------------------------
// usage
// rss.php?mode=xxx
// mode : leatst (default),  random
//---------------------------------------------------------

include 'header.php';

include_once XOOPS_ROOT_PATH.'/class/template.php';
include_once XOOPS_ROOT_PATH.'/modules/'.$mydirname.'/blocks/myalbum_rphoto.php';

myalbum_show_rss( $mydirname );
exit();
// === main end ===

//---------------------------------------------------------
// modify from backend.php
//---------------------------------------------------------
function myalbum_show_rss( $mydirname )
{
	global $xoopsConfig, $xoopsModule;

	$LOGO = 'images/logo.gif';
	$PHOTO_NUM = 20;

	$mode = '';
	if ( isset($_GET['mode']) )
	{
		$mode = $_GET['mode'];
	}

	switch ( $mode )
	{
		case 'random':
			$TEMPLATE   = XOOPS_ROOT_PATH.'/modules/'.$mydirname.'/templates/rss_random.html';
			$CACHE_TIME = 0;	// 1 min
			break;

		case 'leatest':
		default:
			$TEMPLATE   = XOOPS_ROOT_PATH.'/modules/'.$mydirname.'/templates/rss_leatest.html';
			$CACHE_TIME = 0;	// 1 hour
			break;
	}

	if (function_exists('mb_http_output')) 
	{
		mb_http_output('pass');
	}

	header ('Content-Type:text/xml; charset=utf-8');

	$tpl = new XoopsTpl();
	
	if ( $CACHE_TIME > 0 )
	{
		$tpl->xoops_setCaching(2);
		$tpl->xoops_setCacheTime( $CACHE_TIME );
	}

	if ( !$tpl->is_cached( $TEMPLATE ) || ($CACHE_TIME == 0) ) 
	{
		$dimention = getimagesize( XOOPS_ROOT_PATH.'/'.$LOGO );
		if (empty($dimention[0])) {
			$width = 88;
		} else {
			$width = ($dimention[0] > 144) ? 144 : $dimention[0];
		}
		if (empty($dimention[1])) {
			$height = 31;
		} else {
			$height = ($dimention[1] > 400) ? 400 : $dimention[1];
		}

		$title = htmlspecialchars( $xoopsConfig['sitename'], ENT_QUOTES );
		$link  = XOOPS_URL.'/';

		$tpl->assign('channel_title', myalbum_utf8( $title ) );
		$tpl->assign('channel_link',  myalbum_utf8( $link ) );
		$tpl->assign('channel_description', myalbum_utf8( htmlspecialchars($xoopsConfig['slogan'], ENT_QUOTES)));
		$tpl->assign('channel_lastbuild', date( 'r', time() ) );
		$tpl->assign('channel_webmaster', $xoopsConfig['adminmail']);
		$tpl->assign('channel_managingeditor',  $xoopsConfig['adminmail']);
		$tpl->assign('channel_category',  myalbum_utf8( $xoopsModule->name() ) );
		$tpl->assign('channel_generator', 'XOOPS');
		$tpl->assign('channel_language',  _LANGCODE);
		$tpl->assign('channel_docs',      'http://backend.userland.com/rss/' );

		$tpl->assign('image_url',    XOOPS_URL.'/'.$LOGO );
		$tpl->assign('image_title',  myalbum_utf8( $title ) );
		$tpl->assign('image_link',   myalbum_utf8( $link ) );
		$tpl->assign('image_width',  $width);
		$tpl->assign('image_height', $height);

		switch ( $mode )
		{
			case 'random':
				$items =& myalbum_get_random( $mydirname, $PHOTO_NUM );
				break;

			case 'leatest':
			default:
				$items =& myalbum_get_latest( $mydirname, $PHOTO_NUM );
				break;
		}

		foreach ($items as $item) 
		{
			$arr = array();
			foreach( $item as $k => $v )
			{
				$arr[$k] = myalbum_utf8( $v );
			}
			$tpl->append('items', $arr);
		}
	}

	$tpl->display( $TEMPLATE );
}

//---------------------------------------------------------
// modify from modules/whatsnew/plugins/myalbum/data.inc.php
//---------------------------------------------------------
function &myalbum_get_latest( $mydirname, $photo_num )
{
	global $xoopsDB ;
	$myts =& MyTextSanitizer::getInstance();

	$MOD_PATH = XOOPS_ROOT_PATH .'/modules/'. $mydirname;
	$MOD_URL  = XOOPS_URL       .'/modules/'. $mydirname;

//	setting $table_photos, $table_cat, $thumbs_dir
	include $MOD_PATH .'/include/read_configs.php';

	$sql = "SELECT p.lid, p.cid, p.title as ptitle, p.ext, p.hits, p.submitter, p.date, t.description, c.title as ctitle FROM $table_photos p, $table_text t, $table_cat c WHERE t.lid=p.lid AND p.cid=c.cid AND p.status>0 ORDER BY p.date DESC";

	$result = $xoopsDB->query( $sql , $photo_num , 0 ) ;
	$ret = array() ;

	while( $row = $xoopsDB->fetchArray($result) ) 
	{
		$lid  = $row['lid'];
		$ext  = $row['ext'];
		$file = $lid.'.'.$ext;

		$context = $myts->displayTarea($row['description'], 0, 1, 1, 1, 1);

		$content_url   = $photos_url.'/'.$file;
		$thumbnail_url = $thumbs_url.'/'.$file;

		list($content_width, $content_height, $content_type)
			= myalbum_get_imagesize( $photos_dir.'/'.$file );

		list($thumbnail_width, $thumbnail_height, $thumbnail_type)
			= myalbum_get_imagesize( $thumbs_dir.'/'.$file );

		$item = array(
			'context'  => $context,
			'link'     => $MOD_URL .'/photo.php?lid='. $lid ,
			'title'    => $row['ptitle'],
			'category' => $row['ctitle'],
			'pubdate'  => date('r', $row['date'] ), 
			'media_content_url'      => $content_url,
			'media_content_height'   => $content_height,
			'media_content_width'    => $content_width,
			'media_content_type'     => $content_type,
			'media_thumbnail_url'    => $thumbnail_url,
			'media_thumbnail_height' => $thumbnail_height,
			'media_thumbnail_width'  => $thumbnail_width,
		);

		$ret[] = myalbum_format_item( $item );

	}

	return $ret;
}

//---------------------------------------------------------
// use b_myalbum_rphoto_show
//---------------------------------------------------------
function &myalbum_get_random( $mydirname, $photo_num )
{
	global $xoopsDB;
	$myts =& MyTextSanitizer::getInstance();

	$options = array(
		0 => $mydirname,	// dirname
		1 => 140,	// box_size
		2 => $photo_num,	// photos_num
		3 => 0,		// category
		4 => 1,		// sub category
		5 => 60,	// cycle (sec)
		6 => 1,		// cols
	);

	$block = b_myalbum_rphoto_show( $options );

	include XOOPS_ROOT_PATH.'/modules/'.$mydirname.'/include/read_configs.php';

	$ret = array();

	foreach( $block['photo'] as $photo )
	{
		$lid  = intval( $photo['lid'] );
		$cid  = intval( $photo['cid'] );
		$ext  = $photo['ext'];
		$file = $lid.'.'.$ext;

		$sql = "SELECT description FROM ".$table_text." WHERE lid=".$lid;
		$res = $xoopsDB->query( $sql );
		$row = $xoopsDB->fetchArray( $res );

		$context = $myts->displayTarea( $row['description'] , 0 , 1 , 1 , 1 , 1 );

		$link          = XOOPS_URL.'/modules/'.$mydirname.'/photo.php?lid='.$lid.'&amp;cid='.$cid;
		$content_url   = $photos_url.'/'.$file;
		$thumbnail_url = $thumbs_url.'/'.$file;

		list($content_width, $content_height, $content_type)
			= myalbum_get_imagesize( $photos_dir.'/'.$file );

		list($thumbnail_width, $thumbnail_height, $thumbnail_type)
			= myalbum_get_imagesize( $thumbs_dir.'/'.$file );

		$item = array(
			'context'     => $context,
			'link'        => $link,
			'title'       => $photo['title'],
			'category'    => $photo['cat_title'],
			'pubdate'     => date('r', $photo['unixtime'] ), 
			'media_content_url'      => $content_url,
			'media_content_height'   => $content_height,
			'media_content_width'    => $content_width,
			'media_content_type'     => $content_type,
			'media_thumbnail_url'    => $thumbnail_url,
			'media_thumbnail_height' => $thumbnail_height,
			'media_thumbnail_width'  => $thumbnail_width,
		);

		$ret[] = myalbum_format_item( $item );
	}

	return $ret ;
}

//---------------------------------------------------------
// utility
//---------------------------------------------------------
function &myalbum_format_item( &$item )
{
	$MAX_SUMMARY = 500;

	$arr =& $item;

	$context = $arr['context'];
	$summary = myalbum_build_summary( $context, $MAX_SUMMARY );

	$img  = '<img src="'. $arr['media_thumbnail_url'];
	$img .= '" width="'.  $arr['media_thumbnail_width'];
	$img .= '" height="'. $arr['media_thumbnail_height'];
	$img .= '" alt="'. $arr['title'] .'">';

	$desc = '<a href="'. $arr['link'] .'" target="_blank">'. $img .'</a><br />';

	if ( strlen($context) > $MAX_SUMMARY ) {
		$desc .= $summary;
	} else {
		$desc .= $context;
	}

	$arr['guid']              = $arr['link'];
	$arr['description']       = htmlspecialchars($desc,    ENT_QUOTES);
	$arr['media_description'] = htmlspecialchars($summary, ENT_QUOTES);

	$arr['media_group'] = 'yes';
	$arr['media_title'] = $arr['title'];

	$arr['media_thumbnail_large_url']    = $arr['media_content_url'];
	$arr['media_thumbnail_large_height'] = $arr['media_content_height'];
	$arr['media_thumbnail_large_width']  = $arr['media_content_width'];

	return $arr;
}

function myalbum_get_imagesize( $filename )
{
	$width  = '';
	$height = '';
	$type   = '';

	$size = getimagesize( $filename ) ;
	if ($size)
	{
		$width  = intval( $size[0] );
		$height = intval( $size[1] );
		$type   = $size['mime'];
	}

	return array($width, $height, $type);
}

function myalbum_build_summary( $str, $max )
{
	$str = str_replace(">",   "> ", $str);
	$str = strip_tags( $str );

	if ( strlen($str) > $max )
	{
		if ( function_exists('mb_strcut') ) {
			$str = mb_strcut($str, 0, $max);
		} else {
			$str = substr($str, 0, $max);
		}
		$str .= '...';
	}

	return $str;
}

function myalbum_utf8($str)
{
	if ( function_exists('mb_convert_encoding') ) {
		$str = mb_convert_encoding($str, 'UTF-8', _CHARSET);
	} else {
		$str = utf8_encode($str);
	}
	return $str;
}

?>