<?php
// $Id: admin_config_class.php,v 1.12 2007/06/10 16:12:46 ohwada Exp $

// 2007-06-01 K.OHWADA
// create_table: xml word

// 2006-11-08 K.OHWADA
// proxy server
// use build_conf_table_xxx

// 2006-09-20 K.OHWADA
// use XoopsGTicket
// add check_version_config_040()
// add main_search_title_html
// use build_lib_box_button_style()
// show blog

// 2006-07-10 K.OHWADA
// use happy_linux_config_form happy_linux_config_store_handler etc
// change make_xxx to build_xxx
// add check_version() for v0.30

// 2006-06-04 K.OHWADA
// change to contant RSSC_DIRNAME

// 2006-04-17 K.OHWADA
// suppress notice : Only variable references should be returned by reference

//=========================================================
// RSS Center Module
// this file contain 2 class
//   admin_config_form 
//   admin_config_store
// 2006-01-01 K.OHWADA
//=========================================================

class admin_config_form extends happy_linux_config_form
{

// local
	var $_line_count = 0;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_config_form()
{
	$this->happy_linux_config_form();

	$define =& rssc_config_define::getInstance();
	$this->set_config_handler('config', RSSC_DIRNAME, 'rssc');
	$this->set_config_define( $define );

// init
	$this->load();

}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_config_form();
	}
	return $instance;
}

//=========================================================
// main function
//=========================================================
function init_form()
{
	// dummy
}

function show_main()
{
	echo $this->build_conf_table_begin('rssc_config_main');
	echo $this->build_conf_table_head(   4, _RSSC_SEARCH,               _RSSC_HEADLINE,                _RSSC_SINGLE_LINK,        _RSSC_SINGLE );
	echo $this->build_conf_table_textbox(4, 'main_search_min');
	echo $this->build_conf_table_textbox(4, '',                         'main_headline_links_perpage');
	echo $this->build_conf_table_textbox(4, 'main_search_perpage',      'main_headline_feeds_perpage', 'main_link_feeds_perlink');
	echo $this->build_conf_table_yesno(  4, 'main_search_title_html',   'main_headline_title_html',    'main_link_title_html',   'main_single_title_html');
	echo $this->build_conf_table_yesno(  4, 'main_search_content_html', 'main_headline_content_html',  'main_link_content_html', 'main_single_content_html');
	echo $this->build_conf_table_textbox(4, 'main_search_max_title',    'main_headline_max_title',     'main_link_max_title',    'main_single_max_title');
	echo $this->build_conf_table_textbox(4, 'main_search_max_content',  'main_headline_max_content',   'main_link_max_content',  'main_single_max_content');
	echo $this->build_conf_table_textbox(4, 'main_search_max_summary',  'main_headline_max_summary',   'main_link_max_summary',  'main_single_max_summary');
	echo $this->build_conf_table_select( 4, 'main_search_order',        'main_headline_order',         'main_link_order');
	echo $this->build_conf_table_end(    4 );
}

function show_block()
{
	echo $this->build_conf_table_begin('rssc_config_block');
	echo $this->build_conf_table_head(   3, _MI_RSSC_BNAME_LATEST,      _MI_RSSC_BNAME_BLOG,      _MI_RSSC_BNAME_HEADLINE);
	echo $this->build_conf_table_textbox(3, '',                         'block_blog_lid',         '');
	echo $this->build_conf_table_textbox(3, '',                         '',                       'block_headline_links_perpage');
	echo $this->build_conf_table_textbox(3, 'block_latest_perpage',     'block_blog_perpage',     'block_headline_feeds_perlink');
	echo $this->build_conf_table_textbox(3, 'block_latest_max_title',   'block_blog_max_title',   'block_headline_max_title');
	echo $this->build_conf_table_textbox(3, 'block_latest_max_summary', 'block_blog_max_summary', 'block_headline_max_summary');
	echo $this->build_conf_table_textbox(3, 'block_latest_max_content', 'block_blog_max_content', 'block_headline_max_content');
	echo $this->build_conf_table_textbox(3, 'block_latest_num_content', 'block_blog_num_content', 'block_headline_num_content');
	echo $this->build_conf_table_select( 3, 'block_latest_order',       'block_blog_order',       'block_headline_order');
	echo $this->build_conf_table_end(    3 );
}

//---------------------------------------------------------
// print form init
//---------------------------------------------------------
function print_form_init()
{
	echo "<br />\n";
	echo $this->build_lib_box_button_style( _AM_RSSC_INIT_EXEC, '', 'init', _SAVE );
	echo "<br />\n";
}

//---------------------------------------------------------
// print form upgrade
//---------------------------------------------------------
function print_form_upgrade()
{
	echo "<br />\n";
	echo $this->build_lib_box_button_style( _AM_RSSC_UPGRADE_EXEC, '', 'upgrade', _SAVE );
	echo "<br />\n";
}

//---------------------------------------------------------
// kakasi
//---------------------------------------------------------
function print_executable_kakasi()
{
	$kakasi      =& happy_linux_kakasi::getInstance();
	$kakasi_path =  $this->_config_define_handler->get_by_name('kakasi_path', 'value');

	if ( $kakasi->is_executable_kakasi( $kakasi_path ) )
	{
		echo '<span style="color:#0000ff">'._AM_RSSC_KAKASI_EXECUTABLE."</span><br /><br />\n";
	}
	else
	{
		echo '<span style="color:#ff0000">'._AM_RSSC_KAKASI_NOT_EXECUTABLE."</span><br /><br />\n";
	}
}

// --- class end ---
}

//================================================================
// class admin_config
//================================================================
class admin_config_store extends happy_linux_error
{

// handler
	var $_store_handler;
	var $_feed_handler;
	var $_black_handler;
	var $_white_handler;
	var $_xml_handler;
	var $_word_handler;

	var $_admin_table;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function admin_config_store()
{
	$this->happy_linux_error();

// config_store_handler
	$define =& rssc_config_define::getInstance();
	$this->_store_handler =& happy_linux_config_store_handler::getInstance();
	$this->_store_handler->set_handler('config', RSSC_DIRNAME, 'rssc');
	$this->_store_handler->set_define( $define );

	$this->_feed_handler  =& rssc_get_handler('feed',  RSSC_DIRNAME);
	$this->_black_handler =& rssc_get_handler('black', RSSC_DIRNAME);
	$this->_white_handler =& rssc_get_handler('white', RSSC_DIRNAME);
	$this->_xml_handler   =& rssc_get_handler('xml',   RSSC_DIRNAME);
	$this->_word_handler  =& rssc_get_handler('word',  RSSC_DIRNAME);

	$this->_admin_table   =& admin_table::getInstance();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new admin_config_store();
	}

	return $instance;
}

//---------------------------------------------------------
// init config
//---------------------------------------------------------
function check_init()
{
	if ( !$this->_check_version_config_040() )
	{	return false;	}

	if ( !$this->_check_init_config() )
	{	return false;	}

	if ( !$this->_exists_xml_table() )
	{	return false;	}

	if ( !$this->_exists_word_table() )
	{	return false;	}

	return true;
}

function init()
{
	$this->_clear_errors();

	if ( !$this->_check_version_config_040() )
	{
		$ret = $this->_store_handler->_handler->add_column_table_040();
		if ( !$ret )
		{
			$this->_set_errors( $this->_store_handler->_handler->getErrors() );
		}
	}

	if ( !$this->_check_init_config() )
	{
		$ret = $this->_store_handler->init();
		if ( !$ret )
		{
			$this->_set_errors( $this->_store_handler->getErrors() );
		}
	}

	if ( !$this->_exists_xml_table() )
	{
		$ret = $this->_xml_handler->create_table();
		if ( !$ret )
		{
			$this->_set_errors( $this->_xml_handler->getErrors() );
		}

// copy if new create
		$ret = $this->_admin_table->copy_link_to_xml();
		if ( !$ret )
		{
			$this->_set_errors( $this->_admin_table->getErrors() );
		}
	}

	if ( !$this->_exists_word_table() )
	{
		$ret = $this->_word_handler->create_table();
		if ( !$ret )
		{
			$this->_set_errors( $this->_word_handler->getErrors() );
		}
	}

	return $this->returnExistError();
}

//---------------------------------------------------------
// upgrade config
//---------------------------------------------------------
function check_version()
{
	if ( !$this->_check_version_config() )
	{	return false;	}

	if ( !$this->_check_version_feed_030() )
	{	return false;	}

	if ( !$this->_check_version_feed_060() )
	{	return false;	}

	if ( !$this->_check_version_black_060() )
	{	return false;	}

	if ( !$this->_check_version_white_060() )
	{	return false;	}

	return true;
}

function upgrade()
{
	$this->_clear_errors();

	if ( !$this->_check_version_config() )
	{
		$ret = $this->_store_handler->upgrade();
		if ( !$ret )
		{
			$this->_set_errors( $this->_store_handler->getErrors() );
		}
	}

	if ( !$this->_check_version_feed_030() )
	{
		$ret = $this->_feed_handler->add_column_table_030();
		if ( !$ret )
		{
			$this->_set_errors( $this->_feed_handler->getErrors() );
		}
	}

	if ( !$this->_check_version_feed_060() )
	{
		$ret = $this->_feed_handler->add_column_table_060();
		if ( !$ret )
		{
			$this->_set_errors( $this->_feed_handler->getErrors() );
		}
	}

	if ( !$this->_check_version_black_060() )
	{
		$ret = $this->_black_handler->add_column_table_060();
		if ( !$ret )
		{
			$this->_set_errors( $this->_black_handler->getErrors() );
		}
	}

	if ( !$this->_check_version_white_060() )
	{
		$ret = $this->_white_handler->add_column_table_060();
		if ( !$ret )
		{
			$this->_set_errors( $this->_white_handler->getErrors() );
		}
	}

	return $this->returnExistError();
}

//---------------------------------------------------------
// save config
//---------------------------------------------------------
function save()
{
	$ret = $this->_store_handler->save();
	if ( !$ret )
	{
		$this->_set_errors( $this->_store_handler->getErrors() );
	}
	return $ret;
}

//---------------------------------------------------------
// check config
//---------------------------------------------------------
function _check_init_config()
{
	$num = $this->_store_handler->getCount();
	if ( $num == 0 )
	{	return false;	}

	return true;
}

function _check_version_config()
{
	$this->_store_handler->load();

	if ( !$this->_store_handler->check_exist_by_name( 'basic_rss_atom' ) )
	{	return false;	}

	if ( !$this->_store_handler->check_exist_by_name( 'index_desc' ) )
	{	return false;	}

// v0.40
	if ( !$this->_store_handler->check_exist_by_name( 'block_blog_lid' ) )
	{	return false;	}

// v0.50
// proxy server
	if ( !$this->_store_handler->check_exist_by_name( 'proxy_use' ) )
	{	return false;	}

// v0.60
// content filter
	if ( !$this->_store_handler->check_exist_by_name( 'link_use' ) )
	{	return false;	}

	return true;
}

function _check_version_config_040()
{
	$ret = $this->_store_handler->_handler->check_version_040();
	return $ret;
}

//---------------------------------------------------------
// check other table
//---------------------------------------------------------
function _exists_word_table()
{
	return $this->_word_handler->existsTable();
}

function _exists_xml_table()
{
	return $this->_xml_handler->existsTable();
}

function _check_version_feed_030()
{
	return $this->_feed_handler->check_version_030();
}

function _check_version_feed_060()
{
	return $this->_feed_handler->check_version_060();
}

function _check_version_black_060()
{
	return $this->_black_handler->check_version_060();
}

function _check_version_white_060()
{
	return $this->_white_handler->check_version_060();
}

// --- class end ---
}

?>