<?php
// $Id: whatsnew_ping.php,v 1.3 2005/10/22 08:12:41 ohwada Exp $

// 2005-09-28 K.OHWADA
// change func.ping.php to class

//=========================================================
// What's New Module
// class send weblog update ping
// 2004/08/20 K.OHWADA
//=========================================================

class Whatsnew_Ping
{
// constant
	var $FILE_PING;
	var $PING_TIMEOUT;

	var $TEMPLATE_RSS;
	var $TEMPLATE_RDF;
	var $TEMPLATE_ATOM;

// variable
	var $_flag_print;

// class
	var $_db;
	var $_class_show;

// table
	var $_table_config;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function Whatsnew_Ping()
{
// constant
	$this->FILE_PING = XOOPS_ROOT_PATH."/modules/whatsnew/cache/ping.send.log";
	$this->PING_TIMEOUT  = 3;	// 3 sec

	$this->TEMPLATE_RSS  = 'db:whatsnew_rss.html';
	$this->TEMPLATE_RDF  = 'db:whatsnew_rdf.html';
	$this->TEMPLATE_ATOM = 'db:whatsnew_atom.html';

// variable
	$this->set_flag_print(0);

// class
	$this->_db         =& Database::getInstance();
	$this->_class_show =& Whatsnew_Show_Block::getInstance();

// table
	$this->_table_config = $this->_db->prefix('whatsnew_config');
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new Whatsnew_Ping();
	}

	return $instance;
}

//---------------------------------------------------------
// main function
//---------------------------------------------------------
// send ping after clear cache
function send_ping_cache()
{
	global $xoopsConfig;

	$this->clear_cache($this->TEMPLATE_RSS);
	$this->clear_cache($this->TEMPLATE_RDF);
	$this->clear_cache($this->TEMPLATE_ATOM);

	$this->send_ping();
}

function send_ping()
{
// class
	$class_weblog =& Whatsnew_Weblog_Updates::getInstance();

	$config       =& $this->_class_show->get_config_data();
	$site_name    =  $config['site_name'];
	$site_url     =  $config['site_url'];
	$ping_log     =  $config['ping_log'];
	$ping_servers =  $config['ping_servers'];

	$today = date("Y/m/d H:i:s");

	if ($ping_log)
	{
		$fp = fopen($this->FILE_PING, "a");
		fwrite($fp,"$today \n");
	}

	$ping_arr = split("\n", $ping_servers);

// set encode
	$class_weblog->set_encode( _CHARSET );

	if ($this->_flag_print >= 2)
	{
		$class_weblog->set_debug();
	}

	if ($this->_flag_print >= 1)
	{
		echo "<hr />\n";
	}

	foreach ($ping_arr as $url)
	{
		$url = trim($url);
	 	if (empty($url))  continue;

  		$class_weblog->set_blog_data($site_name, $site_url);
  		$class_weblog->send_ping($url, $this->PING_TIMEOUT, $this->PING_TIMEOUT);
		$result = $class_weblog->make_result( $class_weblog->get_result() );

		if ($this->_flag_print >= 1)
		{
			echo $result;
			echo "<br /><br />\n";
		}

		if ($ping_log)
		{
			fwrite($fp, $result);
		}
	}

	if ($this->_flag_print >= 1)
	{
		echo "<hr />\n";
	}

	if ($ping_log)
	{
		fclose($fp);
	}

	$this->update_time();
}

//---------------------------------------------------------
// update config
//---------------------------------------------------------
function update_time()
{
	$this->update_by_name( 'ping_time', time() );
}

function update_by_name($name, $value)
{
	$sql = "UPDATE ".$this->_table_config." SET conf_value = ".$this->_db->quoteString($value)." WHERE conf_name = ".$this->_db->quoteString($name);

// must be queryF, when REQUEST_METHOD is GET
	if ( !$this->_db->queryF($sql) )
	{
		echo "sql: $sql <br />\n";
		echo "error: ".$this->_db->error()." <br />\n";	
		return false;
	}
}

//---------------------------------------------------------
// template cache
//---------------------------------------------------------
function clear_cache($template)
{
	$tpl = new XoopsTpl();
	$tpl->clear_cache($template);
}

//---------------------------------------------------------
// set parameter
//---------------------------------------------------------
function set_flag_print($value)
{
	$this->_flag_print = intval($value);
}

// --- class end ---
}

?>