<?php
// ------------------------------------------------------------------------- //
//                XOOPS - PHP Content Management System                      //
//                       <http://www.xoops.org/>                             //
// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
// ------------------------------------------------------------------------- //
//                                                                           //
//                               "Spotlight"                                 //
//               http://linux.kuht.it  - http://www.kuht.it                  //
//                              spark@kuht.it                                //
//                                                                           //
//   Adaptation for XOOPS 2.0x by Herko (me at herkocoomans dot net) and     //
//                Dawilby (willemsen1 at chello dot nl)                      //
//---------------------------------------------------------------------------//
include_once(XOOPS_ROOT_PATH.'/class/xoopsstory.php');
include_once(XOOPS_ROOT_PATH.'/class/xoopstopic.php');
include_once(XOOPS_ROOT_PATH.'/class/module.textsanitizer.php');

function newgraphic($time, $days) {
    $new = '';
    $startdate = (time()-(86400 * $days));
    if ($startdate < $time) {
        $new = '&nbsp;<img src="'.XOOPS_URL.'/modules/spotlight/images/newred.gif" alt=""/>';
    }
    return $new;
}

function popgraphic($reads, $limit) {
    $pop = '';
    if ($limit < $reads) {
        $pop = '&nbsp;<img src="'.XOOPS_URL.'/modules/spotlight/images/pop.gif" alt=""/>';
    }
    return $pop;
}

function mysrand($seed = '') 
{ 
    static $wascalled = FALSE;
    if (!$wascalled){
        $seed = $seed === '' ? (double) microtime() * 1000000 : $seed;
        srand($seed);
        $wascalled = TRUE;
    } 
}

function getRandomStory($num, $catid=0) {
    $db =& Database::getInstance();
    $sql = sprintf('SELECT storyid FROM %s WHERE published<%d AND published>0 AND (expired=0 OR expired>%d)',
                   $db->prefix('stories'), $time=time(), $time);
    if ($catid>0) {
        $sql .= sprintf(' AND topicid=%d', $catid);
    }
    $sql .= ' ORDER BY published DESC';
    $result = $db->query($sql, $num, 0) or die($db->error());
    $storyids = array();
    while ($myrow = $db->fetchArray($result)) {
        $storyids[] = $myrow['storyid'];
    }
    mysrand();
    return $storyids[rand(0, count($storyids)-1)];
}

//makes a nicely ordered selection box
function makeSelBox() {
    $db =& Database::getInstance();
    $xt =& new XoopsTopic($db->prefix('topics'));
    ob_start();
    $xt->makeTopicSelBox(1, 0, 'storytopic', 'submit();');
    $selbox = ob_get_contents();
    ob_end_clean();

    $block = '<form action="'.XOOPS_URL.'/modules/news/index.php? method="post">';
    $block .= $selbox;
    $block .= '</form>';

    $block = str_replace("----", _MB_KUHT_CHOOSE, $block);
    return $block;
}

function b_head_kuht_show($options) {
    global $xoopsConfig;
    $db =& Database::getInstance();
    $myts =& MyTextSanitizer::getInstance();
    $block = array();
    $block['title'] = _MB_KUHT_TITLE_SPOTLIGHT;
    $block['lang_by'] = _MB_KUHT_BY;
    $block['lang_read'] = _MB_KUHT_READ;
    $block['lang_comments'] = _MB_KUHT_COMMENTS;
    $block['lang_write'] = _MB_KUHT_WRITE;
    $block['lang_othernews'] = _MB_KUHT_OTHERNEWSTEXT;

    $var = $db->query("SELECT news, auto, lastnum, catid, image, auto_image FROM ".$db->prefix("spotlight"), 1, 0);
    list ($number, $auto, $lastnum, $catid, $image, $auto_image) = $db->fetchRow($var);

    $sql = sprintf('SELECT t.topic_imgurl, s.storyid, s.topicid, s.title, s.hometext, s.comments, s.nohtml, s.nosmiley, s.published, u.uid, u.uname FROM %s as s, %s as u, %s as t',
                   $db->prefix('stories'), $db->prefix('users'), $db->prefix('topics'));
    $sql .= ' WHERE s.topicid=t.topic_id AND s.uid=u.uid';
    $num = 1;
    if ($auto==0) {
        // Selected news
        $sql .= sprintf(' AND storyid=%d', $number);
    } else if ($auto==1) {
        // auto latest or random selection
        $sql .= sprintf(' AND published<%d AND published>0 AND (expired=0 OR expired>%d)',
                        $time=time(), $time);
        if ($catid>0) {
            $sql .= sprintf(' AND s.topicid=%d', $catid);
        }
        $sql .= ' ORDER BY published DESC';
    } else {
        $sql .= sprintf(' AND storyid=%d', getRandomStory($lastnum, $catid));
    }
    $result = $db->query($sql, 1, 0) or die($db->error());
    list ($image_display, $fsid, $ftid, $ftitle, $fhometext, $fcomments, $fnohtml, $fnosmiley, $fpublished, $uidutente, $fautorevero) = $db->fetchRow($result);

    if (!$fsid && !$ftitle) {
        $block['message'] = _MB_KUHT_NOTSELECT;
    } else {
        if ($auto_image == 0) {
            $block['image'] = $image;
        } else {
            $block['image_display'] = $image_display;
            $block['topicid'] = $ftid;
        }

        $title = $myts->makeTboxData4Show($ftitle);
        if (!XOOPS_USE_MULTIBYTES) {
            if (strlen($title) >= $options[0]) {
                $title = substr($title, 0, $options[0]-1)."...";
            }
        }
        $block['title'] = $title;
        $block['uid'] = $uidutente;
        $block['author'] = $myts->makeTboxData4Show($fautorevero);
        $block['hometext'] = $myts->displayTarea($fhometext, ($fnohtml==1)?0:1, ($fnosmiley==1)?0:1);
        $block['storyid'] = $fsid;
        $block['comments'] = $fcomments;
    }

    // Other news
    $nsql = sprintf('SELECT storyid, title, published, counter FROM %s WHERE published<%d AND published>0 AND (expired=0 OR expired>%d) AND storyid!=%d',
                    $db->prefix('stories'), $time=time(), $time, $fsid);
//    if ($options[1] == "published") {
        $nsql .= ' ORDER BY published DESC';
//    } else {
//        $nsql .= ' ORDER BY counter DESC';
//    }
    $nresult = $db->query($nsql, $options[5], 0);
    while ($myrow = $db->fetchArray($nresult)) {
        $news = array();
        $news['title'] = $myts->makeTboxData4Show($myrow['title']);
        if ( !XOOPS_USE_MULTIBYTES ) {
            if (strlen($news['title']) >= $options[6]) {
                $news['title'] = substr($news['title'], 0, $options[6]-1)."...";
            }
        }
        $news['id'] = $myrow['storyid'];
        $news['graphic'] ='';
        if ($options[1] == "published") {
            $news['hitsordate'] = formatTimestamp($myrow['published'], "s");
            if ($options[2]=="iconed") {
                $news['graphic'] = newgraphic($myrow['published'], $options[3]);
            }
        } elseif ($options[1] == "counter") {
            $news['hitsordate'] = $myrow['counter'];
            if ($options[2]=="iconed") {
                $news['graphic'] = popgraphic($myrow['counter'], $options[4]);
            }
        }
        $block['stories'][] = $news;
    }

    // pulldown menu of topics
    if ($options[7] == 1) {
        // rb topic select form for news direct topic access
        $block['topicsel'] = makeSelBox();
    }
    return $block;
}

function b_head_kuht_edit($options) {
    $form = '<table>';
    $form .= sprintf('<tr><td><b>%s</b>:</td><td><input type="text" size="3" name="options[]" value="%d" />'._MB_KUHT_LENGTH.'</td></tr>',
                     _MB_KUHT_TITLECHARS, $options[0]);
    $form .= sprintf('<tr><td><b>%s</b>:</td><td>%s:&nbsp;<select name="options[]">',
                     _MB_KUHT_OTHERNEWS, _MB_KUHT_ORDER); 
    $form .= '<option value="published"';
    if ($options[1] == "published") {
        $form .= ' selected="selected"';
    }
    $form .= '>'._MB_KUHT_DATE.'</option>';
    $form .= '<option value="counter"';
    if ($options[1] == "counter") {
        $form .= ' selected="selected"';
    }
    $form .= '>'._MB_KUHT_HITS.'</option>';
    $form .= '</select>&nbsp;';

    $tmp = '<select name="options[]"><option value="iconed"';
    if ($options[2] == "iconed") {
        $tmp .= ' selected="selected"';
    }
    $tmp .= '>'._MB_KUHT_ICON.'</option>';
    $tmp .= '<option value="noiconed"';
    if ($options[2] == "noiconed") {
        $tmp .= ' selected="selected"';
    }
    $tmp .= '>'._MB_KUHT_NOICON.'</option>';
    $tmp .= '</select>';

    $form .= sprintf(_MB_KUHT_ICONDISPLAY, $tmp);
    $form .= '</td></tr>';

    $form .= '<tr><td><br /></td><td>'._MB_KUHT_NEW.': '.sprintf(_MB_KUHT_WITHINDAYS, '<input type="text" size="3" name="options[]" value="'.$options[3].'" />').'</td></tr>';
    $form .= '<tr><td><br /></td><td>'._MB_KUHT_POPULAR.': '.sprintf(_MB_KUHT_OVERREADS, '<input type="text" size="3" name="options[]" value="'.$options[4].'" />').'</td></tr>';

    $form .= '<tr><td><br /></td><td>'._MB_KUHT_DISP.': <input type="text" size="3" name="options[]" value="'.$options[5].'" /> '._MB_KUHT_ARTCLS.'</td></tr>';
    $form .= '<tr><td><br /></td><td>'._MB_KUHT_CHARS.': <input type="text" size="3"name="options[]" value="'.$options[6].'" /> '._MB_KUHT_LENGTH.'</td></tr>';
    $form .= '<tr><td><br /></td><td>'._MB_KUHT_TOPICS.': <input type="text" size="3" name="options[]" value="'.$options[7].'" /></td></tr>';
    $form .= '</table>';
    return $form;
}
?>