<?php
// ------------------------------------------------------------------------- //
//                XOOPS - PHP Content Management System                      //
//                       <http://www.xoops.org/>                             //
// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
// ------------------------------------------------------------------------- //
//                                                                           //
//                               "Spotlight"                                 //
//               http://linux.kuht.it  - http://www.kuht.it                  //
//                              spark@kuht.it                                //
//                                                                           //
//   Adaptation for XOOPS 2.0x by Herko (me at herkocoomans dot net) and     //
//                Dawilby (willemsen1 at chello dot nl)                      //
//---------------------------------------------------------------------------//
include("admin_header.php");
include_once(XOOPS_ROOT_PATH."/modules/news/class/class.newsstory.php");

if (isset($HTTP_POST_VARS['submit'])) {
	$op = intval($HTTP_POST_VARS['submit']);
} else {
	$op = 'start';
}

function spotlightForm() {
    global $xoopsConfig, $xoopsModule;
	$db =& Database::getInstance();
    $storyarray = NewsStory::getAllPublished(10, 0, 0, 1);

    // Shows last 10 published stories
    echo '<h3>'._AM_KUHT_NAME.'</h3>';
    echo '<table class="outer" cellspacing="1" width="100%">'
        .'<tr>'
        .'<th align="center" colspan="6"><b>'._AM_LAST10ARTS.'</b></th>'
        .'</tr>'
        .'<tr>'
        .'<td class="head" align="center">'._AM_STORYID.'</td>'
        .'<td class="head" align="center">'._AM_TITLE.'</td>'
        .'<td class="head" align="center">'._AM_TOPIC.'</td>'
        .'<td class="head" align="center">'._AM_POSTER.'</td>'
        .'<td class="head" align="center">'._AM_PUBLISHED.'</td>'
        .'<td class="head" align="center">'._AM_ACTION.'</td>'
        .'</tr>';
    foreach ($storyarray as $eachstory) {
        $published = formatTimestamp($eachstory->published());
        $topic = $eachstory->topic();
        echo '<tr>'
            .'<td class="even" align="center"><b>'.$eachstory->storyid().'</b></td>'
            .'<td class="odd" align="left"><a href="'.XOOPS_URL.'/modules/news/article.php?storyid='.$eachstory->storyid().'">'.$eachstory->title().'</a></td>'
            .'<td class="even" align="center">'.$topic->topic_title().'</td>'
            .'<td class="odd" align="center"><a href="'.XOOPS_URL.'/userinfo.php?uid='.$eachstory->uid().'">'.$eachstory->uname().'</a></td>'
            .'<td class="even" align="center">'.$published.'</td>'
            .'<td class="odd" align="center"><a href="'.XOOPS_URL.'/modules/news/admin/index.php?op=edit&amp;storyid='.$eachstory->storyid().'">'._AM_EDIT.'</a>-'
            .'<a href="'.XOOPS_URL.'/modules/news/admin/index.php?op=delete&amp;storyid='.$eachstory->storyid().'">'._AM_DELETE.'</a></td>'
            .'</tr>';
    }
    echo '</table><br />';

    $var = $db->query("SELECT news, auto, catid, lastnum, image, auto_image FROM ".$db->prefix("spotlight"), 1, 0);
    list ($number, $auto, $catid, $lastnum, $image, $auto_image) = $db->fetchRow($var);

    echo '<form name="form_spotlight" method="post" action="index.php?op=submit">'
        .'<table class="outer" cellspacing="1" width="100%">';
    echo '<tr>'
        .'<td class="head" width="20%" align="right" nowrap><b>'._AM_SELECT_AUTO.' : </b></td>'
        .'<td class="even" width="20%" align="left"><select name="auto">';
    if ($auto==0) {
        echo '<option selected>'._AM_SELECT_SELECTED.'</option><option>'._AM_SELECT_LATEST.'</option><option>'._AM_SELECT_RANDOM.'</option>';
    } else if ($auto == 1) {
        echo '<option>'._AM_SELECT_SELECTED.'</option><option selected>'._AM_SELECT_LATEST.'</option><option>'._AM_SELECT_RANDOM.'</option>';
    } else {
        echo '<option>'._AM_SELECT_SELECTED.'</option><option>'._AM_SELECT_LATEST.'</option><option selected>'._AM_SELECT_RANDOM.'</option>';
    }
    echo '</select>'
        .'</td>'
        .'<td class="odd" width="60%" align="left">'._AM_SELECT_AUTO_DESC.'</td>'
        .'</tr>';
    echo '<tr>'
        .'<td class="head" width="20%" align="right" nowrap><b>'._AM_SELECT_NEWS.' : </b></td>'
        .'<td class="even" width="20%" align="left"><input type="text" name="news" size="5" value="'.$number.'"></td>'
        .'<td class="odd" width="60%" align="left">'._AM_SELECT_NEWS_DESC.'</td>'
        .'</tr>';
    echo '<tr>'
        .'<td class="head" width="20%" align="right" nowrap><b>'._AM_SELECT_LASTNUM.' : </b></td>'
        .'<td class="even" width="20%" align="left"><input type="text" name="lastnum" size="5" value="'.$lastnum.'"></td>'
        .'<td class="odd" width="60%" align="left">'._AM_SELECT_LASTNUM_DESC.'</td>'
        .'</tr>';
    echo '<tr>'
        .'<td class="head" width="20%" align="right" nowrap><b>'._AM_SELECT_TOPIC.' : </b></td>'
        .'<td class="even" width="20%" align="left">';
        $xt = new XoopsTopic($db->prefix("topics"));
        $xt->makeTopicSelBox(1, $catid, "catid");
    echo '</td>'
        .'<td class="odd" width="60%" align="left">'._AM_SELECT_TOPIC_DESC.'</td>'
        .'</tr>';

    echo '<tr>'
        .'<td class="head" width="20%" align="right" nowrap><b>'._AM_SELECT_AUTO_IMG.' : </b></td>'
        .'<td class="even" width="20%" align="left"><select size="1" name="auto_image">';
    if ($auto_image == 1) {
        echo '<option selected>'._YES.'</option><option>'._NO.'</option>';
    } else {
        echo '<option>'._YES.'</option><option selected>'._NO.'</option>';
    }
    echo '</select>'
        .'</td>'
        .'<td class="odd" width="60%" align="left">'._AM_SELECT_AUTO_IMG_DESC.'</td>'
        .'</tr>';
    echo '<tr>'
        .'<td class="head" width="20%" align="right" nowrap><b>'._AM_SELECT_IMG.' : </b></td>'
        .'<td class="even" width="20%" align="left"><input type="text" name="image" size="20" value="'.$image.'"></font></td>'
        .'<td class="odd" width="60%" align="left">'._AM_SELECT_IMG_DESC.'</td>'
        .'</tr>';

    echo '<tr>'
        .'<td class="head" width="100%" align="center" colspan="3">'
        .'<input type="submit" value="SUBMIT" name="submit"> '
        .'<input type="reset" value="RESET" name="reset">'
        .'</td>'
        .'</tr>';
    echo '</table>'
        .'</form>';
}

switch ($op) {
case 'submit':
    $db =& Database::getInstance();
    $news       = addslashes($HTTP_POST_VARS["news"]);
    $image      = addslashes($HTTP_POST_VARS["image"]);
    $lastnum    = addslashes($HTTP_POST_VARS["lastnum"]);
    $auto       = addslashes($HTTP_POST_VARS["auto"]);
    $catid      = addslashes($HTTP_POST_VARS["catid"]);
    $auto_image = addslashes($HTTP_POST_VARS["auto_image"]);
    if ($auto==_AM_SELECT_SELECTED) {
        $auto = 0;
    } else if ($auto==_AM_SELECT_LATEST) {
        $auto = 1;
    } else {
    	$auto = 2;
    }
    if ($auto_image==_YES) {
        $auto_image = 1;
    } else {
        $auto_image = 0;
    }
    $sql = "UPDATE ".$db->prefix("spotlight")." SET news='".$news."', auto='".$auto."', lastnum='".$lastnum."', image='".$image."', catid='".$catid."', auto_image='".$auto_image."'";
    $result = $db->queryF($sql) or die($db->error());
    redirect_header('index.php', 3, _AM_MESSAGE);
    exit();
    break;
case 'start':
default:
    xoops_cp_header();
    spotlightForm();
    xoops_cp_footer();
    break;
}
?>