<?PHP
// ------------------------------------------------------------------------- //
//                XOOPS - PHP Content Management System                      //
//                       <http://www.xoops.org/>                             //
// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
// ------------------------------------------------------------------------- //
//                                                                           //
//                               "Spotlight"                                 //
//               http://linux.kuht.it  - http://www.kuht.it                  //
//                              spark@kuht.it                                //
//                                                                           //
//   Adaptation for XOOPS 2.0x by Herko (me at herkocoomans dot net) and     //
//                Dawilby (willemsen1 at chello dot nl)                      //
//---------------------------------------------------------------------------//
include("admin_header.php");
include_once(XOOPS_ROOT_PATH."/modules/news/class/class.newsstory.php");

if (isset($HTTP_POST_VARS['submit'])) {
	$op = intval($HTTP_POST_VARS['submit']);
} else {
	$op = 'start';
}

function spotlightForm()
{
    global $xoopsDB, $xoopsConfig, $xoopsModule;
    $storyarray = NewsStory::getAllPublished(10, 0, 0, 1);

    // Shows last 10 published stories
    echo '<h3>'._AM_KUHT_NAME.'</h3>';
    echo '<table class="outer" cellspacing="1" width="100%">'
        .'<tr>'
        .'<th align="center" colspan="6"><b>'._AM_LAST10ARTS.'</b></th>'
        .'</tr>'
        .'<tr>'
        .'<td class="head" align="center">'._AM_STORYID.'</td>'
        .'<td class="head" align="center">'._AM_TITLE.'</td>'
        .'<td class="head" align="center">'._AM_TOPIC.'</td>'
        .'<td class="head" align="center">'._AM_POSTER.'</td>'
        .'<td class="head" align="center">'._AM_PUBLISHED.'</td>'
        .'<td class="head" align="center">'._AM_ACTION.'</td>'
        .'</tr>';
    foreach ($storyarray as $eachstory) {
        $published = formatTimestamp($eachstory->published());
        $topic = $eachstory->topic();
        echo '<tr>'
            .'<td class="even" align="center"><b>'.$eachstory->storyid().'</b></td>'
            .'<td class="odd" align="left"><a href="'.XOOPS_URL.'/modules/news/article.php?storyid='.$eachstory->storyid().'">'.$eachstory->title().'</a></td>'
            .'<td class="even" align="center">'.$topic->topic_title().'</td>'
            .'<td class="odd" align="center"><a href="'.XOOPS_URL.'/userinfo.php?uid='.$eachstory->uid().'">'.$eachstory->uname().'</a></td>'
            .'<td class="even" align="center">'.$published.'</td>'
            .'<td class="odd" align="center"><a href="/modules/news/admin/index.php?op=edit&amp;storyid='.$eachstory->storyid().'">'._AM_EDIT.'</a>-'
            .'<a href="/modules/news/admin/index.php?op=delete&amp;storyid='.$eachstory->storyid().'">'._AM_DELETE.'</a></td>'
            .'</tr>';
    }
    echo '</table><br />';

    $var = $xoopsDB->query("SELECT news, auto, image, auto_image FROM ".$xoopsDB->prefix("spotlight")."",1,0);
    list ($number, $auto, $image, $auto_image) = $xoopsDB->fetchRow($var);

    echo '<form name="form_spotlight" method="post" action="index.php?op=submit">'
        .'<table class="outer" cellspacing="1" width="100%">'
        .'<tr>'
        .'<td class="head" width="20%" align="right"><b>'._AM_SELECT_NEWS.' :&nbsp;</b></td>'
        .'<td class="even" width="20%" align="left"><input type="text" name="news" size="5" value="'.$number.'"></td>'
        .'<td class="odd" width="60%" align="left" nowrap>'._AM_SELECT_NEWS_DESC.'</td>'
        .'</tr>'
        .'<tr>'
        .'<td class="head" width="20%" align="right"><b>'._AM_SELECT_IMG.' :&nbsp;</b></td>'
        .'<td class="even" width="20%" align="left"><input type="text" name="image" size="20" value="'.$image.'"></font></td>'
        .'<td class="odd" width="60%" align="left" nowrap>'._AM_SELECT_IMG_DESC.'</td>'
        .'</tr>'
        .'<tr>'
        .'<td class="head" width="20%" align="right"><b>'._AM_SELECT_AUTO.' :&nbsp;</b></td>'
        .'<td class="even" width="20%" align="left"><select size="1" name="auto">';
    if ($auto == 1) {
        echo '<option selected> ON </option><option>OFF</option>';
    } else {
        echo '<option selected> OFF </option><option>ON</option>';
    }
    echo '</select>'
        .'</td>'
        .'<td class="odd" width="60%" align="left" nowrap>'._AM_SELECT_AUTO_DESC.'</td>'
        .'</tr>'
        .'<tr>'
        .'<td class="head" width="20%" align="right"><b>'._AM_SELECT_AUTO_IMG.' :&nbsp;</b></td>'
        .'<td class="even" width="20%" align="left"><select size="1" name="auto_image">';
    if ($auto_image == 1) {
        echo '<option selected> ON </option><option>OFF</option>';
    } else {
        echo '<option selected> OFF </option><option>ON</option>';
    }
    echo '</select>'
        .'</td>'
        .'<td class="odd" width="60%" align="left" nowrap>'._AM_SELECT_AUTO_IMG_DESC.'</td>'
        .'</tr>'
        .'<tr>'
        .'<td class="head" width="100%" align="center" colspan="3">'
        .'<input type="submit" value="SUBMIT" name="submit">'
        .'<input type="reset" value="RESET" name="reset">'
        .'</td>'
        .'</tr>'
        .'</table>'
        .'</form>';
}

switch ($op) {
case 'submit':
    global $xoopsDB;
    $news       = addslashes($HTTP_POST_VARS["news"]);
    $image      = addslashes($HTTP_POST_VARS["image"]);
    $auto       = addslashes($HTTP_POST_VARS["auto"]);
    $auto_image = addslashes($HTTP_POST_VARS["auto_image"]);
    if ($auto=='ON') {
        $auto = 1;
    } else {
        $auto = 0;
    }
    if ($auto_image=='ON') {
        $auto_image = 1;
    } else {
        $auto_image = 0;
    }
    $sql = "UPDATE ".$xoopsDB->prefix("spotlight")." SET news='".$news."', auto='".$auto."', image='".$image."', auto_image='".$auto_image."'";
    if (!$result = $xoopsDB->queryF($sql)) {
        echo 'error';
    }
    redirect_header('index.php',3,_AM_MESSAGE);
    exit();
    break;
case 'start':
    xoops_cp_header();
    spotlightForm();
    xoops_cp_footer();
    break;
}
?>