
CREATE TABLE avatar (
  avatar_id serial primary key,
  avatar_file varchar(30) NOT NULL ,
  avatar_name varchar(100) NOT NULL ,
  avatar_mimetype varchar(30) NOT NULL ,
  avatar_created integer NOT NULL ,
  avatar_display integer NOT NULL ,
  avatar_weight smallint NOT NULL ,
  avatar_type varchar(1) NOT NULL 
) ;

CREATE TABLE avatar_user_link (
  avatar_id  SERIAL,
  user_id integer NOT NULL 
) ;

CREATE TABLE banner (
  bid SERIAL primary key,
  cid smallint NOT NULL default 0,
  imptotal smallint NOT NULL default 0,
  impmade smallint NOT NULL default 0,
  clicks smallint NOT NULL default 0,
  imageurl varchar(255) NOT NULL default '',
  clickurl varchar(255) NOT NULL default '',
  date integer NOT NULL default '0',
  htmlbanner smallint NOT NULL default 0,
  htmlcode text NOT NULL
) ;

CREATE TABLE bannerclient (
  cid serial primary key ,
  name varchar(60) NOT NULL default '',
  contact varchar(60) NOT NULL default '',
  email varchar(60) NOT NULL default '',
  login varchar(10) NOT NULL default '',
  passwd varchar(10) NOT NULL default '',
  extrainfo text NOT NULL 
) ;

CREATE TABLE bannerfinish (
  bid serial primary key ,
  cid smallint NOT NULL default 0,
  impressions smallint NOT NULL default 0,
  clicks smallint NOT NULL default 0,
  datestart integer NOT NULL default 0,
  dateend integer NOT NULL default 0
) ;

CREATE TABLE block_module_link (
  block_id smallint NOT NULL default 0,
  module_id smallint NOT NULL default 0
) ;

CREATE TABLE xoopscomments (
  com_id serial primary key ,
  com_pid smallint NOT NULL default 0,
  com_rootid smallint NOT NULL default 0,
  com_modid smallint NOT NULL default 0,
  com_itemid smallint NOT NULL default 0,
  com_icon varchar(25) NOT NULL default '',
  com_created integer NOT NULL default 0,
  com_modified integer NOT NULL default 0,
  com_uid smallint NOT NULL default 0,
  com_ip varchar(15) NOT NULL default '',
  com_title varchar(255) NOT NULL default '',
  com_text text NOT NULL,
  com_sig smallint NOT NULL default 0,
  com_status smallint NOT NULL default 0,
  com_exparams varchar(255) NOT NULL default '',
  dohtml smallint NOT NULL default 0,
  dosmiley smallint NOT NULL default 0,
  doxcode smallint NOT NULL default 0,
  doimage smallint NOT NULL default 0,
  dobr smallint NOT NULL default 0
) ;

CREATE TABLE xoopsnotifications (
  not_id SERIAL PRIMARY KEY,
  not_modid smallint NOT NULL default 0,
  not_itemid smallint NOT NULL default 0,
  not_category varchar(30) NOT NULL default '',
  not_event varchar(30) NOT NULL default '',
  not_uid smallint NOT NULL default 0,
  not_mode smallint NOT NULL default 0 
) ;

CREATE TABLE config (
  conf_id SERIAL PRIMARY KEY ,
  conf_modid smallint NOT NULL default 0,
  conf_catid smallint NOT NULL default 0,
  conf_name varchar(25) NOT NULL default '',
  conf_title varchar(30) NOT NULL default '',
  conf_value text NOT NULL,
  conf_desc varchar(30) NOT NULL default '',
  conf_formtype varchar(15) NOT NULL default '',
  conf_valuetype varchar(10) NOT NULL default '',
  conf_order smallint NOT NULL default 0 
) ;

CREATE TABLE configcategory (
  confcat_id SERIAL PRIMARY KEY ,
  confcat_name varchar(25) NOT NULL default '',
  confcat_order smallint NOT NULL default 0 
) ;

CREATE TABLE configoption (
  confop_id SERIAL PRIMARY KEY,
  confop_name varchar(255) NOT NULL default '',
  confop_value varchar(255) NOT NULL default '',
  conf_id smallint NOT NULL default 0 
) ;

CREATE TABLE groups (
  groupid SERIAL PRIMARY KEY,
  name varchar(50) NOT NULL default '',
  description varchar(255) NOT NULL,
  group_type varchar(10) NOT NULL default '' 
) ;

CREATE TABLE group_permission (
  gperm_id SERIAL PRIMARY KEY,
  gperm_groupid integer NOT NULL default 0,
  gperm_itemid integer NOT NULL default 0,
  gperm_modid integer NOT NULL default 0,
  gperm_name varchar(50) NOT NULL default '' 
) ;

CREATE TABLE groups_users_link (
  linkid SERIAL PRIMARY KEY,
  groupid smallint NOT NULL default 0,
  uid smallint NOT NULL default '0'
) ;

CREATE TABLE image (
  image_id SERIAL PRIMARY KEY,
  image_name varchar(30) NOT NULL default '',
  image_nicename varchar(255) NOT NULL default '',
  image_mimetype varchar(30) NOT NULL default '',
  image_created integer NOT NULL default 0,
  image_display smallint NOT NULL default 0,
  image_weight smallint NOT NULL default 0,
  imgcat_id smallint NOT NULL default 0
) ;

CREATE TABLE imagebody (
  image_id smallint NOT NULL default 0,
  image_body decimal
) ;

CREATE TABLE imagecategory (
  imgcat_id SERIAL PRIMARY KEY,
  imgcat_name varchar(100) NOT NULL default '',
  imgcat_maxsize smallint NOT NULL default 0,
  imgcat_maxwidth smallint NOT NULL default 0,
  imgcat_maxheight smallint NOT NULL default 0,
  imgcat_display smallint NOT NULL default 0,
  imgcat_weight smallint NOT NULL default 0,
  imgcat_type char(1) NOT NULL default '',
  imgcat_storetype varchar(5) NOT NULL default '' 
) ;

CREATE TABLE imgset (
  imgset_id SERIAL PRIMARY KEY,
  imgset_name varchar(50) NOT NULL default '',
  imgset_refid smallint NOT NULL default 0
) ;

CREATE TABLE imgset_tplset_link (
  imgset_id smallint NOT NULL default 0,
  tplset_name varchar(50) NOT NULL default ''
) ;

CREATE TABLE imgsetimg (
  imgsetimg_id SERIAL PRIMARY KEY,
  imgsetimg_file varchar(50) NOT NULL default '',
  imgsetimg_body decimal NOT NULL,
  imgsetimg_imgset smallint NOT NULL default 0
) ;

CREATE TABLE modules (
  mid SERIAL PRIMARY KEY,
  name varchar(150) NOT NULL default '',
  version smallint NOT NULL default 100,
  last_update integer NOT NULL default 0,
  weight smallint NOT NULL default 0,
  isactive smallint NOT NULL default 0,
  dirname varchar(25) NOT NULL default '',
  hasmain smallint NOT NULL default 0,
  hasadmin smallint NOT NULL default 0,
  hassearch smallint NOT NULL default 0,
  hasconfig smallint NOT NULL default 0,
  hascomments smallint NOT NULL default 0,
  hasnotification smallint NOT NULL default 0 
) ;

CREATE TABLE newblocks (
  bid SERIAL PRIMARY KEY,
  mid smallint NOT NULL default 0,
  func_num smallint NOT NULL default 0,
  options varchar(255) NOT NULL default '',
  name varchar(150) NOT NULL default '',
  title varchar(255) NOT NULL default '',
  content text NOT NULL,
  side smallint NOT NULL default 0,
  weight smallint NOT NULL default 0,
  visible smallint NOT NULL default 0,
  block_type char(1) NOT NULL default '',
  c_type char(1) NOT NULL default '',
  isactive smallint NOT NULL default 0,
  dirname varchar(50) NOT NULL default '',
  func_file varchar(50) NOT NULL default '',
  show_func varchar(50) NOT NULL default '',
  edit_func varchar(50) NOT NULL default '',
  template varchar(50) NOT NULL default '',
  bcachetime smallint NOT NULL default 0,
  last_modified integer NOT NULL default 0
) ;

CREATE TABLE online (
  online_uid smallint NOT NULL default 0,
  online_uname varchar(25) NOT NULL default '',
  online_updated integer NOT NULL default 0,
  online_module smallint NOT NULL default 0,
  online_ip varchar(15) NOT NULL default '' 
) ;

CREATE TABLE priv_msgs (
  msg_id SERIAL PRIMARY KEY,
  msg_image varchar(100) default NULL,
  subject varchar(255) NOT NULL default '',
  from_userid smallint NOT NULL default 0,
  to_userid smallint NOT NULL default 0,
  msg_time integer NOT NULL default 0,
  msg_text text NOT NULL,
  read_msg smallint NOT NULL default 0 
) ;

CREATE TABLE ranks (
  rank_id SERIAL PRIMARY KEY ,
  rank_title varchar(50) NOT NULL default '',
  rank_min smallint NOT NULL default 0,
  rank_max smallint NOT NULL default 0,
  rank_special smallint NOT NULL default 0,
  rank_image varchar(255) default NULL
) ;

CREATE TABLE session (
  sess_id varchar(32) NOT NULL default '' PRIMARY KEY,
  sess_updated integer NOT NULL default 0,
  sess_ip varchar(15) NOT NULL default '',
  sess_data text NOT NULL
) ;

CREATE TABLE smiles (
  id SERIAL PRIMARY KEY ,
  code varchar(50) NOT NULL default '',
  smile_url varchar(100) NOT NULL default '',
  emotion varchar(75) NOT NULL default '',
  display smallint NOT NULL default 0 
) ;

CREATE TABLE tplset (
  tplset_id SERIAL PRIMARY KEY,
  tplset_name varchar(50) NOT NULL default '',
  tplset_desc varchar(255) NOT NULL default '',
  tplset_credits text NOT NULL,
  tplset_created integer NOT NULL default 0
) ;

CREATE TABLE tplfile (
  tpl_id  SERIAL PRIMARY KEY, 
  tpl_refid smallint NOT NULL default 0, 
  tpl_module varchar(25) NOT NULL default '',
  tpl_tplset varchar(50) NOT NULL default '',
  tpl_file varchar(50) NOT NULL default '',
  tpl_desc varchar(255) NOT NULL default '',
  tpl_lastmodified integer NOT NULL default 0,
  tpl_lastimported integer NOT NULL default 0,
  tpl_type varchar(20) NOT NULL default '' 
) ;

CREATE TABLE tplsource (
  tpl_id integer NOT NULL default 0,
  tpl_source text NOT NULL
) ;


CREATE TABLE users (
  uid SERIAL PRIMARY KEY,
  name varchar(60) NOT NULL default '',
  uname varchar(25) NOT NULL default '',
  email varchar(60) NOT NULL default '',
  url varchar(100) NOT NULL default '',
  user_avatar varchar(30) NOT NULL default 'blank.gif',
  user_regdate integer NOT NULL default 0,
  user_icq varchar(15) NOT NULL default '',
  user_from varchar(100) NOT NULL default '',
  user_sig text NOT NULL  default '',
  user_viewemail smallint NOT NULL default 0,
  actkey varchar(8) NOT NULL default '',
  user_aim varchar(18) NOT NULL default '',
  user_yim varchar(25) NOT NULL default '',
  user_msnm varchar(100) NOT NULL default '',
  pass varchar(32) NOT NULL default '',
  posts integer NOT NULL default 0,
  attachsig smallint NOT NULL default 0,
  rank smallint NOT NULL default 0,
  level smallint NOT NULL default 1,
  theme varchar(100) NOT NULL default '',
  timezone_offset real NOT NULL default 9.0,
  last_login integer NOT NULL default 0,
  umode varchar(10) NOT NULL default '',
  uorder smallint NOT NULL default 0,
  notify_method smallint NOT NULL default 1,
  notify_mode smallint NOT NULL default 0,
  user_occ varchar(100) NOT NULL default '',
  bio text NOT NULL,
  user_intrest varchar(150) NOT NULL default '',
  user_mailok smallint NOT NULL default 1 
) ;
