<?php
// $Id: user_rss.php,v 1.1 2003/11/12 14:15:04 kousuke Exp $

include '../../mainfile.php';
include_once XOOPS_ROOT_PATH.'/class/template.php';
include_once XOOPS_ROOT_PATH.'/modules/simpleblog/simpleblog.php';


if(function_exists('mb_http_output')) { 
	mb_http_output('pass');
} 

header ('Content-Type:text/xml; charset=utf-8');


$uid = (!empty($HTTP_GET_VARS['uid'])) ? intval($HTTP_GET_VARS['uid']) : 0;
if($uid  == 0){
	exit();
}
$blog = new SimpleBlog($uid);
$dates = $blog->getDateFromHttpParams();
$r = array();
if($blog->canRead()){
	$r = $blog->getBlogData();
}
if(empty($r)){
	exit();
}
echo '<?xml version="1.0" encoding="UTF-8"?>';

?>
<rdf:RDF xmlns:dc="http://purl.org/dc/elements/1.1/" 
         xmlns="http://purl.org/rss/1.0/" 
	 xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" 
	 xml:lang="ja">
  <channel rdf:about="<?php echo SimpleBlog::createUrl($uid); ?>">
    <title><?php echo xoops_convert_encoding(htmlspecialchars($blog->getTitle(), ENT_QUOTES)); ?></title>
    <link><?php echo SimpleBlog::createUrl($uid); ?></link>
    <description></description>
    <items>
      <rdf:Seq>
<?php foreach($r['blog'] as $b){ ?>
        <rdf:li rdf:resource="<?php echo xoops_convert_encoding(htmlspecialchars($b['url'], ENT_QUOTES)); ?>" />
<?php } ?>
      </rdf:Seq>
    </items>
  </channel>
<?php foreach($r['blog'] as $b){ ?>
  <item rdf:about="<?php echo xoops_convert_encoding(htmlspecialchars($b['url'], ENT_QUOTES)); ?>">
    <title><?php echo xoops_convert_encoding(htmlspecialchars($b['title'], ENT_QUOTES)); ?></title>
    <link><?php echo xoops_convert_encoding(htmlspecialchars($b['url'], ENT_QUOTES)); ?></link>
    <dc:date><?php echo xoops_convert_encoding(htmlspecialchars($b['last_update4rss'], ENT_QUOTES)); ?></dc:date> 
    <dc:creator><?php echo xoops_convert_encoding(htmlspecialchars($blog->getTargetUname(), ENT_QUOTES)); ?></dc:creator> 
  </item>
<?php } ?>
</rdf:RDF>

