<?php
// $Id: backend.php,v 1.14 2003/11/10 13:10:49 kousuke Exp $

include '../../mainfile.php';
include_once XOOPS_ROOT_PATH.'/class/template.php';
include_once XOOPS_ROOT_PATH.'/modules/simpleblog/simpleblog.php';


if(function_exists('mb_http_output')) { 
	mb_http_output('pass');
} 

header ('Content-Type:text/xml; charset=utf-8');
$tpl = new XoopsTpl();
$tpl->xoops_setTemplateDir(XOOPS_ROOT_PATH.'/themes');
$tpl->xoops_setCaching(2);
$tpl->xoops_setCacheTime(3600);

if (!$tpl->is_cached('db:simpleblog_rss.html')) {
	$blogList = SimpleBlog::get_blog_list();
	
	if (is_array($blogList)) {
		$tpl->assign('channel_title', xoops_convert_encoding(htmlspecialchars($xoopsConfig['sitename'], ENT_QUOTES)));
		$tpl->assign('channel_link', XOOPS_URL.'/');
		$tpl->assign('channel_desc', xoops_convert_encoding(htmlspecialchars($xoopsConfig['slogan'], ENT_QUOTES)));
		$tpl->assign('channel_lastbuild', formatTimestamp(time(), 'rss'));
		$tpl->assign('channel_webmaster', $xoopsConfig['adminmail']);
		$tpl->assign('channel_editor', $xoopsConfig['adminmail']);
		$tpl->assign('channel_category', 'News');
		$tpl->assign('channel_generator', XOOPS_VERSION);
		$tpl->assign('channel_language', _LANGCODE);
		$tpl->assign('image_url', XOOPS_URL.'/images/logo.gif');
		$dimention = getimagesize(XOOPS_ROOT_PATH.'/images/logo.gif');
		if (empty($dimention[0])) {
			$width = 88;
		} else {
			$width = ($dimention[0] > 144) ? 144 : $dimention[0];
		}
		if (empty($dimention[1])) {
			$height = 31;
		} else {
			$height = ($dimention[1] > 400) ? 400 : $dimention[1];
		}
		$tpl->assign('image_width', $width);
		$tpl->assign('image_height', $height);
		$tpl->assign('channel_desc', xoops_convert_encoding(htmlspecialchars($xoopsModuleConfig['blog_description'], ENT_QUOTES)));
		
		foreach ($blogList as $blog) {
			$tpl->append('items', array(
				'title' => xoops_convert_encoding(htmlspecialchars($blog['title'], ENT_QUOTES)), 
				// 'link' => XOOPS_URL.'/modules/simpleblog/view.php?uid='.$blog['uid'], 
				'link' => $blog['url'], 
				'date' => htmlspecialchars($blog['last_update4rss'], ENT_QUOTES),
				'uname' => xoops_convert_encoding(htmlspecialchars($blog['uname'], ENT_QUOTES))
			));
		}
		
		$tpl->assign("_MD_SIMPLEBLOG_TITLE_SUFFIX",xoops_convert_encoding(htmlspecialchars(_MD_SIMPLEBLOG_TITLE_SUFFIX, ENT_QUOTES)));
		$tpl->assign("_MD_SIMPLEBLOG_TITLE_PREFIX",xoops_convert_encoding(htmlspecialchars(_MI_SIMPLEBLOG_TITLE_PREFIX, ENT_QUOTES)));
	}
}
$tpl->display('db:simpleblog_rss.html');
?>