<?php
// $Revision: 1.12.2.1.2.10 $
// ------------------------------------------------------------------------- //
//  XooNIps - Neuroinformatics Base Platform System                          //
//  Copyright (C) 2005-2008 RIKEN, Japan All rights reserved.                //
//  http://xoonips.sourceforge.jp/                                           //
// ------------------------------------------------------------------------- //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
// ------------------------------------------------------------------------- //
$xoopsOption['pagetype'] = 'user';
include 'include/common.inc.php';
include_once 'include/AL.php';
include_once 'include/lib.php';

xoonips_deny_guest_access();

$uid = $_SESSION['xoopsUserId'];

$textutil =& xoonips_getutility( 'text' );
$formdata =& xoonips_getutility( 'formdata' );

$pagen = $formdata->getValue( 'post', 'pagen', 'i', false );
$page_num_post = $formdata->getValue( 'post', 'page_num', 'i', false);
$pass_pages = $formdata->getValueArray( 'post', 'pass_pages', 's', false );
$checkons_post = $formdata->getValueArray( 'post', 'checkons', 's', false );
$changeButton = $formdata->getValue( 'post', 'changeButton', 'b', false );
$show_item_check = $formdata->getValueArray( 'post', 'show_item_check', 's', false );

// Page number optimization
function page_optimize($page, $last){
	// You may be the 1st page if omitted.
	if(strlen($page) == 0){
		return 1;
	}
	// In other than a number, it is made into the 1st page.
	if(!is_numeric($page)){
		return 1;
	}
	// A decimal is changed into an integer.
	$w_page = floor($page);
	// It takes less than one for the 1st page.
	if($page < 1){
		return 1;
	}
	// When it is over the total page
	if($w_page > $last){
		$w_page = $last;
	}
	return $w_page;
}


// calculate total number of display items.
// item_show_optional column in xoonips_config table
// -> on : calculate in all public items
// -> off : calculate in items user registered (default)
$tab = $xoopsDB->prefix("xoonips_config");
$sql = "SELECT value FROM ".$tab." WHERE name='item_show_optional'";
$res = $xoopsDB->query($sql);
	if ($res == FALSE){
		echo "ERROR: " . $xoopsDB->error();
		return false;
	}
while($itop = $xoopsDB->fetchArray($res)){
	if($itop["value"] === "on"){
		$val = 1;
	} else {
		$val = 0;
	}
}

$sql = "SELECT index_id FROM ".$xoopsDB->prefix("xoonips_index")." WHERE uid IS NULL AND gid IS NULL";
$res = $xoopsDB->query($sql);
	if ($res == FALSE){
		echo "ERROR: " . $xoopsDB->error();
		return false;
	}
$inid = "";
$itid = "";
$num_of_data = "";
$sum_of_data = "";
$item_htmls = array();
while($row = $xoopsDB->fetchArray($res)){
	$inid = $row["index_id"];
	$sql2 = "SELECT item_id FROM ".$xoopsDB->prefix("xoonips_index_item_link")." WHERE index_id=".$inid." AND certify_state=2";
	$res2 = $xoopsDB->query($sql2);
	while($row2 = $xoopsDB->fetchArray($res2)){
		$itid = $row2["item_id"];
			switch( $val ) {
				case 0:
					$sql3 = "SELECT * FROM ".$xoopsDB->prefix("xoonips_item_basic")." WHERE item_id=".$itid." AND uid=".$uid."";
					$res3 = $xoopsDB->query($sql3);
					$num_of_data = $xoopsDB->getRowsNum($res3);
					$sum_of_data = $sum_of_data + $num_of_data;
					break;
				case 1:
					$sql3 = "SELECT * FROM ".$xoopsDB->prefix("xoonips_item_basic")." WHERE item_id=".$itid."";
					$res3 = $xoopsDB->query($sql3);
					$num_of_data = $xoopsDB->getRowsNum($res3);
					$sum_of_data = $sum_of_data + $num_of_data;
			}
	}
	if( !is_numeric( $sum_of_data ) ){
	$sum_of_data = 0;
	}
}


$xoopsOption['template_main'] = 'xoonips_editshowitem.html';
include XOOPS_ROOT_PATH.'/header.php';


// $page_num_post: page number on page that had been displayed ahead
if( isset( $page_num_post ) ){
	$bepage = $page_num_post;
} else {
	$bepage = '';
}

if( isset( $show_item_check ) ){
    $pre_show = array();
	if( isset( $checkons_post ) ) {
		foreach( $checkons_post as $ckey => $cvalue ){
			if( preg_match( "/,/", $cvalue ) !== 0 ) {
				$chktmp = explode( ",", $cvalue );
				// $chktmps = array();
				// $chktmps = array_merge($chktmps, $chktmp);
			} else {
				$chktmp = array( '0' => $cvalue );
			}
			$pre_show = array_merge($pre_show, $chktmp);
		// dump($pre_show);
		}
		$pre_show = array_merge( $pre_show, $show_item_check );
		// dump($pre_show);
	} else {
		$pre_show = $show_item_check;
	}
	$pre_show = array_unique( $pre_show );
	// dump($pre_show);
} elseif( isset( $checkons_post ) ){
	foreach( $checkons_post as $ckey => $cvalue ){
		if( preg_match( "/,/", $cvalue ) !== 0 ) {
			$chktmp = explode( ",", $cvalue );
			// echo "a";
			// dump($chktmp);
		} else {
			$chktmp = array( '0' => $cvalue );
			// echo "b";
			// dump($chktmp);
		}
		if( isset ( $pre_show ) ) {
			$pre_show = array_merge($pre_show, $chktmp);
			// echo "c";
			// dump($pre_show);
		} else {
			$pre_show = $chktmp;
			// echo "d";
			// dump($pre_show);
		}
	}
	$pre_show = array_unique( $pre_show );
	// dump($pre_show);
}

if( isset( $pre_show ) ){
	if( is_array( $pre_show ) ){
		foreach( $pre_show as $key => $value ){
			if( strcmp( $value, "nocheck" ) !== 0 ){
				$pshow[] = $value;
			}
		}
	} elseif ( strlen( trim( $pre_show ) ) !== 0 ) {
		$pshow = array( '0' => $pre_show );
	}
}

if( isset( $pshow ) ){
	$cnt = 0;
	$uid = intval($uid);
	foreach( $pshow as $key => $value ){
		$value = intval($value);
		$cnt++;
		if( $cnt == 1 ){
			$ins_item = "(".$value. ", " .$uid. ")";
		} else {
			$ins_item .= ", (".$value. ", " .$uid. ")";
		}
	}
}

// If changeButton is set, insert records into xoonips_item_show.
if( isset( $changeButton ) ){
	$tab_name = $xoopsDB->prefix('xoonips_item_show');
	$sql = "SELECT item_id FROM $tab_name WHERE uid='". $uid ."'";
	$res = $xoopsDB->query( $sql );
		if ($res == FALSE){
			echo "ERROR: " . $xoopsDB->error();
			return false;
		} else {
			$sql = "DELETE FROM $tab_name WHERE uid='". $uid ."'";
			$res = $xoopsDB->query( $sql );
			if ($res == FALSE){
				echo "ERROR: " . $xoopsDB->error();
				return false;
			}
		}
		if (isset ($ins_item) ){
			$sql = "INSERT INTO $tab_name (item_id, uid) VALUES $ins_item";
			$res = $xoopsDB->query( $sql );
			if ($res == FALSE){
				echo "ERROR: " . $xoopsDB->error();
				return false;
			}
		}
	$keizoku = array();
	redirect_header( 'showusers.php', 1, _MD_XOONIPS_PUBLICATION_ITEM_INSERT );
}

// calculate total pages and offset
	$w_last = ceil($sum_of_data / 20);
	if( $w_last < 1 ){
		$w_last = 1;
		$w_check =1;
	}
	if( !isset( $pagen ) ) {
		$w_page = page_optimize(1, $w_last);
	}
	else if( is_null($pagen)){
		$w_page = page_optimize(1, $w_last);
	}
	else if( !is_null($pagen)){
		$w_page = page_optimize( $pagen, $w_last);
	}
	$w_offset = intval( ($w_page - 1) * 20 );
	if( $w_offset < 0 ){
		$w_offset = 0;
	}
	$xoopsTpl->assign('sum_of_data', $sum_of_data);

// Display user registered items using itemid2ListBlock
// item_show_optional column in "xoonips config" table
//  -> 0 : calculate user registered items (default)
//  -> 1 : calculate all public items
$tab_name1 = $xoopsDB->prefix('xoonips_item_basic');
$tab_name2 = $xoopsDB->prefix('xoonips_index_item_link');
$tab_name3 = $xoopsDB->prefix('xoonips_index');
$tab_name4 = $xoopsDB->prefix('xoonips_item_type');
$tab_name5 = $xoopsDB->prefix('modules');
switch( $val ) {
	case 0:
	$sql  = "SELECT i1.item_id, i1.item_type_id FROM ".$tab_name1." as i1, ".$tab_name2." as i2, ".$tab_name3." as i3, ".$tab_name4." as i4, ".$tab_name5." as i5 ";
	$sql .= "WHERE i1.item_id=i2.item_id AND i2.index_id=i3.index_id AND i3.uid IS NULL AND i3.gid IS NULL AND i2.certify_state=2 AND i1.item_type_id=i4.item_type_id AND i4.mid=i5.mid AND i1.uid=".$uid." ";
	$sql .= "ORDER BY i5.weight ASC, i1.publication_year DESC, i1.publication_month DESC, i1.publication_mday DESC, i1.last_update_date DESC LIMIT ".$w_offset.", 20";
	$res = $xoopsDB->query($sql);
	break;
	case 1:
	$sql  = "SELECT i1.item_id, i1.item_type_id FROM ".$tab_name1." as i1, ".$tab_name2." as i2, ".$tab_name3." as i3, ".$tab_name4." as i4, ".$tab_name5." as i5 ";
	$sql .= "WHERE i1.item_id=i2.item_id AND i2.index_id=i3.index_id AND i3.uid IS NULL AND i3.gid IS NULL AND i2.certify_state=2 AND i1.item_type_id=i4.item_type_id AND i4.mid=i5.mid ";
	$sql .= "ORDER BY i5.weight ASC, i1.publication_year DESC, i1.publication_month DESC, i1.publication_mday DESC, i1.last_update_date DESC LIMIT ".$w_offset.", 20";
	$res = $xoopsDB->query($sql);
}


if( isset( $checkons_post ) ){
	foreach($checkons_post as $key => $value){
		$cshow = explode( ",", $value );
	}
} else {
	$checkons_post = array();
}


if( !isset( $pass_pages ) || !is_array( $pass_pages ) ) {
	// echo "a";
	$check = '';
	$item_tmp = array();
		$ch_a ='';
	while($row = $xoopsDB->fetchArray($res)){
			// show item_type's name
			$ch_b = intval( $row["item_type_id"] );
			if( empty($ch_a) || $ch_a !== $ch_b ){
				$tab_name = $xoopsDB->prefix('xoonips_item_type');
				$tsql = "SELECT display_name FROM ".$tab_name." WHERE item_type_id=".$ch_b."";
				$tres = $xoopsDB->query($tsql);
				$trow = $xoopsDB->fetchArray($tres);
					$item_type_title = $textutil->html_special_chars($trow['display_name']);
					$title_t = "<table><tr><th>".$item_type_title."</th></tr></table>";
					$item_htmls[] = array( 'html'=>$title_t );
			}
			$check = intval( $row["item_id"] );
			$item_tmp[] = $check;
			// $csql = "SELECT item_id FROM ".$xoopsDB->prefix("xoonips_item_show")." where item_id=".$check." AND uid=".$uid." AND show_state='1'";
			$csql = "SELECT item_id FROM ".$xoopsDB->prefix("xoonips_item_show")." where item_id=".$check." AND uid=".$uid."";
			$cres = $xoopsDB->query($csql);
			$crow = $xoopsDB->getRowsNum( $cres );
			$chehi = "";
				if( $crow == 1 ) {
					$chehi = 1;
					// echo "a1,";
				}
				elseif( $crow == 0 ) {
						$chehi = 0;
					// echo "b1,";
				}
		$tmp = itemid2ListBlock( $check );
		foreach($tmp as $key =>$value ){
			$item_htmls[] =  array( 'html'=>$value, 'item_id'=>$key, 'check'=>$chehi);
		}
			$ch_a = intval( $row["item_type_id"] );
	}
} else {
	if( preg_match( "/,/", $pass_pages['pass'] ) == 1 ) {
		$passes = explode( ",", $pass_pages['pass'] );
		if( in_array( $pagen, $passes ) ) {
			$check = '';
			if( isset($pshow) ){
				$checkids = $pshow;
			} else {
				$checkids ='';
			}
		$ch_a ='';
			while($row = $xoopsDB->fetchArray($res)){
			// show item_type's name
			$ch_b = intval( $row["item_type_id"] );
			if( empty($ch_a) || $ch_a !== $ch_b ){
				$tab_name = $xoopsDB->prefix('xoonips_item_type');
				$tsql = "SELECT display_name FROM ".$tab_name." WHERE item_type_id=".$ch_b."";
				$tres = $xoopsDB->query($tsql);
				$trow = $xoopsDB->fetchArray($tres);
					$item_type_title = $textutil->html_special_chars($trow['display_name']);
					$title_t = "<table><tr><th>".$item_type_title."</th></tr></table>";
					$item_htmls[] = array( 'html'=>$title_t );
			}
					$check = intval( $row["item_id"] );
					// dump($check);
					// var_dump(is_array($checkids));
					$item_tmp[] = $check;
					$chehi = "";
					if( is_array( $checkids ) ){
						if( array_search( $check, $checkids ) !== false ) {
							$chehi = 1;
							// echo "c1,";
							$tmp = itemid2ListBlock( $check );
								foreach($tmp as $key => $value ){
										$item_htmls[] =  array( 'html'=>$value, 'item_id'=>$key, 'check'=>$chehi);
								}
			$ch_a = intval( $row["item_type_id"] );
						} else {
							$chehi = 0;
							// echo "d1,";
							$tmp = itemid2ListBlock( $check );
								foreach($tmp as $key => $value ){
										$item_htmls[] =  array( 'html'=>$value, 'item_id'=>$key, 'check'=>$chehi);
								}
			$ch_a = intval( $row["item_type_id"] );
						}
					} else {
						$chehi = 0;
						// echo "k1,";
						$tmp = itemid2ListBlock( $check );
							foreach($tmp as $key => $value ){
									$item_htmls[] =  array( 'html'=>$value, 'item_id'=>$key, 'check'=>$chehi);
							}
			$ch_a = intval( $row["item_type_id"] );
					}
			}
		} else {
			$check = '';
		$ch_a ='';
			while($row = $xoopsDB->fetchArray($res)){
			// show item_type's name
			$ch_b = intval( $row["item_type_id"] );
			if( empty($ch_a) || $ch_a !== $ch_b ){
				$tab_name = $xoopsDB->prefix('xoonips_item_type');
				$tsql = "SELECT display_name FROM ".$tab_name." WHERE item_type_id=".$ch_b."";
				$tres = $xoopsDB->query($tsql);
				$trow = $xoopsDB->fetchArray($tres);
					$item_type_title = $textutil->html_special_chars($trow['display_name']);
					$title_t = "<table><tr><th>".$item_type_title."</th></tr></table>";
					$item_htmls[] = array( 'html'=>$title_t );
			}
					$check = intval( $row["item_id"] );
					$item_tmp[] = $check;
					// $csql = "SELECT item_id FROM ".$xoopsDB->prefix("xoonips_item_show")." where item_id=".$check." AND uid=".$uid." AND show_state='1'";
					$csql = "SELECT item_id FROM ".$xoopsDB->prefix("xoonips_item_show")." where item_id=".$check." AND uid=".$uid."";
					$cres = $xoopsDB->query($csql);
					$crow = $xoopsDB->getRowsNum( $cres );
					$chehi = "";
						if( $crow == 1 ) {
							$chehi = 1;
							// echo "e1,";
						}
						elseif( $crow == 0 ) {
								$chehi = 0;
							// echo "f1,";
						}
				$tmp = itemid2ListBlock( $check );
				foreach($tmp as $key =>$value ){
					$item_htmls[] =  array( 'html'=>$value, 'item_id'=>$key, 'check'=>$chehi);
				}
			$ch_a = intval( $row["item_type_id"] );
			}
		}
	} else {
		$passes = $pass_pages['pass'];
		if( $pagen == $passes ) {
			$check = '';
			$checkids = $pshow;
		$ch_a ='';
			while($row = $xoopsDB->fetchArray($res)){
			// show item_type's name
			$ch_b = intval( $row["item_type_id"] );
			if( empty($ch_a) || $ch_a !== $ch_b ){
				$tab_name = $xoopsDB->prefix('xoonips_item_type');
				$tsql = "SELECT display_name FROM ".$tab_name." WHERE item_type_id=".$ch_b."";
				$tres = $xoopsDB->query($tsql);
				$trow = $xoopsDB->fetchArray($tres);
					$item_type_title = $textutil->html_special_chars($trow['display_name']);
					$title_t = "<table><tr><th>".$item_type_title."</th></tr></table>";
					$item_htmls[] = array( 'html'=>$title_t );
			}
					$check = intval( $row["item_id"] );
					// dump($check);
					// dump($checkids);
					$item_tmp[] = $check;
					$chehi = "";
					if( array_search( $check, $checkids ) !== false ) {
						$chehi = 1;
						// echo "g1,";
						$tmp = itemid2ListBlock( $check );
							foreach($tmp as $key => $value ){
									$item_htmls[] =  array( 'html'=>$value, 'item_id'=>$key, 'check'=>$chehi);
							}
			$ch_a = intval( $row["item_type_id"] );
					} else {
						$chehi = 0;
						// echo "h1,";
						$tmp = itemid2ListBlock( $check );
							foreach($tmp as $key => $value ){
									$item_htmls[] =  array( 'html'=>$value, 'item_id'=>$key, 'check'=>$chehi);
							}
			$ch_a = intval( $row["item_type_id"] );
					}
			}
		} else {
			$check = '';
		$ch_a ='';
			while($row = $xoopsDB->fetchArray($res)){
			// show item_type's name
			$ch_b = intval( $row["item_type_id"] );
			if( empty($ch_a) || $ch_a !== $ch_b ){
				$tab_name = $xoopsDB->prefix('xoonips_item_type');
				$tsql = "SELECT display_name FROM ".$tab_name." WHERE item_type_id=".$ch_b."";
				$tres = $xoopsDB->query($tsql);
				$trow = $xoopsDB->fetchArray($tres);
					$item_type_title = $textutil->html_special_chars($trow['display_name']);
					$title_t = "<table><tr><th>".$item_type_title."</th></tr></table>";
					$item_htmls[] = array( 'html'=>$title_t );
			}
					$check = intval( $row["item_id"] );
					$item_tmp[] = $check;
					$csql = "SELECT item_id FROM ".$xoopsDB->prefix("xoonips_item_show")." where item_id=".$check." AND uid=".$uid."";
					$cres = $xoopsDB->query($csql);
					$crow = $xoopsDB->getRowsNum( $cres );
					$chehi = "";
						if( $crow == 1 ) {
							$chehi = 1;
						//	 echo "i1,";
						}
						elseif( $crow == 0 ) {
								$chehi = 0;
						//	 echo "j1,";
						}
				$tmp = itemid2ListBlock( $check );
				foreach($tmp as $key =>$value ){
					$item_htmls[] =  array( 'html'=>$value, 'item_id'=>$key, 'check'=>$chehi);
				}
			$ch_a = intval( $row["item_type_id"] );
			}
		}
	}
}


$page_num = intval( $w_page );
$xoopsTpl->assign( 'page_num', $page_num );
$xoopsTpl->assign('item_htmls', $item_htmls);

if( isset( $index_id ) ){
	$xoopsTpl->assign('index_id', $index_id );
}


// make a page navigation
if ( $w_page > 1 ){
	$w_back = intval( $w_page - 1 );
	$xoopsTpl->assign('w_back', $w_back);
}

if(!isset($pages)){
	$pages = array( min( max( 0, $w_page - 4 ), max( 0, $w_last - 9 ) ) );
}


// for( $i = 1 ; $i < 10 && $pages[ $i - 1 ] <= $sum_of_data / 20; $i++ ){
$w_link = array();
for( $i = $pages[0]+1; $i <= min(10, ceil( $sum_of_data / 20 ) ); $i++ ) {
	$pages[ $i ] = $pages[ $i - 1 ] + 1;
	$pag = $pages[ $i ];
	switch ( $pages[ $i ] ) {
		case $w_page:
			if($w_last != 1){
			$link = "&nbsp;".$pages[ $i ]."&nbsp;";
			} else {
			$link = '';
			}
			break;
		default:
			$link ="&nbsp;<a href=\"#\" onclick=\"return xoonips_editshowitem_pagenavi(".$pag.");\">".$pag."</a>&nbsp;";
	}
	$w_link[] = array('link'=>$link);
	}
if( $w_link ){
	$xoopsTpl->assign('w_link', $w_link);
}
if ( $w_page < $w_last ){
	$w_next = intval( $w_page + 1 );
	$xoopsTpl->assign('w_next', $w_next);
}




// item_ids in the page
if( $item_tmp ){
	foreach( $item_tmp as $num => $itemid ){
		$sumitem[] = intval( $itemid );
	}
	$page_item = array( $bepage => implode(",", $sumitem) );
	foreach( $page_item as $nums => $itemids ){
		$page_items = array();
		$page_items[] = array( 'nums'=>$nums, 'itemids'=>$itemids);
	}
	$xoopsTpl->assign('page_items', $page_items);
}

if( count( $checkons_post ) > 0 ) {
	foreach( $checkons_post as $pokey => $povalue ){
		$check_page = substr_count( $bepage, "x" );
		switch ( $check_page ){
			case 0:
				$bepage = "x".$bepage;
				break;
			case 1:
				break;
			case ( $check_page >= 2 ):
				$bepage = eregi_replace("x", "", $bepage);
				$bepage = "x".$bepage;
		}
		// dump($bepage);
		if( $pokey !== $bepage ){
			$p_checkons[] = array( 'page'=>$pokey, 'checks'=>$povalue );
		} elseif( !isset($show_item_check) || count( $show_item_check ) == 0 ){
			$p_checkons[] = array( 'page'=>$bepage, 'checks'=>'nocheck' );
		}
	}
} else {
	$p_checkons[] = array( 'page'=>'x'.$page_num, 'checks'=>'nocheck' );
}
// dump($p_checkons);
if( isset( $show_item_check ) && count( $show_item_check ) !== 0 ){
	$check_page = substr_count( $bepage, "x" );
	switch ( $check_page ){
		case 0:
			$bepage = "x".$bepage;
			break;
		case 1:
			break;
		case ( $check_page >= 2 ):
			$bepage = eregi_replace("x", "", $bepage);
			$bepage = "x".$bepage;
	}
	// dump($bepage);
	$checks = array($bepage => implode(",", $show_item_check));
	// dump($checks);
	foreach( $checks as $page => $checks ){
		// $page = "x".$page;
		$i = 0;
		$cpage = "x".$i;
		// dump($i);
		// dump($cpage);
		//  dump($p_checkons);
		// if( isset( $p_checkons ) && $p_checkons[$i] ) == FALSE ){
		if( isset( $p_checkons ) ){
			if( is_array( $p_checkons[$i] ) ){
				if( array_search( $page, $p_checkons[$i] ) == FALSE ){
					$p_sicheck[] = array( 'page'=>$page, 'checks'=>$checks );
					$i++;
				 //echo "aa";
				 //dump($p_sicheck);
				}
			} else {
			$p_sicheck[] = array( 'page'=>$page, 'checks'=>$checks );
			 //echo "ab";
			 //dump($p_sicheck);
			}
		}
	}
	// dump($p_sicheck);
	if( is_array( $p_checkons ) ){
		foreach( $p_checkons as $c_num => $c_ar ){
			foreach( $p_sicheck as $num => $ar){
				//	dump($ar['page']);
				//	dump($c_ar);
				if( array_search( $ar['page'], $c_ar ) ){
					$checkons[] = $ar;
					//dump($checkons);
				} else {
					if( $ar['checks'] == 'nocheck' ){
					$checkons[] = $ar;
					} else {
					$checkons[] = $c_ar;
					//dump($checkons);
					}
				}
			}
		}
		// dump($checkons);
		$checkons = array_merge( $p_checkons, $p_sicheck );
	} else {
		$checkons = $p_sicheck;
	}
	$xoopsTpl->assign('checkons', $checkons);
} elseif( count( $checkons_post ) !== 0 ) {
	// echo "a";
	foreach( $checkons_post as $page => $value ){
		if($page !== $bepage){
			$checkons[] = array( 'page'=>$page, 'checks'=>$value );
		} else {
			$checkons[] = array( 'page'=>$bepage, 'checks'=>'nocheck' );
		}
	}
	$xoopsTpl->assign('checkons', $checkons);
} else {
	if( isset( $pagen ) ){
		$checkons[] = array('page'=>$pagen, 'checks'=>'nocheck' );
	} else {
		$checkons[] = array();
	}
}


// passed pages
if( isset( $page_num ) ) {
	if( isset( $pass_pages ) ) {
		if( strpos( $pass_pages['pass'], "," ) === FALSE ){
			$pre_pass = $pass_pages;
			array_push( $pre_pass, $page_num );
		} else {
			$pre_pass = explode( ",", $pass_pages['pass'] );
			$page_num = strval($page_num);
			$pre_pass[] = $page_num;
		}
		$pre_pass = array_unique($pre_pass);
		$pass_pages = implode( ",", $pre_pass );
	} else {
		$pass_pages = $page_num;
	}
	$xoopsTpl->assign( 'pass_pages', $pass_pages );
}

include XOOPS_ROOT_PATH.'/footer.php';

?>
