<?php
//  XooNIps article item type module
//  $Revision: 1.4 $
//  --------------------------------------------------------------------------
//  XooNIps Library Module Xoops modules for XooNIps Platforms
//  Copyright (C) 2006 Keio University and RIKEN, Japan. All rights reserved.
//  http://sourceforge.jp/projects/xoonips-library/
//  --------------------------------------------------------------------------
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//  --------------------------------------------------------------------------

function xoops_module_update_xnparticle ( $xoopsMod, $oldversion) {

	global $xoopsDB;
	switch ($oldversion) { //remember that version is multiplied with 100 to get an integer
	case 100:
		// 
		// change table type from MyISAM to InnoDB
		//
   		foreach( array( 'xnparticle_item_detail',
			'xnparticle_item_detail_child_author',
			'xnparticle_item_detail_child_id_dois',
			'xnparticle_item_detail_child_id_isbns',
			'xnparticle_item_detail_child_id_issns',
			'xnparticle_item_detail_child_id_locals',
			'xnparticle_item_detail_child_id_uris',
			'xnparticle_item_detail_child_keywords',
			'xnparticle_item_detail_child_langs',
			'xnparticle_item_detail_child_ndc_classifications',
			'xnparticle_item_detail_child_physical_descriptions',
			'xnparticle_item_detail_child_sub_title',
			'xnparticle_item_detail_child_uris') as $table ){
			$sql = "ALTER TABLE " . $xoopsDB->prefix( $table ) . " TYPE = innodb";
			$result = $xoopsDB->query( $sql );
			if( !$result ){
				echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
			}
		}
	
	case 110:
		// 
		// modify some table column size 
		//
                $sql = "alter table " . $xoopsDB->prefix( "xnparticle_item_detail" ) . " modify year_f varchar(50), modify year_t varchar(50), modify date_create varchar(50), modify date_update varchar(50), modify date_record varchar(50)";
		$result = $xoopsDB->query( $sql );
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		}
                $sql = "alter table " . $xoopsDB->prefix( "xnparticle_item_detail_child_physical_descriptions" ) . " modify physical_descriptions varchar(1000)";
		$result = $xoopsDB->query( $sql );
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		}
                $sql = "alter table " . $xoopsDB->prefix( "xnparticle_item_detail_child_id_uris" ) . " modify id_uris varchar(1000)";
		$result = $xoopsDB->query( $sql );
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		}
                $sql = "alter table " . $xoopsDB->prefix( "xnparticle_item_detail_child_uris" ) . " modify uris varchar(1000)";
		$result = $xoopsDB->query( $sql );
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		}

	case 120:
	case 130:
		// 
		// create article_id index
		//
                $sql = "create index idx_article_id on " . $xoopsDB->prefix( "xnparticle_item_detail_child_sub_title" ) . " (article_id)";
		$result = $xoopsDB->query( $sql );
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		}
                $sql = "create index idx_article_id on " . $xoopsDB->prefix( "xnparticle_item_detail_child_author" ) . " (article_id)";
		$result = $xoopsDB->query( $sql );
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		}
                $sql = "create index idx_article_id on " . $xoopsDB->prefix( "xnparticle_item_detail_child_keywords" ) . " (article_id)";
		$result = $xoopsDB->query( $sql );
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		}
                $sql = "create index idx_article_id on " . $xoopsDB->prefix( "xnparticle_item_detail_child_ndc_classifications" ) . " (article_id)";
		$result = $xoopsDB->query( $sql );
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		}
                $sql = "create index idx_article_id on " . $xoopsDB->prefix( "xnparticle_item_detail_child_physical_descriptions" ) . " (article_id)";
		$result = $xoopsDB->query( $sql );
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		}
                $sql = "create index idx_article_id on " . $xoopsDB->prefix( "xnparticle_item_detail_child_langs" ) . " (article_id)";
		$result = $xoopsDB->query( $sql );
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		}
                $sql = "create index idx_article_id on " . $xoopsDB->prefix( "xnparticle_item_detail_child_id_isbns" ) . " (article_id)";
		$result = $xoopsDB->query( $sql );
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		}
                $sql = "create index idx_article_id on " . $xoopsDB->prefix( "xnparticle_item_detail_child_id_issns" ) . " (article_id)";
		$result = $xoopsDB->query( $sql );
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		}
                $sql = "create index idx_article_id on " . $xoopsDB->prefix( "xnparticle_item_detail_child_id_dois" ) . " (article_id)";
		$result = $xoopsDB->query( $sql );
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		}
                $sql = "create index idx_article_id on " . $xoopsDB->prefix( "xnparticle_item_detail_child_id_uris" ) . " (article_id)";
		$result = $xoopsDB->query( $sql );
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		}
                $sql = "create index idx_article_id on " . $xoopsDB->prefix( "xnparticle_item_detail_child_id_locals" ) . " (article_id)";
		$result = $xoopsDB->query( $sql );
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		}
                $sql = "create index idx_article_id on " . $xoopsDB->prefix( "xnparticle_item_detail_child_uris" ) . " (article_id)";
		$result = $xoopsDB->query( $sql );
		if( !$result ){
			echo "ERROR: line=" . __LINE__ . " sql=$sql " .$xoopsDB->error();
		}
	case 131:

	default:
		return true;
	}
	return true;
}
?>
