// $Id$

//=============================================================================
/**
 *  @file  fileio.hpp
 *
 *  @author  Fukasawa Mitsuo
 *
 *    Copyright (C) 2001-2006 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef BEE_FILEIO_H
#define BEE_FILEIO_H

#include "bee/beeconf.hpp"
#include "bee/booster.hpp"
#include <boost/shared_ptr.hpp>

// prototype

namespace bee
{

//-----------------------------------------------------------------------------
// File Wrapper Class
//-----------------------------------------------------------------------------
class BEE_Export fileio
{
public:
    typedef std::map<std::string, fileio *> file_map;

    fileio();
    fileio(const BCHAR * filename);
    fileio(const std::string& filename);
    fileio(const std::string& dir, const std::string& filename,
           const std::string& ext);
    ~fileio();

    // Create the file.
    int open(const std::string& filename);

    // Close the file.
    int close();

    // Close the file.
    void remove();

    // Write data to file
    int write(const BYTE * buf, size_t size);

    int write(const std::string& text);

    // Read data from file
    int read(BYTE * buf, size_t size);

    // Get size
    size_t size();

protected:

// member variables
protected:
    boost::filesystem::path path_;
    boost::shared_ptr<class File> file_;
};

} // *namespace* - bee

#endif // BEE_FILEIO_H
