/* $Id$ */

//=============================================================================
/**
 *  @file    failure.hpp
 *
 *  @author Fukasawa Mitsuo
 *
 *    Copyright (C) 1998-2006 BEE Co.,Ltd. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
//=============================================================================

#ifndef BEE_FAILURE_H
#define BEE_FAILURE_H

#include "bee/beeconf.hpp"

namespace bee
{

//
//
class BEE_Export failure : public std::runtime_error
{
public:
    failure(const BCHAR * msg) : std::runtime_error(msg) {}
    failure(const std::string& msg) : std::runtime_error(msg.c_str()) {}
    failure(const failure& rhs)
        : std::runtime_error((const std::runtime_error&)rhs) {}
    virtual ~failure() throw() {}

    failure& operator=(const failure& rhs)
    {
    	failure temp(rhs);
    	this->std::runtime_error::operator=(temp);
    	return *this;
    }
};


} // namespace - bee

#endif  /* BEE_FAILURE_H */
