// $Id$
//
// Copyright (C) 2006 BEE Co.,Ltd.
//
// Author : Fukasawa Mitsuo
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//

#ifndef BEE_XSD_HPP
#define BEE_XSD_HPP

#include "boost/shared_ptr.hpp"
using boost::shared_ptr;

namespace bee { namespace xsd
{

template<typename T>
struct element_ptr
{
    typedef T   type;
    typedef T * pointer;

    element_ptr() : ptr_() {}
    element_ptr(const element_ptr& rhs) : ptr_(rhs.ptr_), stack_(rhs.stack_) {}
    ~element_ptr() {}
    element_ptr<T>& operator=(const element_ptr<T>& rhs)
    {
        element_ptr<T> tmp(rhs);
        ptr_.swap(tmp.ptr_);
        stack_.swap(tmp.stack_);
        return *this;
    }
 
    T * operator->() const { return ptr_.get(); }
    T * get() const { return ptr_.get(); }
    void reset(T * p) { ptr_.reset(p); }

    const shared_ptr<T>& shared() const { return ptr_; }

    void pre()
    {
        if (ptr_.get() != NULL)
        {
            stack_.push(ptr_);
        }
        ptr_.reset(new T);
    }
    
    element_ptr<T> post()
    {
        element_ptr<T> tmp;
        ptr_.swap(tmp.ptr_);
        if (stack_.size() > 0)
        {
            ptr_.swap(stack_.top());
            stack_.pop();
        }
        return tmp;
    }

private:        
    shared_ptr<T> ptr_;
    std::stack<shared_ptr<T> > stack_; 
};

    
} } // namespace - bee::xsd

#endif /*BEE_XSD_HPP*/
