package org.torikiri.xlsapi.sheet;

import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.util.Region;
import org.torikiri.xlsapi.DefaultProperty;
import org.torikiri.xlsapi.XlsContext;

public class MargedRegion extends DefaultProperty<HSSFSheet> {

	private int rowFrom;

	private int rowTo;

	private short columnFrom;

	private short columnTo;

	public void build(XlsContext ctx, HSSFSheet sheet) {
		sheet.addMergedRegion(new Region(rowFrom, columnFrom, rowTo, columnTo));
	}
}
