package org.torikiri.xlsapi.sheet;

import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.torikiri.xlsapi.DefaultProperty;
import org.torikiri.xlsapi.Style;
import org.torikiri.xlsapi.XlsContext;

public class DefaultColumnStyle extends DefaultProperty<HSSFSheet> {

	private short column;

	private Style style;

	public void build(XlsContext ctx, HSSFSheet sheet) {
		HSSFCellStyle cellStyle = ctx.getCurrentBook().createCellStyle();
		style.build(ctx, cellStyle);
		sheet.setDefaultColumnStyle(column, cellStyle);
	}

}
