package org.torikiri.xlsapi.cell;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.torikiri.xlsapi.XlsContext;

public abstract class AbstractCellValue<T> implements CellValue {

	protected T value;

	public AbstractCellValue(T value) {
		this.value = value;
	}

	public final Object getKey() {
		return CellValue.class;
	}

	public final void build(XlsContext ctx, HSSFCell cell) {
		build(cell);
	}

	public abstract void build(HSSFCell cell);
	
}