package org.torikiri.xlsapi;

import java.util.Calendar;
import java.util.Date;


public class XlsAPI {

	protected XlsAPI() {}

	public static Xls xls(Sheet... sheets) {
		return new Xls(sheets);
	}

	public static Xls xls(boolean condition, Sheet... sheets) {
		return new Xls(condition, sheets);
	}

	public static Sheet sheet(boolean condition, Row... rows) {
		return new Sheet(condition, rows);
	}

	public static Sheet sheet(Row... rows) {
		return new Sheet(rows);
	}

	public static Sheet sheet(String name) {
		return new Sheet(name);
	}

	public static Row row(Cell... cells) {
		return new Row(cells);
	}

	public static Cell cell(boolean value) {
		return new Cell(value);
	}

	public static Cell cell(Calendar value) {
		return new Cell(value);
	}

	public static Cell cell(Date value) {
		return new Cell(value);
	}

	public static Cell cell(double value) {
		return new Cell(value);
	}

	public static Cell cell(String value) {
		return new Cell(value);
	}

	public static Style style() {
		return new Style();
	}
}
