package org.torikiri.xlsapi;

import org.apache.poi.hssf.usermodel.HSSFRow;
import org.torikiri.xlsapi.row.RowHeight;
import org.torikiri.xlsapi.row.RowHeightInPoints;

public class Row extends AbstractElement<Row, Cell>{

	private int index = -1;

	private PropertySet<HSSFRow, Property<HSSFRow>> properties = new PropertySet<HSSFRow, Property<HSSFRow>>();

	public Row(Cell... cells) {
		add(cells);
	}

	public Row(int index, Cell... cells) {
		this.index = index;
		add(cells);
	}

	public Row height(int height) {
		return add(new RowHeight((short) height));
	}

	public Row height(short height) {
		return add(new RowHeight(height));
	}

	public Row heightInPoints(int heightInPoints) {
		return add(new RowHeightInPoints((float) heightInPoints));
	}

	public Row heightInPoints(float heightInPoints) {
		return add(new RowHeightInPoints(heightInPoints));
	}

	private Row add(Property<HSSFRow> property) {
		properties.add(property);
		return this;
	}

	protected int getIndex() {
		return index;
	}

	protected void build(XlsContext ctx, HSSFRow row) {
		int i = 0;
		for (Cell c : children) {
			i = c.getIndex() < 0 ? i : c.getIndex();
			c.build(ctx, ctx.nextCell(i++));
		}
		properties.build(ctx, row);
	}

	@Override
	public Row getThis() {
		return this;
	}
}
