package org.torikiri.xlsapi;

import java.util.HashMap;
import java.util.Map;

public class PropertySet<E, T extends Property<E>> {

	private Map<Object, T> properties = new HashMap<Object, T>();

	public void add(T property) {
		properties.put(property.getKey(), property);
	}

	public void build(XlsContext ctx, E element) {
		for (T prop : properties.values()) prop.build(ctx, element);
	}
}
