/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.RefEval;
import org.apache.poi.hssf.record.formula.eval.StringEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.Function;

public final class Counta
implements Function {
    public Eval evaluate(Eval[] args, int srcCellRow, short srcCellCol) {
        int nArgs = args.length;
        if (nArgs < 1) {
            return ErrorEval.VALUE_INVALID;
        }
        if (nArgs > 30) {
            return ErrorEval.VALUE_INVALID;
        }
        int temp = 0;
        for (int i = 0; i < nArgs; ++i) {
            temp += Counta.countArg(args[i]);
        }
        return new NumberEval(temp);
    }

    private static int countArg(Eval eval) {
        if (eval instanceof AreaEval) {
            AreaEval ae = (AreaEval)eval;
            return Counta.countAreaEval(ae);
        }
        if (eval instanceof RefEval) {
            RefEval refEval = (RefEval)eval;
            return Counta.countValue(refEval.getInnerValueEval());
        }
        if (eval instanceof NumberEval) {
            return 1;
        }
        if (eval instanceof StringEval) {
            return 1;
        }
        throw new RuntimeException("Unexpected eval type (" + eval.getClass().getName() + ")");
    }

    private static int countAreaEval(AreaEval ae) {
        int temp = 0;
        ValueEval[] values = ae.getValues();
        for (int i = 0; i < values.length; ++i) {
            ValueEval val = values[i];
            if (val == null) continue;
            temp += Counta.countValue(val);
        }
        return temp;
    }

    private static int countValue(ValueEval valueEval) {
        if (valueEval == BlankEval.INSTANCE) {
            return 0;
        }
        if (valueEval instanceof BlankEval) {
            return 0;
        }
        if (valueEval instanceof ErrorEval) {
            return 1;
        }
        return 1;
    }
}

