/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndian;

public final class DBCellRecord
extends Record {
    public static final int BLOCK_SIZE = 32;
    public static final short sid = 215;
    private int field_1_row_offset;
    private short[] field_2_cell_offsets;

    public DBCellRecord() {
    }

    public DBCellRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != 215) {
            throw new RecordFormatException("NOT A valid DBCell RECORD");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.field_1_row_offset = in.readUShort();
        int size = in.remaining();
        this.field_2_cell_offsets = new short[size / 2];
        for (int i = 0; i < this.field_2_cell_offsets.length; ++i) {
            this.field_2_cell_offsets[i] = in.readShort();
        }
    }

    public void setRowOffset(int offset) {
        this.field_1_row_offset = offset;
    }

    public void addCellOffset(short offset) {
        if (this.field_2_cell_offsets == null) {
            this.field_2_cell_offsets = new short[1];
        } else {
            short[] temp = new short[this.field_2_cell_offsets.length + 1];
            System.arraycopy(this.field_2_cell_offsets, 0, temp, 0, this.field_2_cell_offsets.length);
            this.field_2_cell_offsets = temp;
        }
        this.field_2_cell_offsets[this.field_2_cell_offsets.length - 1] = offset;
    }

    public int getRowOffset() {
        return this.field_1_row_offset;
    }

    public short getCellOffsetAt(int index) {
        return this.field_2_cell_offsets[index];
    }

    public int getNumCellOffsets() {
        return this.field_2_cell_offsets.length;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[DBCELL]\n");
        buffer.append("    .rowoffset       = ").append(Integer.toHexString(this.getRowOffset())).append("\n");
        for (int k = 0; k < this.getNumCellOffsets(); ++k) {
            buffer.append("    .cell_" + k + "          = ").append(Integer.toHexString(this.getCellOffsetAt(k))).append("\n");
        }
        buffer.append("[/DBCELL]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        if (this.field_2_cell_offsets == null) {
            this.field_2_cell_offsets = new short[0];
        }
        LittleEndian.putShort(data, 0 + offset, (short)215);
        LittleEndian.putShort(data, 2 + offset, (short)(4 + this.getNumCellOffsets() * 2));
        LittleEndian.putInt(data, 4 + offset, this.getRowOffset());
        for (int k = 0; k < this.getNumCellOffsets(); ++k) {
            LittleEndian.putShort(data, 8 + 2 * k + offset, this.getCellOffsetAt(k));
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 8 + this.getNumCellOffsets() * 2;
    }

    public static int calculateSizeOfRecords(int nBlocks, int nRows) {
        return nBlocks * 8 + nRows * 2;
    }

    public short getSid() {
        return 215;
    }

    public boolean isInValueSection() {
        return true;
    }
}

