/*
 * 쐬: 2003/10/23
 *
 * xls2src main
 * 
 */
package jp.ne.dti.venus.okazaki.xls2src;

import java.io.*;
import org.apache.commons.cli.*;

/**
 * @author kenichi_okazaki
 *
 * xls2src main
 * 
 */
public class Xls2src {

	public static void main(String[] args) throws IOException, Exception {

		//XMLt@C̓ǂݍ
		XmlLoader xmlloader = new XmlLoader();
		GeneratorInfo ginfo = (GeneratorInfo)xmlloader.execute("digester.xml","generateInfo.xml") ;	//XMLt@C̓ǂݍ
		
		//R}hCIvV̓ǂݍ
		Options options = new Options();
		options.addOption(
			OptionBuilder
				.withArgName("xlsFileName")
				.hasArg()
				.withDescription("݌vXlst@C(ftHg:data/workbook.xls)")
				.create("f"));

		options.addOption(
			OptionBuilder
				.withArgName("templateFolderName")
				.hasArg()
				.withDescription("ev[gtH_(ftHg:template)")
				.create("t"));

		options.addOption(
			OptionBuilder
				.withArgName("distFolderName")
				.hasArg()
				.withDescription("otH_(ftHg:destDir)")
				.create("d"));

		options.addOption("h", false, "wv\");

		CommandLineParser parser = new BasicParser();
		CommandLine cmd;
		try {
			cmd = parser.parse(options, args);
		} catch (ParseException pe) {
			displayHelp(options);

			return;
		}

		if (cmd.hasOption("h")) {
			displayHelp(options);
			return;
		}

		if (cmd.hasOption("f")) {
			ginfo.putSetting("xlsFileName" ,cmd.getOptionValue('f') );
		}

		if (cmd.hasOption("t")) {
			ginfo.putSetting("templateFolderName" ,cmd.getOptionValue('t') );
		}

		if (cmd.hasOption("d")) {
			ginfo.putSetting("destDirName" ,cmd.getOptionValue('d') );
		}
		
		Generator generator = new Generator(ginfo);
		generator.execute();
		

	}
	private static void displayHelp(Options options) {
		HelpFormatter formatter = new HelpFormatter();
		formatter.printHelp("xls2src", options, true);

	}

}
