/*
 * 쐬: 2003/11/10
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
package jp.ne.dti.venus.okazaki.xls2src;

import java.io.*;

import java.util.HashMap;
import java.util.ArrayList;

import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.usermodel.HSSFSheet;

import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;



/**
 * @author kenichi_okazaki
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public class Generator {
	
	GeneratorInfo _ginfo ;	//generator̐ݒ

	/**
	 * 
	 */
	public Generator(GeneratorInfo ginfo ) {
		_ginfo = ginfo;

	}

	public void execute() throws Exception {
		
		ArrayList modelCollection = getModelCollection();
		excute2( modelCollection);

	}

	private ArrayList getModelCollection() throws IOException{
		ArrayList modelCollection = new ArrayList();
		String sheetName;

		POIFSFileSystem fs      =
				new POIFSFileSystem(new FileInputStream( _ginfo.getSettingValue("xlsFileName")  ));
		HSSFWorkbook wb = new HSSFWorkbook(fs);	//[NubN̎擾

		//ڎ̎擾
		HSSFSheet indexSheet = wb.getSheet("index");
		Table indexTable = new Table( indexSheet);
		
		//CMR̎擾
		HSSFSheet cmrInfoSheet = wb.getSheet("CMR");	
		Table cmrInfoTable = new Table( cmrInfoSheet);
						
		for( int i = 0 ; i < indexTable.getRows().size()   ; i++ ){
			HashMap info  = (HashMap)indexTable.getRows().get(i);
			info.get("sheet");
			
			//V[g̎擾
			HSSFSheet sheet = wb.getSheet( (String)info.get("sheet") );
			Table table = new Table( sheet);
			
			//f̐
			Model model = new Model();
			model.setInfo(info);
			model.setRows(table.getRows() );
			model.setCmrInfo(cmrInfoTable.getRows() );
				
			
			System.out.println("class" + info.get("NX") + i );
			modelCollection.add( model );
		}
		
		return modelCollection;
		
	}
	
	/**
	 * Java\[X̎s
	 * 
	 * @throws Exception
	 */
	public void excute2( ArrayList modelCollection ) throws Exception ,IOException {

		ArrayList templates = _ginfo.getTemplates() ;
		
		Util util = new Util();

		Velocity.init("velocity.properties");
		VelocityContext context = new VelocityContext();

		for (int i = 0; i < modelCollection.size() ; i++) {
			Model model = (Model)modelCollection.get(i);
			
			context.put("info"		, model.getInfo() );
			context.put("rows"		, model.getRows() );
			context.put("cmrInfo"	, model.getCmrInfo() );
			context.put("util", util );
			context.put("u", util );	

			//ev[g̃p^[̐[v
			for (int j = 0; j < modelCollection.size() ; j++) {
				write( (HashMap)templates.get(j)  , context, model);
			}
			
		}
	}

	/**
	 * t@Cɏo
	 * 
	 * @param beanData - f[^NX̏
	 * @param writer - Velocityɂăev[gƃ}[WꂽC^[
	 * @throws IOException
	 */
	private void write( HashMap templateInfo , VelocityContext context ,Model model) throws ResourceNotFoundException, ParseErrorException, Exception {
		
		FileWriter fileWriter = null;
		StringWriter writer = new StringWriter();
		
		
		Template template = Velocity.getTemplate( _ginfo.getSettingValue("templateFolderName")  +"/"+ ((String)templateInfo.get("templateFileName")) , "Shift_JIS");
	
		template.merge(context, writer);
		
		//t@CۑtH_̃tH_𐶐
		String packageDirName = _ginfo.getSettingValue("destDirName") + "/" + ((String)templateInfo.get("distDir")) ;
		if( ((String)templateInfo.get("packageDir")).equals("true")  ){ 
			//pbP[W̃fBNgǉ			
			packageDirName = packageDirName + "/" +((String)model.getInfo().get( "pbP[W")).replace( '.' , '/' );
		}
		// pbP[W̃fBNg̐
		File file = new File(packageDirName);
		file.mkdirs();
				
		try {
			System.out.println("fileName[" + ((String)templateInfo.get("fileName")).replaceAll( "\\$1" , (String)model.getInfo().get( "name") )  +"]");
			fileWriter = new FileWriter( packageDirName + "/" + ((String)templateInfo.get("fileName")).replaceAll( "\\$1" , (String)model.getInfo().get( "name") ) );
			fileWriter.write(writer.toString());
		} finally {
			if (fileWriter != null) {
				fileWriter.close();
			}
		}
	}
	
	
}
