/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.util.StringUtil;

public class POILogger {
    public static final int DEBUG = 1;
    public static final int INFO = 3;
    public static final int WARN = 5;
    public static final int ERROR = 7;
    public static final int FATAL = 9;

    POILogger() {
    }

    public void log(int level, Object obj1) {
        if (this.check(level)) {
            System.out.println(obj1);
        }
    }

    private boolean isDebugEnabled() {
        return System.getProperty("poi.logging") != null;
    }

    private boolean isInfoEnabled() {
        return false;
    }

    private boolean isWarnEnabled() {
        return System.getProperty("poi.logging") != null;
    }

    private boolean isErrorEnabled() {
        return System.getProperty("poi.logging") != null;
    }

    private boolean isFatalEnabled() {
        return System.getProperty("poi.logging") != null;
    }

    public boolean check(int level) {
        return level == 9 ? this.isFatalEnabled() : (level == 7 ? this.isErrorEnabled() : (level == 5 ? this.isWarnEnabled() : (level == 3 ? this.isInfoEnabled() : level == 1 && this.isDebugEnabled())));
    }

    public void log(int level, Object obj1, Object obj2) {
        if (this.check(level)) {
            this.log(level, new StringBuffer(32).append(obj1).append(obj2));
        }
    }

    public void log(int level, Object obj1, Object obj2, Object obj3) {
        if (this.check(level)) {
            this.log(level, new StringBuffer(48).append(obj1).append(obj2).append(obj3));
        }
    }

    public void log(int level, Object obj1, Object obj2, Object obj3, Object obj4) {
        if (this.check(level)) {
            this.log(level, new StringBuffer(64).append(obj1).append(obj2).append(obj3).append(obj4));
        }
    }

    public void log(int level, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5) {
        if (this.check(level)) {
            this.log(level, new StringBuffer(80).append(obj1).append(obj2).append(obj3).append(obj4).append(obj5));
        }
    }

    public void log(int level, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5, Object obj6) {
        if (this.check(level)) {
            this.log(level, new StringBuffer(96).append(obj1).append(obj2).append(obj3).append(obj4).append(obj5).append(obj6));
        }
    }

    public void log(int level, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5, Object obj6, Object obj7) {
        if (this.check(level)) {
            this.log(level, new StringBuffer(112).append(obj1).append(obj2).append(obj3).append(obj4).append(obj5).append(obj6).append(obj7));
        }
    }

    public void log(int level, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5, Object obj6, Object obj7, Object obj8) {
        if (this.check(level)) {
            this.log(level, new StringBuffer(128).append(obj1).append(obj2).append(obj3).append(obj4).append(obj5).append(obj6).append(obj7).append(obj8));
        }
    }

    public void log(int level, Object obj1, Throwable exception) {
        this.log(level, obj1, exception);
    }

    public void log(int level, Object obj1, Object obj2, Throwable exception) {
        if (this.check(level)) {
            this.log(level, (Object)new StringBuffer(32).append(obj1).append(obj2), exception);
        }
    }

    public void log(int level, Object obj1, Object obj2, Object obj3, Throwable exception) {
        if (this.check(level)) {
            this.log(level, (Object)new StringBuffer(48).append(obj1).append(obj2).append(obj3), exception);
        }
    }

    public void log(int level, Object obj1, Object obj2, Object obj3, Object obj4, Throwable exception) {
        if (this.check(level)) {
            this.log(level, (Object)new StringBuffer(64).append(obj1).append(obj2).append(obj3).append(obj4), exception);
        }
    }

    public void log(int level, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5, Throwable exception) {
        if (this.check(level)) {
            this.log(level, (Object)new StringBuffer(80).append(obj1).append(obj2).append(obj3).append(obj4).append(obj5), exception);
        }
    }

    public void log(int level, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5, Object obj6, Throwable exception) {
        if (this.check(level)) {
            this.log(level, (Object)new StringBuffer(96).append(obj1).append(obj2).append(obj3).append(obj4).append(obj5).append(obj6), exception);
        }
    }

    public void log(int level, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5, Object obj6, Object obj7, Throwable exception) {
        if (this.check(level)) {
            this.log(level, (Object)new StringBuffer(112).append(obj1).append(obj2).append(obj3).append(obj4).append(obj5).append(obj6).append(obj7), exception);
        }
    }

    public void log(int level, Object obj1, Object obj2, Object obj3, Object obj4, Object obj5, Object obj6, Object obj7, Object obj8, Throwable exception) {
        if (this.check(level)) {
            this.log(level, (Object)new StringBuffer(128).append(obj1).append(obj2).append(obj3).append(obj4).append(obj5).append(obj6).append(obj7).append(obj8), exception);
        }
    }

    public void logFormatted(int level, String message, Object obj1) {
        this.commonLogFormatted(level, message, new Object[]{obj1});
    }

    public void logFormatted(int level, String message, Object obj1, Object obj2) {
        this.commonLogFormatted(level, message, new Object[]{obj1, obj2});
    }

    public void logFormatted(int level, String message, Object obj1, Object obj2, Object obj3) {
        this.commonLogFormatted(level, message, new Object[]{obj1, obj2, obj3});
    }

    public void logFormatted(int level, String message, Object obj1, Object obj2, Object obj3, Object obj4) {
        this.commonLogFormatted(level, message, new Object[]{obj1, obj2, obj3, obj4});
    }

    private void commonLogFormatted(int level, String message, Object[] unflatParams) {
        if (this.check(level)) {
            Object[] params = this.flattenArrays(unflatParams);
            if (params[params.length - 1] instanceof Throwable) {
                this.log(level, (Object)StringUtil.format(message, params), (Throwable)params[params.length - 1]);
            } else {
                this.log(level, StringUtil.format(message, params));
            }
        }
    }

    private Object[] flattenArrays(Object[] objects) {
        ArrayList results = new ArrayList();
        int i = 0;
        while (i < objects.length) {
            results.addAll(this.objectToObjectArray(objects[i]));
            ++i;
        }
        return results.toArray(new Object[results.size()]);
    }

    private List objectToObjectArray(Object object) {
        int j;
        Object[] array;
        ArrayList<Object> results = new ArrayList<Object>();
        if (object instanceof byte[]) {
            array = (byte[])object;
            j = 0;
            while (j < array.length) {
                results.add(new Byte(array[j]));
                ++j;
            }
        }
        if (object instanceof char[]) {
            array = (char[])object;
            j = 0;
            while (j < array.length) {
                results.add(new Character((char)array[j]));
                ++j;
            }
        } else if (object instanceof short[]) {
            array = (short[])object;
            j = 0;
            while (j < array.length) {
                results.add(new Short(array[j]));
                ++j;
            }
        } else if (object instanceof int[]) {
            array = (int[])object;
            j = 0;
            while (j < array.length) {
                results.add(new Integer(array[j]));
                ++j;
            }
        } else if (object instanceof long[]) {
            array = (long[])object;
            j = 0;
            while (j < array.length) {
                results.add(new Long(array[j]));
                ++j;
            }
        } else if (object instanceof float[]) {
            array = (float[])object;
            j = 0;
            while (j < array.length) {
                results.add(new Float(array[j]));
                ++j;
            }
        } else if (object instanceof double[]) {
            array = (double[])object;
            j = 0;
            while (j < array.length) {
                results.add(new Double(array[j]));
                ++j;
            }
        } else if (object instanceof Object[]) {
            array = (Object[])object;
            j = 0;
            while (j < array.length) {
                results.add(array[j]);
                ++j;
            }
        } else {
            results.add(object);
        }
        return results;
    }
}

