/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hdf.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.apache.poi.hdf.model.hdftypes.ChpxNode;
import org.apache.poi.hdf.model.hdftypes.DocumentProperties;
import org.apache.poi.hdf.model.hdftypes.FileInformationBlock;
import org.apache.poi.hdf.model.hdftypes.FontTable;
import org.apache.poi.hdf.model.hdftypes.ListTables;
import org.apache.poi.hdf.model.hdftypes.PapxNode;
import org.apache.poi.hdf.model.hdftypes.SepxNode;
import org.apache.poi.hdf.model.hdftypes.StyleSheet;
import org.apache.poi.hdf.model.hdftypes.TextPiece;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.LittleEndian;

public class HDFObjectFactory {
    private POIFSFileSystem _filesystem;
    private FileInformationBlock _fib;
    private DocumentProperties _dop;
    private StyleSheet _styleSheet;
    private ListTables _listTables;
    private FontTable _fonts;
    TreeSet _text = new TreeSet();
    TreeSet _sections = new TreeSet();
    TreeSet _paragraphs = new TreeSet();
    TreeSet _characterRuns = new TreeSet();
    byte[] _mainDocument;
    byte[] _tableBuffer;

    public HDFObjectFactory(InputStream istream) throws IOException {
        this._filesystem = new POIFSFileSystem(istream);
        DocumentEntry headerProps = (DocumentEntry)this._filesystem.getRoot().getEntry("WordDocument");
        this._mainDocument = new byte[headerProps.getSize()];
        this._filesystem.createDocumentInputStream("WordDocument").read(this._mainDocument);
        this._fib = new FileInformationBlock(this._mainDocument);
        this.initTableStream();
        this.initTextPieces();
        this.initFormattingProperties();
    }

    public static List getTypes(InputStream istream) throws IOException {
        ArrayList<FileInformationBlock> results = new ArrayList<FileInformationBlock>(1);
        POIFSFileSystem filesystem = new POIFSFileSystem(istream);
        DocumentEntry headerProps = (DocumentEntry)filesystem.getRoot().getEntry("WordDocument");
        byte[] mainDocument = new byte[headerProps.getSize()];
        filesystem.createDocumentInputStream("WordDocument").read(mainDocument);
        FileInformationBlock fib = new FileInformationBlock(mainDocument);
        results.add(fib);
        return results;
    }

    private void initTableStream() throws IOException {
        String tablename = null;
        tablename = !this._fib.isFWhichTblStm() ? "1Table" : "0Table";
        DocumentEntry tableEntry = (DocumentEntry)this._filesystem.getRoot().getEntry(tablename);
        int size = tableEntry.getSize();
        this._tableBuffer = new byte[size];
        this._filesystem.createDocumentInputStream(tablename).read(this._tableBuffer);
    }

    private void initTextPieces() throws IOException {
        int pos = this._fib.getFcClx();
        while (this._tableBuffer[pos] == 1) {
            short skip = LittleEndian.getShort((byte[])this._tableBuffer, (int)(++pos));
            pos += 2 + skip;
        }
        if (this._tableBuffer[pos] != 2) {
            throw new IOException("The text piece table is corrupted");
        }
        int pieceTableSize = LittleEndian.getInt((byte[])this._tableBuffer, (int)(++pos));
        pos += 4;
        int pieces = (pieceTableSize - 4) / 12;
        int x = 0;
        while (x < pieces) {
            int filePos = LittleEndian.getInt((byte[])this._tableBuffer, (int)(pos + (pieces + 1) * 4 + x * 8 + 2));
            boolean unicode = false;
            if ((filePos & 0x40000000) == 0) {
                unicode = true;
            } else {
                unicode = false;
                filePos &= 0xBFFFFFFF;
                filePos /= 2;
            }
            int totLength = LittleEndian.getInt((byte[])this._tableBuffer, (int)(pos + (x + 1) * 4)) - LittleEndian.getInt((byte[])this._tableBuffer, (int)(pos + x * 4));
            TextPiece piece = new TextPiece(filePos, totLength, unicode);
            this._text.add(piece);
            ++x;
        }
    }

    private void initFormattingProperties() {
        this.createStyleSheet();
        this.createListTables();
        this.createFontTable();
        this.initDocumentProperties();
        this.initSectionProperties();
        this.initCharacterProperties();
        this.initParagraphProperties();
    }

    private void initCharacterProperties() {
        int charOffset = this._fib.getFcPlcfbteChpx();
        int charPlcSize = this._fib.getLcbPlcfbteChpx();
        int arraySize = (charPlcSize - 4) / 8;
        int x = 0;
        while (x < arraySize) {
            int PN = LittleEndian.getInt((byte[])this._tableBuffer, (int)(charOffset + (4 * (arraySize + 1) + 4 * x)));
            byte[] fkp = new byte[512];
            System.arraycopy(this._mainDocument, PN * 512, fkp, 0, 512);
            int crun = LittleEndian.getUnsignedByte((byte[])fkp, (int)511);
            int y = 0;
            while (y < crun) {
                int fcStart = LittleEndian.getInt((byte[])fkp, (int)(y * 4));
                int fcEnd = LittleEndian.getInt((byte[])fkp, (int)((y + 1) * 4));
                int chpxOffset = 2 * LittleEndian.getUnsignedByte((byte[])fkp, (int)((crun + 1) * 4 + y));
                if (chpxOffset == 0) {
                    this._characterRuns.add(new ChpxNode(fcStart, fcEnd, new byte[0]));
                } else {
                    int size = LittleEndian.getUnsignedByte((byte[])fkp, (int)chpxOffset);
                    byte[] chpx = new byte[size];
                    System.arraycopy(fkp, ++chpxOffset, chpx, 0, size);
                    this._characterRuns.add(new ChpxNode(fcStart, fcEnd, chpx));
                }
                ++y;
            }
            ++x;
        }
    }

    private void initParagraphProperties() {
        int parOffset = this._fib.getFcPlcfbtePapx();
        int parPlcSize = this._fib.getLcbPlcfbtePapx();
        int arraySize = (parPlcSize - 4) / 8;
        int x = 0;
        while (x < arraySize) {
            int PN = LittleEndian.getInt((byte[])this._tableBuffer, (int)(parOffset + (4 * (arraySize + 1) + 4 * x)));
            byte[] fkp = new byte[512];
            System.arraycopy(this._mainDocument, PN * 512, fkp, 0, 512);
            int crun = LittleEndian.getUnsignedByte((byte[])fkp, (int)511);
            int y = 0;
            while (y < crun) {
                int fcStart = LittleEndian.getInt((byte[])fkp, (int)(y * 4));
                int fcEnd = LittleEndian.getInt((byte[])fkp, (int)((y + 1) * 4));
                int papxOffset = 2 * LittleEndian.getUnsignedByte((byte[])fkp, (int)((crun + 1) * 4 + y * 13));
                int size = 2 * LittleEndian.getUnsignedByte((byte[])fkp, (int)papxOffset);
                size = size == 0 ? 2 * LittleEndian.getUnsignedByte((byte[])fkp, (int)(++papxOffset)) : --size;
                byte[] papx = new byte[size];
                System.arraycopy(fkp, ++papxOffset, papx, 0, size);
                this._paragraphs.add(new PapxNode(fcStart, fcEnd, papx));
                ++y;
            }
            ++x;
        }
    }

    private void initSectionProperties() {
        int fcMin = this._fib.getFcMin();
        int plcfsedFC = this._fib.getFcPlcfsed();
        int plcfsedSize = this._fib.getLcbPlcfsed();
        byte[] plcfsed = new byte[plcfsedSize];
        System.arraycopy(this._tableBuffer, plcfsedFC, plcfsed, 0, plcfsedSize);
        int arraySize = (plcfsedSize - 4) / 16;
        int x = 0;
        while (x < arraySize) {
            int sectionStart = LittleEndian.getInt((byte[])plcfsed, (int)(x * 4)) + fcMin;
            int sectionEnd = LittleEndian.getInt((byte[])plcfsed, (int)((x + 1) * 4)) + fcMin;
            int sepxStart = LittleEndian.getInt((byte[])plcfsed, (int)(4 * (arraySize + 1) + x * 12 + 2));
            short sepxSize = LittleEndian.getShort((byte[])this._mainDocument, (int)sepxStart);
            byte[] sepx = new byte[sepxSize];
            System.arraycopy(this._mainDocument, sepxStart + 2, sepx, 0, sepxSize);
            SepxNode node = new SepxNode(x + 1, sectionStart, sectionEnd, sepx);
            this._sections.add(node);
            ++x;
        }
    }

    private void initDocumentProperties() {
        int pos = this._fib.getFcDop();
        int size = this._fib.getLcbDop();
        byte[] dopArray = new byte[size];
        System.arraycopy(this._tableBuffer, pos, dopArray, 0, size);
        this._dop = new DocumentProperties(dopArray);
    }

    private void createStyleSheet() {
        int stshIndex = this._fib.getFcStshf();
        int stshSize = this._fib.getLcbStshf();
        byte[] stsh = new byte[stshSize];
        System.arraycopy(this._tableBuffer, stshIndex, stsh, 0, stshSize);
        this._styleSheet = new StyleSheet(stsh);
    }

    private void createListTables() {
        int lstOffset;
        int lfoOffset = this._fib.getFcPlfLfo();
        int lfoSize = this._fib.getLcbPlfLfo();
        byte[] plflfo = new byte[lfoSize];
        System.arraycopy(this._tableBuffer, lfoOffset, plflfo, 0, lfoSize);
        int lstSize = lstOffset = this._fib.getFcPlcfLst();
        if (lstOffset > 0 && lstSize > 0) {
            lstSize = lfoOffset - lstOffset;
            byte[] plcflst = new byte[lstSize];
            System.arraycopy(this._tableBuffer, lstOffset, plcflst, 0, lstSize);
            this._listTables = new ListTables(plcflst, plflfo);
        }
    }

    private void createFontTable() {
        int fontTableIndex = this._fib.getFcSttbfffn();
        int fontTableSize = this._fib.getLcbSttbfffn();
        byte[] fontTable = new byte[fontTableSize];
        System.arraycopy(this._tableBuffer, fontTableIndex, fontTable, 0, fontTableSize);
        this._fonts = new FontTable(fontTable);
    }
}

