#!/bin/sh
# test platform ... debian dash

# GPL_3 license
cat << 'EEE' > /dev/null
/* readlink_p .... portable readlink. bourne-shell script
 * Copyright (C) 2018 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE




#iniとsfileでキーコードを再配置。
#  ./keyset_xa.sh -f unko -i ./redtest.ini
# >>> alias <AC06> = <KP9> ;

# keymv > keymvnew > keycp

#remap <LatH> :: <KP9>
#remap 80 :: 115
# <LatH> :: <KP9>  >> <AC01> = 92;
#左はコードorラベル。右はラベルのみだけど最終はコードに変換。
# <AD01> = 85;
#当面はラベルのみ。
#左のラベル名が存在するか否かをエラー判定とか。


buf=`./rdopt "hf:i:" "$@"`
if [ $? -ne 0 ] ; then echo "$0: optErr. see -h. sleep." >/dev/stderr ;sleep 1000; exit 1; fi
eval "$buf"

if [ "$opt_f" = "" ] || [ "$opt_i" = "" ] ; then
	echo "$0: optErr. see -h" > /dev/stderr
	exit 1
fi

sfile="$opt_f"
inifile="$opt_i"
tmpfile1="$0.buf1"
tmpfile2="$0.buf2"	#ラベルーキーコードリスト
tmpfile3="$0.buf3"		# ... 変更指示書


# keyset ... キーコードの入れ替え。keycodeブロックのみで完結するので。aliasは関係ない。
cat "$sfile" | ./getblock_xa.sh  '$1 == "xkb_keycodes"' |
	awk '$1 ~ /^[<]/ {print $0}' | tr '=;' ' ' |
	awk '{print $1 " " $2}' > "$tmpfile2"
printf '' > "$tmpfile3"		#inicialize

#---ready


#---main	loop読み込みでremapを全部処理。
echo "--- $0:" >/dev/stderr

cat "$inifile" | awk '$1 == "keymv" {print $0}' |
while read -r A
do

echo "--- $A" >/dev/stderr
set -- $A

#ラベル正式名探し
slbl="$2"
dlbl="$4"
slbl=`./cklabel_xa.sh -f "$sfile" -l "$slbl" `
if [ "$slbl" = "" ] ; then
	echo "$0: err. invalid label name. sleep" > /dev/stderr
	sleep 1000
	exit 1
fi

skc=`cat "$tmpfile2" | grep "$slbl" | awk '{print $2}'`
dkc=`echo "$dlbl" | tr '[:upper:]' '[:lower:]' | grep '^kc' | sed -e 's/kc//g'`
if [ "$dlbl" != "null" ] && [ "$dkc" = "" ]; then
	dlbl=`./cklabel_xa.sh -f "$sfile" -l "$dlbl" `
	dkc=`cat "$tmpfile2" | grep "$dlbl" | awk '{print $2}'`
fi

#無効化指定と普通の指定
buf=`echo $dlbl | tr '[:upper:]' '[:lower:]' `
if [ "$buf" = "null" ] && [ "$slbl" != "" ] ; then
# save slbl for del
	echo "del $skc" >> "$tmpfile3"
else
# get dst keycode
( echo "del $skc" ; echo "del $dkc" ; echo "add $slbl = $dkc"";" ) |
	awk 'NF > 1 {print $0}' >> "$tmpfile3"
# else
# 	echo "$0: err. invalid label name" > /dev/stderr
# 	exit 1
fi
done


# keycp

cat "$inifile" | tr '/' ' ' | awk '$1 == "keycp" {print $0}' |
while read -r A
do
echo "--- $A" >/dev/stderr
set -- $A
#ラベル正式名探し
dlbl="$4"
slbl="$2"
olbl="$5"	# オリジナルラベル

buf=`cat "$tmpfile2" | grep "$olbl" `
if [ "$buf" != "" ] ; then
	echo "$0: err. $slbl is already used. sleep" > /dev/stderr
	sleep 1000
	exit 1
fi

dkc=`echo "$dlbl" | tr '[:upper:]' '[:lower:]' | grep '^kc' | sed -e 's/kc//g'`
if [ "$dlbl" != "null" ] && [ "$dkc" = "" ]; then
	dlbl=`./cklabel_xa.sh -f "$sfile" -l "$dlbl" `
	dkc=`cat "$tmpfile2" | grep "$dlbl" | awk '{print $2}'`
fi

# get dst keycode
( echo "del $dkc" ; echo "add $olbl = $dkc"";" ) >> "$tmpfile3"
done
cat "$tmpfile3" >/dev/stderr


# remove tgt kc line
cat "$sfile" | awk '{print $0 " " NR}' |
		./getblock_xa.sh  '$1 == "xkb_keycodes"' |
		awk '$1 ~ /[<].*[>]/ {print $0}' | tr '=;' ' ' > "$tmpfile2"
delkc=`cat "$tmpfile3" | awk '$1 == "del" {print $2}' | sort | uniq`

set -- $delkc
delnum=""
# echo $@ > /dev/stderr
# sleep 10
# 元ソースの行番号付けとdel命令取り出し

for ii in "$@"
do
	delnum="$delnum "`cat "$tmpfile2" | awk '$2 == "'"$ii"'" {print $NF}'`
done
echo "del linenum $delnum" >/dev/stderr	#削除行









cat "$sfile" | ./n_abone_xa.sh "$delnum" > "$tmpfile1"

# sleep 10

# cat "$tmpfile1"
# exit
# add new label and kc
addblk=`cat "$tmpfile3" | awk '$1 == "add" {$1=""; print $0}' `
echo "$addblk" | ./addcode_xa.sh -f "$tmpfile1" -b xkb_keycodes > "$tmpfile3"
cp "$tmpfile3" "$tmpfile1"
# 一旦書き出し



# keycp <LFSH> :: <LALT>/<myat>	#ブロック側のコピー
# keycp. keymvnew add this automatically
newadd=`cat "$inifile" | tr '/' ' ' | awk '$1 == "keycp" {print "remap " $5 " :: " $2 }' `
# echo @@@@$newadd >/dev/stderr
#  sleep 10
# ( printf '%s\n' "$newadd" ; cat "$inifile" ) |
# 	awk '$1 == "keycp" {print "remap " $4 " :: " $2}' |
# 	sort | uniq > "$tmpfile3"
printf '%s\n' "$newadd" | sort | uniq > "$tmpfile3"

# cat "$tmpfile3" >/dev/stderr
# sleep 10
# remapは最低限キーコードとラベルがあればコピー可能

./remap_xa.sh -f "$tmpfile1" -i "$tmpfile3" > "$tmpfile2"


cp "$tmpfile2" "$tmpfile1"

cat "$tmpfile1"
echo "--- $0: end" >/dev/stderr
