#!/bin/sh
# test platform ... debian dash

# GPL_3 license
cat << 'EEE' > /dev/null
/* readlink_p .... portable readlink. bourne-shell script
 * Copyright (C) 2018 Momi-g
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
EEE

buf=`./rdopt "hf:i:" "$@"`
if [ $? -ne 0 ] ; then echo "$0: optErr. see -h. sleep." >/dev/stderr ;sleep 1000; exit 1; fi
eval "$buf"

if [ "$opt_f" = "" ] || [ "$opt_i" = "" ] ; then
	echo "$0: optErr. see -h" > /dev/stderr
	exit 1
fi

#	キーラベルを自分で大まかに使いやすく再設定する。
# ./deflbl_xa.sh -f unko -i redtest.ini

sfile="$opt_f"
inifile="$opt_i"

tmpfile1="$0.buf1"
tmpfile2="$0.buf2"
cp "$sfile" "$tmpfile1"

# ... 形式を整える。

# lbl=<mKey>
# kc=255
# mod=[any]
# sym=[Shift_L]
# repeat=off
# //---split	こんなん。

echo "--- $0:" >/dev/stderr
kcl=""

cat "$inifile" | sed -e 's/[=]/ = /g' | awk 'BEGIN{flg=0}
$1 == "keydef" {flg=1; print "lbl = " $2}
$1 == "kc" && flg >= 1 {flg=flg+1}
$1 == "kcl" && flg >= 1 {flg=flg+1}
$1 == "mod" && flg >= 1 {flg=flg+1}
$1 == "sym" && flg >= 1 {flg=flg+1}
$1 == "act" && flg >= 1 {flg=flg+1}
$1 == "repeat" && flg >= 1 {flg=flg+1}
flg >= 1 && $1 != "keydef"  {print $0}

$0 ~ /}/ && flg >= 1 && flg != 6 {system("echo define lbl err > /dev/stderr; sleep 1000"); exit 1}
$0 ~ /}/ && flg == 6 {print "// ---split"; flg=0}' |

 tr -d '} ' | awk '{print $1}' | grep -v '^$' | while read -r A
do
	buf=`echo "$A" | grep '^//' | grep 'split'`
	#スプリッタまではスタイルどおりに変数代入登録。evalで文字列を使える。
	if [ "$buf" = "" ] ; then
		A="$A"'"'
		buf=`echo "$A" | ./ssp -fs '*=' 132 '"' `
		eval $buf
#		echo "__ $buf"

# lbl=<mKey>
# kc=255
# mod=[any]
# sym=[Shift_L,NoSymbol]
# act=[NoAction(),SetMods(modifiers=Shift+Lock)]
# repeat=off
# //---split	こんなん。

	else	#スプリットにヒットした。#たくさんある追加ブロックの作成と登録
	echo "--- define $lbl" >/dev/stderr
	
	#kcl追加。ラベルからkcを作成取得する
	if [ "$kcl" != "" ] ; then
		buf=`./cklabel_xa.sh -f "$sfile" -l "$kcl" `
		kc=`cat "$sfile" | ./getblock_xa.sh '$1 == "xkb_keycodes"'  | 
			tr ';=' ' ' | awk -v lb=$buf '$1 == lb {print $2}' `
		# sleep 100
		if [ $kc -ne `expr $kc + 0` ] ; then
			echo "$0: kc_Err. $kc something wrong, sleep 1000" > /dev/stderr
			sleep 1000
			exit 1
		fi
		echo "... suc get kc from kcl, $kcl = $kc" >/dev/stderr #; sleep 100
		kcl=""	#後の為に初期化。
	fi
		
	# xkb_keycodes ...<mKey>=255;など。削除はいらない。上書き優先。
	# ...なんだけど、エラーが胡散臭いのでやっぱ消しとく。
#	echo $buf > /dev/stderr
#	cat "$tmpfile1" | sed -re "/$lbl"'.*=.*[0123456789]+[;]/c// ---abone' > "$tmpfile2"
	# sedはファイルの直接操作ができるんだった。
#	sed -re "/$lbl"'.*=.*[0123456789]+[;]/c// ---abone' "$tmpfile1"		>>>kcも検討有りでまとめた
#	cp "$tmpfile2" "$tmpfile1"

	# 重複定義を消す
	#     <LatM> = 244;	とかやると警告が出るだけで上書きされる。
	#	コードも削除したほうがいいんだけど、キーコードのうまい削除が思いつかない。
	#	キーコードの削除はめんどくさい？ラベルと数字の両方を確かめないとだめだから。
	#	生を出して尻尾に#行ナンバー付加、getblockしてからgrepして尻尾の番号を取得

	buf=`cat "$tmpfile1" | awk '{print $0 " " NR}' |
		./getblock_xa.sh  '$1 == "xkb_keycodes"' | 
		awk '$1 ~ /[<].*[>]/ {print $0}'`	#元行番号付きラベルデータ
	#echo "@@@_$buf" >/dev/stderr	;sleep 10
	#lbl$1かkc$3 を検討
	buf=`echo "$buf" | tr '=;' ' ' | awk -v lbl=$lbl -v kc=$kc '
		$1 == lbl || $2 == kc {print $NF} ' | tr -d '#' `	#kcかlblが同じ奴らの行番号
	set -- $buf
	#行番号から削除sedコマンドを作成。
	#echo "@@@_$buf" >/dev/stderr	;sleep 10
#	 echo "@@@_$comm" >/dev/stderr	;sleep 10
	cat "$tmpfile1" | ./n_abone_xa.sh "$@" > "$tmpfile2"
	cp "$tmpfile2" "$tmpfile1"
	#消したので追加
	buf="$lbl""=$kc"";"
	echo "$buf" | ./addcode_xa.sh -f "$tmpfile1" -b xkb_keycodes > "$tmpfile2"
	cp "$tmpfile2" "$tmpfile1"
	
	# modからtypeを判定作成。oneかそれ以外の自作か。
	buf=`echo "$mod" | grep base`	#baseがないとエラー
	if [ "$buf" = "" ] ;then
		echo "$0: modErr. [base] not found" > /dev/stderr
		exit 1
	fi
	buf=`echo "$mod" | grep any`	#anyはだめ。
	if [ "$buf" != "" ] ;then
		echo "$0: modErr. [+any] not support. +base,+s,+l,+c,+m1-5 only" > /dev/stderr
		exit 1
	fi
	
	buf=`echo "$mod" | grep base | tr '][,}{' ' ' | awk '{if(NF==1){print $1} }'`
	tp=""
	tpb=""
	if [ "$buf" != "" ] ;then	#baseのみ。
		tp="ONE_LEVEL"
	else	#base以外。typeの解析と自作。
		buf=`echo "$lbl" | tr -d '><'`
		buf="$buf""_define"
		tp="$buf"	#lblからtypeネーム命名
		
		#名前は生成した。typeブロックの作成。		
		buf=`echo "$mod" | tr '][,' ' ' `	#base +s ...羅列。
		#変換するけど、baseは無視される。ブロックには関係ないので放置。
		lvls=""
		for ii in $buf
		do
			lvls="$lvls "`echo "$ii" | ./reqmod_xa.sh `	
			#{+s+c}系から正式名のmodを行ワケして-+つきで出力。}{はなくても大丈夫。trってるだけ。
		done
#		set -- "base" $lvls		#base +Shift +Control+Lock ...など
#		echo "@@@@@@@ $lvls " >/dev/stderr
#sleep 10
		#typeでのmodifiers= Shift+ ...;	を作成。lvlsは重複があるので整理 空白追加。
		buf=`echo "$lvls" | tr ' +' '\n' | awk ' $1 != "" {print $1}' |
			sort | uniq | tr '\n' '+' | sed -e 's/[+]$//g'`
		tpb=`printf 'modifiers= %s;' "$buf"`
		
		#map[]などの中身を作る
#		echo "$tpb" >/dev/stderr
#sleep 10		
		pos=2	#base=1
		for ii in $lvls
		do
			ii=`echo "$ii" |  sed -e 's/^[+]//g' | sed -e 's/^[-]//g' `
			buf="map[$ii]= Level"$pos';'
			pos=`expr $pos + 1`
			tpb=`printf '%s\n%s\n' "$tpb" "$buf" `
		done

		#頭と尻尾をつける
		hd='type "'$tp'"'
	#	tpb=`printf '%s {\n%s\n};' "$hd" "$tpb"	`
		#自作typeブロック完成。		>> //	level_name[Level1]= "Base";
		# 最低一つはnameがないとぶっ壊れる。
		tpb=`printf '%s {\n%s\nlevel_name[Level1]= "Base";\n};' "$hd" "$tpb" `

		
#		echo "$tpb"	
#	@@@ぶろっくついかadd
#type "ONE_LEVEL_AB06add" 
	fi

	#tp,tpbが準備できた。キーブロックを作成する。
	#シンボルからリストを生成...sym変数はそのままなので直接keyblock生成でいい。

	kb="key $lbl {
	type= \"$tp\" ,
	symbols[Group1]= $sym ,
	actions[Group1]= $act
	};"
	
#	echo "$kb"
	#キーシンボルブロックに追加。存在するのは削除
	#仮想ラベルで再設定とかも、なんか二重っぽくなるけど動作上は問題ない。と思う。
	#結局後出しが強いので。 >> すり抜けがあるのでやっぱ削除
	
	echo "$kb" >/dev/stderr
	
	

	#ブッキングキーコードとラベルを削除したので新しいのを追加。
	echo "$lbl" | ./delkey_xa.sh -f "$tmpfile1" > "$tmpfile2"
	cp "$tmpfile2" "$tmpfile1"
	echo "$kb" | ./addcode_xa.sh -f "$tmpfile1" -b xkb_symbols > "$tmpfile2"
	cp "$tmpfile2" "$tmpfile1"

	#typeブロックがone以外ならxkb_typesに追加が必要
	if [ "$tpb" != "" ] ; then
		echo "$tpb" >/dev/stderr
		echo "$tpb" | ./addcode_xa.sh -f "$tmpfile1" -b xkb_types > "$tmpfile2"
		cp "$tmpfile2" "$tmpfile1"
	fi
	#以上で、ラベルとコードを登録して、コードからシンボルを登録して、必要ならtypeも追加。完了。


	#keyリピートは尻尾にコメント情報として追加しておく。
	if [ "$repeat" != "1" ] && [ "$repeat" != "0" ] ; then
		echo "$0: define keylabel err. repeat flag is 1 or 0" > /dev/stderr
		echo "_ $repeat _" > /dev/stderr
		exit 1
	fi
	
	if [ "$repeat" = "1" ] ; then
		rep="r"
	else
		rep="-r"
	fi

	printf '//keyrepeat xset %s %s	# define %s\n' "$rep" "$kc" "$lbl" >/dev/stderr
	printf '//keyrepeat xset %s %s	# define %s\n' "$rep" "$kc" "$lbl" >> "$tmpfile1"
fi
done

cat "$tmpfile1"
echo "--- $0: end" >/dev/stderr
