<?php
// $Id: avatar.php,v 1.1 2007/05/15 02:34:38 minahito Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

require_once XOOPS_ROOT_PATH.'/kernel/avatar.php';

//******************************************************************************

class CM_Avatar extends XoopsAvatar
{
	
	function CM_Avatar()
	{
		$this->XoopsAvatar();
	}
	
}

//******************************************************************************

class CM_AvatarHandler extends XoopsAvatarHandler
{
	//--------------------------------------------------------------------------
	
	function CM_AvatarHandler()
	{
		$this->db =& Database::getInstance();
	}
	
	//--------------------------------------------------------------------------
	
	function &getInstance()
	{
		static $instance = NULL;
		if(is_null($instance)){
			$instance = new CM_AvatarHandler();
		}
		return $instance;
	}
	
	//--------------------------------------------------------------------------
	
    function &getList($avatar_type = null, $avatar_display = null)
    {
        $criteria = new CriteriaCompo();
        if (isset($avatar_type)) {
            $avatar_type = ($avatar_type == 'C') ? 'C' : 'S';
            $criteria->add(new Criteria('avatar_type', $avatar_type));
        }
        if (isset($avatar_display)) {
            $criteria->add(new Criteria('avatar_display', intval($avatar_display)));
        }
        $avatars =& $this->getObjects($criteria, true);
        $ret = array();
        $ret[] = array(
        	'id' => 0,
        	'name' => _NONE,
        	'file' => 'blank.gif',
        );
        if(is_array($avatars)){
	        foreach ($avatars as $id => $obj) {
	            $ret[] = array(
	            	'id' => $id,
	            	'name' => $obj->getVar('avatar_name'),
	            	'file' => $obj->getVar('avatar_file'),
	            );
	        }
        }
        return $ret;
    }
	
	//--------------------------------------------------------------------------
}

//******************************************************************************

?>
