/**********************************************************************

  window.cpp -

  $Author: phasis68 $
  $Date: 2003/05/22 01:16:49 $
  created at: 2003-04-14 11:02

  Copyright (C) 2003  Park Heesob

**********************************************************************/


#include "wx.h"
#include "colour.h"
#include "font.h"
#include "size.h"
#include "rect.h"
#include "sizer.h"
#include "caret.h"
#include "window.h"
#include "point.h"
#include "layout.h"
#include "region.h"
#include "validator.h"
#include "cursor.h"
#include "tooltip.h"

VALUE
WxClassInfo::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}


VALUE
WxClassInfo::init0(wxClassInfo *classinfo)
{
    extern VALUE rb_cWxClassInfo;
    if(classinfo==NULL) return Qnil;
    VALUE self = Data_Wrap_Struct(rb_cWxClassInfo, 0, 0, 0);
    DATA_PTR(self) = classinfo;
    return self;
}

VALUE
WxClassInfo::GetClassName(VALUE self)
{
    wxClassInfo *ptr;
    Data_Get_Struct(self, wxClassInfo, ptr);
    return rb_str_new2(ptr->GetClassName());
}

//-------------------------------------------------------------------
VALUE
WxWindow::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxWindow::init(int argc, VALUE *argv, VALUE self)
{
    wxWindow* parent = NULL;
    if(argv[0]!=Qnil)
        Data_Get_Struct(argv[0], wxWindow, parent);
    wxWindowID id = NUM2INT(argv[1]);
    wxPoint pos = wxDefaultPosition;
    if(argc>2) {
        wxPoint *ptr;
        Data_Get_Struct(argv[2], wxPoint, ptr);
        pos = *ptr;
    }
    wxSize size = wxDefaultSize;
    if(argc>3) {
        wxSize *ptr;
        Data_Get_Struct(argv[3], wxSize, ptr);
        size = *ptr;
    }
    long style = 0;
    if(argc>4) style = NUM2INT(argv[4]);
    wxString name = wxPanelNameStr;
    if(argc>5) name = StringValuePtr(argv[5]);

    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr = new wxWindow(parent,id,pos,size,style,name);

    VALUE vdata = rb_hash_new();
    rb_hash_aset(vdata,rb_str_new2("self"),self);
    ptr->SetClientData((void*)vdata);

    DATA_PTR(self) = ptr;
    return self;
}

VALUE
WxWindow::init0(wxWindow *window)
{
    extern VALUE rb_cWxWindow;
    if(window==NULL) return Qnil;
    VALUE self = Data_Wrap_Struct(rb_cWxWindow, 0, 0, 0);
    DATA_PTR(self) = window;
    return self;
}

void
WxWindow::free(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    delete ptr;
}

VALUE
WxWindow::Destroy(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return (ptr->Destroy() ? Qtrue : Qfalse);
}

void
WxWindow::Close(VALUE self, VALUE vforce)
{
    bool force = (vforce == Qtrue);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->Close(force);
}

VALUE
WxWindow::GetBackgroundColour(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return WxColour::init0(ptr->GetBackgroundColour());
}

VALUE
WxWindow::GetForegroundColour(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return WxColour::init0(ptr->GetForegroundColour());
}

VALUE
WxWindow::GetFont(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return WxFont::init0(ptr->GetFont());
}

VALUE
WxWindow::Layout(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return (ptr->Layout() ? Qtrue : Qfalse);
}

void
WxWindow::SetBackgroundColour(VALUE self,VALUE vcolour)
{
    wxColour *colour;
    Data_Get_Struct(vcolour, wxColour, colour);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->SetBackgroundColour(*colour);
}

void
WxWindow::SetForegroundColour(VALUE self,VALUE vcolour)
{
    wxColour *colour;
    Data_Get_Struct(vcolour, wxColour, colour);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->SetForegroundColour(*colour);
}

void
WxWindow::SetFont(VALUE self,VALUE vfont)
{
    wxFont *font;
    Data_Get_Struct(vfont, wxFont, font);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->SetFont(*font);
}

void
WxWindow::SetAutoLayout(VALUE self,VALUE vautoLayout)
{
    bool autoLayout = (vautoLayout == Qtrue);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->SetAutoLayout(autoLayout);
}

void
WxWindow::SetConstraints(VALUE self,VALUE vconstraints)
{
    wxLayoutConstraints *constraints;
    Data_Get_Struct(vconstraints, wxLayoutConstraints, constraints);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->SetConstraints(constraints);
}

void
WxWindow::SetSizer(int argc, VALUE *argv, VALUE self)
{
    wxSizer *sizer;
    bool deleteOld = TRUE;
    Data_Get_Struct(argv[0], wxSizer, sizer);
    if(argc>1 && argv[1]==Qfalse) deleteOld = FALSE;
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->SetSizer(sizer,deleteOld);
}

void
WxWindow::SetSizerAndFit(int argc, VALUE *argv, VALUE self)
{
    wxSizer *sizer;
    bool deleteOld = TRUE;
    Data_Get_Struct(argv[0], wxSizer, sizer);
    if(argc>1 && argv[1]==Qfalse) deleteOld = FALSE;
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->SetSizerAndFit(sizer,deleteOld);
}

VALUE
WxWindow::GetSizer(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return WxSizer::init0(ptr->GetSizer());
}

void
WxWindow::SetContainingSizer(VALUE self,VALUE vsizer)
{
    wxSizer *sizer;
    Data_Get_Struct(vsizer, wxSizer, sizer);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->SetContainingSizer(sizer);
}

VALUE
WxWindow::GetContainingSizer(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return WxSizer::init0(ptr->GetContainingSizer());
}

VALUE
WxWindow::GetLabel(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return rb_str_new2(ptr->GetLabel());
}

void
WxWindow::Show(int argc, VALUE *argv, VALUE self)
{
    bool show = TRUE;
    if(argc>0 && argv[0]==Qfalse) show = FALSE;
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->Show(show);
}

void
WxWindow::SetTitle(VALUE self,VALUE vtitle)
{
    wxString title = wxString(StringValuePtr(vtitle));
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->SetTitle(title);
}

void
WxWindow::SetValidator(VALUE self,VALUE vvalidator)
{
    wxValidator *validator;
    Data_Get_Struct(vvalidator, wxValidator, validator);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->SetValidator(*validator);
}

VALUE
WxWindow::TransferDataFromWindow(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return (ptr->TransferDataFromWindow() ? Qtrue : Qfalse);
}

VALUE
WxWindow::TransferDataToWindow(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return (ptr->TransferDataToWindow() ? Qtrue : Qfalse);
}

void
WxWindow::SetFocus(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->SetFocus();
}

void
WxWindow::SetSize(int argc, VALUE *argv, VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    if(argc==1 && strstr(rb_class2name(CLASS_OF(argv[0])),"Rect")) {
        wxRect *rect;
        Data_Get_Struct(argv[0], wxRect, rect);
        ptr->SetSize(*rect);
    } else if(argc==1) {
        wxSize *size;
        Data_Get_Struct(argv[0], wxSize, size);
        ptr->SetSize(*size);
    } else if(argc==2) {
        int width = NUM2INT(argv[0]);
        int height = NUM2INT(argv[1]);
        ptr->SetSize(width,height);
    } else {
        int x = NUM2INT(argv[0]);
        int y = NUM2INT(argv[1]);
        int width = NUM2INT(argv[2]);
        int height = NUM2INT(argv[3]);
        int sizeFlags = wxSIZE_AUTO;
        if(argc>4) sizeFlags = NUM2INT(argv[4]);
        ptr->SetSize(x,y,width,height);
    }
}

VALUE
WxWindow::GetWindowStyle(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return INT2NUM(ptr->GetWindowStyle());
}

VALUE
WxWindow::GetWindowStyleFlag(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return INT2NUM(ptr->GetWindowStyleFlag());
}

void
WxWindow::SetWindowStyleFlag(VALUE self,VALUE vstyle)
{
    long style = NUM2INT(vstyle);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->SetWindowStyleFlag(style);
}

void
WxWindow::SetCaret(VALUE self,VALUE vcaret)
{
    wxCaret *caret;
    Data_Get_Struct(vcaret, wxCaret, caret);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->SetCaret(caret);
}

VALUE
WxWindow::GetParent(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return WxWindow::init0(ptr->GetParent());
}

VALUE
WxWindow::GetCaret(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return WxCaret::init0(ptr->GetCaret());
}

void
WxWindow::Move(int argc, VALUE *argv, VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    if(TYPE(argv[0])==T_DATA) {
        wxPoint *pt;
        Data_Get_Struct(argv[0], wxPoint, pt);
        int flags = wxSIZE_USE_EXISTING;
        if(argc>1) flags = NUM2INT(argv[1]);
        ptr->Move(*pt,flags);
    } else {
        int x = NUM2INT(argv[0]);
        int y = NUM2INT(argv[1]);
        int flags = wxSIZE_USE_EXISTING;
        if(argc>2) flags = NUM2INT(argv[2]);
        ptr->Move(x,y,flags);
    }
}


void
WxWindow::AddChild(VALUE self,VALUE vchild)
{
    wxWindow *child;
    Data_Get_Struct(vchild, wxWindow, child);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->AddChild(child);
}

void
WxWindow::CaptureMouse(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->CaptureMouse();
}

void
WxWindow::Centre(int argc, VALUE *argv, VALUE self)
{
    int direction = wxBOTH;
    if(argc>0) direction = NUM2INT(argv[0]);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->Centre(direction);
}

void
WxWindow::CentreOnParent(int argc, VALUE *argv, VALUE self)
{
    int direction = wxBOTH;
    if(argc>0) direction = NUM2INT(argv[0]);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->CentreOnParent(direction);
}

void
WxWindow::CentreOnScreen(int argc, VALUE *argv, VALUE self)
{
    int direction = wxBOTH;
    if(argc>0) direction = NUM2INT(argv[0]);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->CentreOnScreen(direction);
}

void
WxWindow::Clear(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->Clear();
}

VALUE
WxWindow::ClientToScreen(int argc, VALUE *argv, VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    if(argc==1 && TYPE(argv[0])==T_DATA) {
        wxPoint *pt;
        Data_Get_Struct(argv[0], wxPoint, pt);
        return WxPoint::init0(ptr->ClientToScreen(*pt));
    } else {
        int x = NUM2INT(argv[0]);
        int y = NUM2INT(argv[1]);
        ptr->ClientToScreen(&x,&y);
        return rb_ary_new3(2,INT2NUM(x),INT2NUM(y));
    }
}

VALUE
WxWindow::ConvertDialogToPixels(VALUE self,VALUE argv)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    if(strstr(rb_class2name(CLASS_OF(argv)),"Point")) {
        wxPoint *pt;
        Data_Get_Struct(argv, wxPoint, pt);
        return WxPoint::init0(ptr->ConvertDialogToPixels(*pt));
    } else {
        wxSize *pt;
        Data_Get_Struct(argv, wxSize, pt);
        return WxSize::init0(ptr->ConvertDialogToPixels(*pt));
    }
}

VALUE
WxWindow::ConvertPixelsToDialog(VALUE self,VALUE argv)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    if(strstr(rb_class2name(CLASS_OF(argv)),"Point")) {
        wxPoint *pt;
        Data_Get_Struct(argv, wxPoint, pt);
        return WxPoint::init0(ptr->ConvertPixelsToDialog(*pt));
    } else {
        wxSize *pt;
        Data_Get_Struct(argv, wxSize, pt);
        return WxSize::init0(ptr->ConvertPixelsToDialog(*pt));
    }
}

void
WxWindow::DestroyChildren(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->DestroyChildren();
}

void
WxWindow::Disable(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->Disable();
}

#ifdef __WXMSW__
void
WxWindow::DragAcceptFiles(VALUE self,VALUE vaccept)
{
    bool accept = (vaccept == Qtrue);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->DragAcceptFiles(accept);
}
#endif

VALUE
WxWindow::Enable(int argc, VALUE *argv, VALUE self)
{
    bool enable = TRUE;
    if(argc>0 && argv[0]==Qfalse) enable = FALSE;
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return (ptr->Enable(enable) ? Qtrue : Qfalse);
}

VALUE
WxWindow::FindFocus(VALUE self)
{
    return WxWindow::init0(wxWindow::FindFocus());
}

VALUE
WxWindow::FindWindow(VALUE self,VALUE argv)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    if(TYPE(argv)==T_FIXNUM) {
        long id = NUM2INT(argv);
        return WxWindow::init0(ptr->FindWindow(id));
    } else {
        wxString name = StringValuePtr(argv);
        return WxWindow::init0(ptr->FindWindow(name));
    }
}

VALUE
WxWindow::FindWindowById(int argc, VALUE *argv, VALUE self)
{
    long id = NUM2INT(argv[0]);
    wxWindow* parent = NULL;
    if(argc>1 && argv[1]!=Qnil) {
        wxWindow *parent;
        Data_Get_Struct(argv[1], wxWindow, parent);
    }
    return WxWindow::init0(wxWindow::FindWindowById(id,parent));
}

VALUE
WxWindow::FindWindowByName(int argc, VALUE *argv, VALUE self)
{
    wxString name = StringValuePtr(argv[0]);
    wxWindow* parent = NULL;
    if(argc>1 && argv[1]!=Qnil) {
        wxWindow *parent;
        Data_Get_Struct(argv[1], wxWindow, parent);
    }
    return WxWindow::init0(wxWindow::FindWindowByName(name,parent));
}

VALUE
WxWindow::FindWindowByLabel(int argc, VALUE *argv, VALUE self)
{
    wxString label = StringValuePtr(argv[0]);
    wxWindow* parent = NULL;
    if(argc>1 && argv[1]!=Qnil) {
        wxWindow *parent;
        Data_Get_Struct(argv[1], wxWindow, parent);
    }
    return WxWindow::init0(wxWindow::FindWindowByLabel(label,parent));
}

void
WxWindow::Fit(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->Fit();
}

void
WxWindow::FitInside(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->FitInside();
}

void
WxWindow::Freeze(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->Freeze();
}

VALUE
WxWindow::GetAdjustedBestSize(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return WxSize::init0(ptr->GetAdjustedBestSize());
}

VALUE
WxWindow::GetBestSize(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return WxSize::init0(ptr->GetBestSize());
}

VALUE
WxWindow::GetCapture(VALUE self)
{
    return WxWindow::init0(wxWindow::GetCapture());
}

VALUE
WxWindow::GetCharHeight(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return INT2NUM(ptr->GetCharHeight());
}

VALUE
WxWindow::GetCharWidth(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return INT2NUM(ptr->GetCharWidth());
}


//wxList& GetChildren()

VALUE
WxWindow::GetClientSizeWH(VALUE self)
{
    int width;
    int height;
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->GetClientSize(&width,&height);
    return rb_ary_new3(2,INT2NUM(width),INT2NUM(height));
}

VALUE
WxWindow::GetClientSize(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return WxSize::init0(ptr->GetClientSize());
}

VALUE
WxWindow::GetConstraints(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return WxLayoutConstraints::init0(ptr->GetConstraints());
}


//wxDropTarget* GetDropTarget() const

//wxEvtHandler* GetEventHandler() const

VALUE
WxWindow::GetExtraStyle(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return INT2NUM(ptr->GetExtraStyle());
}

VALUE
WxWindow::GetGrandParent(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return WxWindow::init0(ptr->GetGrandParent());
}

VALUE
WxWindow::GetHandle(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return INT2NUM((long)ptr->GetHandle());
}

VALUE
WxWindow::GetHelpText(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return rb_str_new2(ptr->GetHelpText());
}

VALUE
WxWindow::GetId(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return INT2NUM(ptr->GetId());
}


VALUE
WxWindow::GetName(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return rb_str_new2(ptr->GetName());
}

VALUE
WxWindow::GetPositionXY(VALUE self)
{
    int x;
    int y;
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->GetPosition(&x,&y);
    return rb_ary_new3(2,INT2NUM(x),INT2NUM(y));
}

VALUE
WxWindow::GetPosition(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return WxPoint::init0(ptr->GetPosition());

}

VALUE
WxWindow::GetRect(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return WxRect::init0(ptr->GetRect());

}

VALUE
WxWindow::GetScrollThumb(VALUE self,VALUE vorientation)
{
    int orientation = NUM2INT(vorientation);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return INT2NUM(ptr->GetScrollThumb(orientation));

}

VALUE
WxWindow::GetScrollPos(VALUE self,VALUE vorientation)
{
    int orientation = NUM2INT(vorientation);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return INT2NUM(ptr->GetScrollPos(orientation));

}

VALUE
WxWindow::GetScrollRange(VALUE self,VALUE vorientation)
{
    int orientation = NUM2INT(vorientation);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return INT2NUM(ptr->GetScrollRange(orientation));

}

VALUE
WxWindow::GetSizeWH(VALUE self)
{
    int x;
    int y;
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->GetSize(&x,&y);
    return rb_ary_new3(2,INT2NUM(x),INT2NUM(y));
}

VALUE
WxWindow::GetSize(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return WxSize::init0(ptr->GetSize());

}


VALUE
WxWindow::GetTextExtent(int argc, VALUE *argv, VALUE self)
{
    wxString string = StringValuePtr(argv[0]);
    int x;
    int y;
    int descent;
    int externalLeading;
    const wxFont* font = NULL;
    if(argc>1 && TYPE(argv[1])==T_DATA) {
        Data_Get_Struct(argv[1], wxFont, font);
    }

    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    if(font==NULL) {
        ptr->GetTextExtent(string,&x,&y);
        return rb_ary_new3(2,INT2NUM(x),INT2NUM(y));
    } else {
        ptr->GetTextExtent(string,&x,&y,&descent,&externalLeading,font);
        return rb_ary_new3(4,INT2NUM(x),INT2NUM(y),INT2NUM(descent),INT2NUM(externalLeading));
    }
}

VALUE
WxWindow::GetTitle(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return rb_str_new2(ptr->GetTitle());
}

VALUE
WxWindow::GetUpdateRegion(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return WxRegion::init0(ptr->GetUpdateRegion());

}

VALUE
WxWindow::GetValidator(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return WxValidator::init0(ptr->GetValidator());

}

VALUE
WxWindow::GetVirtualSize(VALUE self)
{
    int x;
    int y;
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->GetVirtualSize(&x,&y);
    return rb_ary_new3(2,INT2NUM(x),INT2NUM(y));
}

VALUE
WxWindow::HasCapture(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return (ptr->HasCapture() ? Qtrue : Qfalse);
}

VALUE
WxWindow::Hide(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return (ptr->Hide() ? Qtrue : Qfalse);
}

void
WxWindow::InitDialog(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->InitDialog();
}

VALUE
WxWindow::IsEnabled(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return (ptr->IsEnabled() ? Qtrue : Qfalse);
}

VALUE
WxWindow::IsExposed(int argc, VALUE *argv, VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    if(argc==1 && strstr(rb_class2name(CLASS_OF(argv[0])),"Point")) {
        wxPoint *pt;
        Data_Get_Struct(argv[0], wxPoint, pt);
        return (ptr->IsExposed(*pt) ? Qtrue : Qfalse);
    } else if(argc==1) {
        wxRect *pt;
        Data_Get_Struct(argv[0], wxRect, pt);
        return (ptr->IsExposed(*pt) ? Qtrue : Qfalse);
    } else if(argc==2) {
        int x = NUM2INT(argv[0]);
        int y = NUM2INT(argv[1]);
        return (ptr->IsExposed(x,y) ? Qtrue : Qfalse);
    } else {
        int x = NUM2INT(argv[0]);
        int y = NUM2INT(argv[1]);
        int w = NUM2INT(argv[2]);
        int h = NUM2INT(argv[3]);
        return (ptr->IsExposed(x,y,w,h) ? Qtrue : Qfalse);
    }
}

VALUE
WxWindow::IsRetained(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return (ptr->IsRetained() ? Qtrue : Qfalse);
}

VALUE
WxWindow::IsShown(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return (ptr->IsShown() ? Qtrue : Qfalse);
}

VALUE
WxWindow::IsTopLevel(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return (ptr->IsTopLevel() ? Qtrue : Qfalse);
}


//virtual bool LoadFromResource(wxWindow* parent, const wxString& resourceName, const wxResourceTable* resourceTable = NULL)

void
WxWindow::Lower(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->Lower();
}

void
WxWindow::MakeModal(VALUE self,VALUE vflag)
{
    bool flag = (vflag == Qtrue);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->MakeModal(flag);
}

//wxEvtHandler* PopEventHandler(bool deleteHandler = FALSE) const

VALUE
WxWindow::PopupMenu(int argc, VALUE *argv, VALUE self)
{
    wxMenu *menu;
    Data_Get_Struct(argv[0], wxMenu, menu);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    if(argc==2) {
        wxPoint *pos;
        Data_Get_Struct(argv[1], wxPoint, pos);
        return (ptr->PopupMenu(menu,*pos) ? Qtrue : Qfalse);
    } else {
        int x = NUM2INT(argv[1]);
        int y = NUM2INT(argv[2]);
        return (ptr->PopupMenu(menu,x,y) ? Qtrue : Qfalse);
    }
}


//void PushEventHandler(wxEvtHandler* handler)

void
WxWindow::Raise(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->Raise();
}

void
WxWindow::Refresh(int argc, VALUE *argv, VALUE self)
{
    bool eraseBackground = TRUE;
    if(argc>0 && argv[0]==Qfalse) eraseBackground = FALSE;
    wxRect* rect = NULL;
    if(argc>1) {
        Data_Get_Struct(argv[1], wxRect, rect);
    }
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->Refresh(eraseBackground,rect);
}

void
WxWindow::RefreshRect(VALUE self,VALUE vrect)
{
    wxRect* rect;
    Data_Get_Struct(vrect, wxRect, rect);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->RefreshRect(*rect);
}

void
WxWindow::ReleaseMouse(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->ReleaseMouse();
}

void
WxWindow::RemoveChild(VALUE self,VALUE vchild)
{
    wxWindow* child;
    Data_Get_Struct(vchild, wxWindow, child);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->RemoveChild(child);
}

//bool RemoveEventHandler(wxEvtHandler *handler)

VALUE
WxWindow::Reparent(VALUE self,VALUE vnewParent)
{
    wxWindow* newParent;
    Data_Get_Struct(vnewParent, wxWindow, newParent);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return (ptr->Reparent(newParent) ? Qtrue : Qfalse);
}

VALUE
WxWindow::ScreenToClient(int argc, VALUE *argv, VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    if(argc==1 && TYPE(argv[0])==T_DATA) {
        wxPoint *pt;
        Data_Get_Struct(argv[0], wxPoint, pt);
        return WxPoint::init0(ptr->ScreenToClient(*pt));
    } else {
        int x = NUM2INT(argv[0]);
        int y = NUM2INT(argv[1]);
        ptr->ScreenToClient(&x,&y);
        return rb_ary_new3(2,INT2NUM(x),INT2NUM(y));
    }
}

VALUE
WxWindow::ScrollLines(VALUE self,VALUE vlines)
{
    int lines = NUM2INT(vlines);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return (ptr->ScrollLines(lines) ? Qtrue : Qfalse);
}

VALUE
WxWindow::ScrollPages(VALUE self,VALUE vpages)
{
    int pages = NUM2INT(vpages);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return (ptr->ScrollPages(pages) ? Qtrue : Qfalse);
}

void
WxWindow::ScrollWindow(int argc, VALUE *argv, VALUE self)
{
    int dx = NUM2INT(argv[0]);
    int dy = NUM2INT(argv[1]);
    wxRect* rect = NULL;
    if(argc>2) {
        Data_Get_Struct(argv[2], wxRect, rect);
    }
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->ScrollWindow(dx,dy,rect);
}

//virtual void SetAcceleratorTable(const wxAcceleratorTable& accel)


void
WxWindow::SetClientSize(int argc, VALUE *argv, VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    if(argc==1) {
        wxSize* size;
        Data_Get_Struct(argv[0], wxSize, size);
        ptr->SetClientSize(*size);
    } else {
        int width = NUM2INT(argv[0]);
        int height = NUM2INT(argv[1]);
        ptr->SetClientSize(width,height);
    }
}

void
WxWindow::SetCursor(VALUE self,VALUE vcursor)
{
    wxCursor *cursor;
    Data_Get_Struct(vcursor, wxCursor, cursor);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->SetCursor(*cursor);
}

//void SetDropTarget(wxDropTarget* target)

//void SetEventHandler(wxEvtHandler* handler)

void
WxWindow::SetExtraStyle(VALUE self,VALUE vexStyle)
{
    long exStyle = NUM2INT(vexStyle);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->SetExtraStyle(exStyle);
}

void
WxWindow::SetFocusFromKbd(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->SetFocusFromKbd();
}

void
WxWindow::SetHelpText(VALUE self,VALUE vhelpText)
{
    wxString helpText = StringValuePtr(vhelpText);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->SetHelpText(helpText);
}

void
WxWindow::SetId(VALUE self,VALUE vid)
{
    long id = NUM2INT(vid);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->SetId(id);
}

void
WxWindow::SetName(VALUE self,VALUE vname)
{
    wxString name = StringValuePtr(vname);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->SetName(name);
}

void
WxWindow::SetPalette(VALUE self,VALUE vpalette)
{
    wxPalette *palette;
    Data_Get_Struct(vpalette, wxPalette, palette);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->SetPalette(*palette);
}

void
WxWindow::SetScrollbar(int argc, VALUE *argv, VALUE self)
{
    int orientation = NUM2INT(argv[0]);
    int position = NUM2INT(argv[1]);
    int thumbSize = NUM2INT(argv[2]);
    int range = NUM2INT(argv[3]);
    bool refresh = TRUE;
    if(argc>4 && argv[4]==Qfalse) refresh = FALSE;
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->SetScrollbar(orientation,position,thumbSize,range,refresh);
}

void
WxWindow::SetScrollPos(int argc, VALUE *argv, VALUE self)
{
    int orientation = NUM2INT(argv[0]);
    int position = NUM2INT(argv[1]);
    bool refresh = TRUE;
    if(argc>2 && argv[2]==Qfalse) refresh = FALSE;
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->SetScrollPos(orientation,position,refresh);
}

void
WxWindow::SetSizeHints(int argc, VALUE *argv, VALUE self)
{
    int minW=-1;
    if(argc>0) minW = NUM2INT(argv[0]);
    int minH=-1;
    if(argc>1) minH = NUM2INT(argv[1]);
    int maxW=-1;
    if(argc>2) maxW = NUM2INT(argv[2]);
    int maxH=-1;
    if(argc>3) maxH = NUM2INT(argv[3]);
    int incW=-1;
    if(argc>4) incW = NUM2INT(argv[4]);
    int incH=-1;
    if(argc>5) incH = NUM2INT(argv[5]);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->SetSizeHints(minW, minH, maxW, maxH, incW, incH);
}

void
WxWindow::SetThemeEnabled(VALUE self,VALUE venable)
{
    bool enable = (venable == Qtrue);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->SetThemeEnabled(enable);
}

//void SetToolTip(const wxString& tip)

//void SetToolTip(wxToolTip* tip)

//wxToolTip* GetToolTip() const

void
WxWindow::SetVirtualSize(int argc, VALUE *argv, VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    if(argc==1) {
        wxSize* size;
        Data_Get_Struct(argv[0], wxSize, size);
        ptr->SetVirtualSize(*size);
    } else {
        int width = NUM2INT(argv[0]);
        int height = NUM2INT(argv[1]);
        ptr->SetVirtualSize(width,height);
    }
}

void
WxWindow::SetVirtualSizeHints(int argc, VALUE *argv, VALUE self)
{
    int minW=-1;
    if(argc>0) minW = NUM2INT(argv[0]);
    int minH=-1;
    if(argc>1) minH = NUM2INT(argv[1]);
    int maxW=-1;
    if(argc>2) maxW = NUM2INT(argv[2]);
    int maxH=-1;
    if(argc>3) maxH = NUM2INT(argv[3]);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->SetVirtualSizeHints(minW, minH, maxW, maxH);
}

void
WxWindow::SetWindowStyle(VALUE self,VALUE vstyle)
{
    long style = NUM2INT(vstyle);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->SetWindowStyle(style);
}

void
WxWindow::Thaw(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->Thaw();
}

void
WxWindow::Update(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->Update();
}

void
WxWindow::WarpPointer(VALUE self,VALUE vx,VALUE vy)
{
    int x = NUM2INT(vx);
    int y = NUM2INT(vy);
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    ptr->WarpPointer(x,y);
}

void
WxWindow::SetToolTip(VALUE self,VALUE vtip)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    if(TYPE(vtip)==T_STRING) {
        wxString tip = StringValuePtr(vtip);
        ptr->SetToolTip(tip);
    } else {
        wxToolTip* tip;
        Data_Get_Struct(vtip, wxToolTip, tip);
        ptr->SetToolTip(tip);
    }
}

VALUE
WxWindow::GetToolTip(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return WxToolTip::init0(ptr->GetToolTip());
}

VALUE
WxWindow::GetClassInfo(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return WxClassInfo::init0(ptr->GetClassInfo());
}

#ifdef __WXMSW__
VALUE
WxWindow::GetHWND(VALUE self)
{
    wxWindow *ptr;
    Data_Get_Struct(self, wxWindow, ptr);
    return INT2NUM(ptr->GetHWND());
}
#endif

//-------------------------------------------------------------------
VALUE
WxSplitterWindow::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxSplitterWindow::init(int argc, VALUE *argv, VALUE self)
{
    wxWindow* parent = NULL;
    if(argv[0]!=Qnil)
        Data_Get_Struct(argv[0], wxWindow, parent);
    wxWindowID id = NUM2INT(argv[1]);
    wxPoint pos = wxDefaultPosition;
    if(argc>2) {
        wxPoint *ptr;
        Data_Get_Struct(argv[2], wxPoint, ptr);
        pos = *ptr;
    }
    wxSize size = wxDefaultSize;
    if(argc>3) {
        wxSize *ptr;
        Data_Get_Struct(argv[3], wxSize, ptr);
        size = *ptr;
    }
    long style=wxSP_3D;
    if(argc>4) style = NUM2INT(argv[4]);
    wxString name = "splitterWindow";
    if(argc>5) name = StringValuePtr(argv[5]);

    wxSplitterWindow *ptr;
    Data_Get_Struct(self, wxSplitterWindow, ptr);
    ptr = new wxSplitterWindow(parent,id,pos,size,style,name);

    VALUE vdata = rb_hash_new();
    rb_hash_aset(vdata,rb_str_new2("self"),self);
    ptr->SetClientData((void*)vdata);

    DATA_PTR(self) = ptr;
    return self;
}

VALUE
WxSplitterWindow::GetMinimumPaneSize(VALUE self)
{
    wxSplitterWindow *ptr;
    Data_Get_Struct(self, wxSplitterWindow, ptr);
    return INT2NUM(ptr->GetMinimumPaneSize());
}

VALUE
WxSplitterWindow::GetSashPosition(VALUE self)
{
    wxSplitterWindow *ptr;
    Data_Get_Struct(self, wxSplitterWindow, ptr);
    return INT2NUM(ptr->GetSashPosition());
}

VALUE
WxSplitterWindow::GetSplitMode(VALUE self)
{
    wxSplitterWindow *ptr;
    Data_Get_Struct(self, wxSplitterWindow, ptr);
    return INT2NUM(ptr->GetSplitMode());
}

VALUE
WxSplitterWindow::GetWindow1(VALUE self)
{
    wxSplitterWindow *ptr;
    Data_Get_Struct(self, wxSplitterWindow, ptr);
    return WxWindow::init0(ptr->GetWindow1());
}

VALUE
WxSplitterWindow::GetWindow2(VALUE self)
{
    wxSplitterWindow *ptr;
    Data_Get_Struct(self, wxSplitterWindow, ptr);
    return WxWindow::init0(ptr->GetWindow2());
}

void
WxSplitterWindow::Initialize(VALUE self,VALUE vwindow)
{
    wxWindow* window;
    Data_Get_Struct(vwindow, wxWindow, window);
    wxSplitterWindow *ptr;
    Data_Get_Struct(self, wxSplitterWindow, ptr);
    ptr->Initialize(window);
}

VALUE
WxSplitterWindow::IsSplit(VALUE self)
{
    wxSplitterWindow *ptr;
    Data_Get_Struct(self, wxSplitterWindow, ptr);
    return (ptr->IsSplit() ? Qtrue : Qfalse);
}

VALUE
WxSplitterWindow::ReplaceWindow(VALUE self,VALUE vwinOld,VALUE vwinNew)
{
    wxWindow* winOld;
    Data_Get_Struct(vwinOld, wxWindow, winOld);
    wxWindow* winNew;
    Data_Get_Struct(vwinNew, wxWindow, winNew);
    wxSplitterWindow *ptr;
    Data_Get_Struct(self, wxSplitterWindow, ptr);
    return (ptr->ReplaceWindow(winOld,winNew) ? Qtrue : Qfalse);
}

void
WxSplitterWindow::SetSashPosition(int argc, VALUE *argv, VALUE self)
{
    int position = NUM2INT(argv[0]);
    bool redraw = TRUE;
    if(argc>1 && argv[1]==Qfalse) redraw = FALSE;
    wxSplitterWindow *ptr;
    Data_Get_Struct(self, wxSplitterWindow, ptr);
    ptr->SetSashPosition(position,redraw);
}

void
WxSplitterWindow::SetMinimumPaneSize(VALUE self,VALUE vpaneSize)
{
    int paneSize = NUM2INT(vpaneSize);
    wxSplitterWindow *ptr;
    Data_Get_Struct(self, wxSplitterWindow, ptr);
    ptr->SetMinimumPaneSize(paneSize);
}

void
WxSplitterWindow::SetSplitMode(VALUE self,VALUE vmode)
{
    int mode = NUM2INT(vmode);
    wxSplitterWindow *ptr;
    Data_Get_Struct(self, wxSplitterWindow, ptr);
    ptr->SetSplitMode(mode);
}

VALUE
WxSplitterWindow::SplitHorizontally(int argc, VALUE *argv, VALUE self)
{
    wxWindow* window1;
    Data_Get_Struct(argv[0], wxWindow, window1);
    wxWindow* window2;
    Data_Get_Struct(argv[1], wxWindow, window2);
    int sashPosition = 0;
    if(argc>2) sashPosition = NUM2INT(argv[2]);
    wxSplitterWindow *ptr;
    Data_Get_Struct(self, wxSplitterWindow, ptr);
    return (ptr->SplitHorizontally(window1,window2,sashPosition) ? Qtrue : Qfalse);
}

VALUE
WxSplitterWindow::SplitVertically(int argc, VALUE *argv, VALUE self)
{
    wxWindow* window1;
    Data_Get_Struct(argv[0], wxWindow, window1);
    wxWindow* window2;
    Data_Get_Struct(argv[1], wxWindow, window2);
    int sashPosition = 0;
    if(argc>2) sashPosition = NUM2INT(argv[2]);
    wxSplitterWindow *ptr;
    Data_Get_Struct(self, wxSplitterWindow, ptr);
    return (ptr->SplitVertically(window1,window2,sashPosition) ? Qtrue : Qfalse);
}

VALUE
WxSplitterWindow::Unsplit(int argc, VALUE *argv, VALUE self)
{
    wxWindow* toRemove = NULL;
    if(argc>0)
        Data_Get_Struct(argv[0], wxWindow, toRemove);
    wxSplitterWindow *ptr;
    Data_Get_Struct(self, wxSplitterWindow, ptr);
    return (ptr->Unsplit(toRemove) ? Qtrue : Qfalse);
}

