/**********************************************************************

  timer.cpp -

  $Author: phasis68 $
  $Date: 2003/05/22 01:16:49 $
  created at: 2003-04-14 11:02

  Copyright (C) 2003  Park Heesob

**********************************************************************/


#include "wx.h"
#include "timer.h"

VALUE
WxTimer::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxTimer::init(int argc, VALUE *argv, VALUE self)
{
    wxEvtHandler *owner;
    int id = -1;

    if(argc>0 && TYPE(argv[0])==T_DATA) {
	Data_Get_Struct(argv[0], wxEvtHandler, owner);
    }
    if(argc>1 && TYPE(argv[1])==T_FIXNUM)
      id = NUM2INT(argv[1]);

    wxTimer *ptr;
    Data_Get_Struct(self, wxTimer, ptr);
    ptr = new wxTimer(owner,id);
    DATA_PTR(self) = ptr;

    return self;
}

VALUE
WxTimer::Start(int argc, VALUE *argv, VALUE self)
{
    int milliseconds = -1;
    bool oneShot = FALSE;
    if(argc>0 && TYPE(argv[0])==T_FIXNUM)
      milliseconds = NUM2INT(argv[0]);
    if(argc>0 && argv[1]==Qtrue)
      oneShot = TRUE;
    wxTimer *ptr;
    Data_Get_Struct(self, wxTimer, ptr);
    return (ptr->Start(milliseconds,oneShot) ? Qtrue : Qfalse);
}

void
WxTimer::Stop(VALUE self)
{
    wxTimer *ptr;
    Data_Get_Struct(self, wxTimer, ptr);
    ptr->Stop();
}

//--------------------------------------------------------------------------------
VALUE
WxStopWatch::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxStopWatch::init(VALUE self)
{
    wxStopWatch *ptr;
    Data_Get_Struct(self, wxStopWatch, ptr);
    ptr = new wxStopWatch();
    DATA_PTR(self) = ptr;

    return self;
}

void
WxStopWatch::Start(int argc, VALUE *argv, VALUE self)
{
    int milliseconds = 0;
    if(argc>0 && TYPE(argv[0])==T_FIXNUM)
      milliseconds = NUM2INT(argv[0]);
    wxStopWatch *ptr;
    Data_Get_Struct(self, wxStopWatch, ptr);
    ptr->Start(milliseconds);
}

void
WxStopWatch::free(VALUE self)
{
    wxStopWatch *ptr;
    Data_Get_Struct(self, wxStopWatch, ptr);
    delete ptr;
}

void
WxStopWatch::Pause(VALUE self)
{
    wxStopWatch *ptr;
    Data_Get_Struct(self, wxStopWatch, ptr);
    ptr->Pause();
}

void
WxStopWatch::Resume(VALUE self)
{
    wxStopWatch *ptr;
    Data_Get_Struct(self, wxStopWatch, ptr);
    ptr->Resume();
}

VALUE
WxStopWatch::Time(VALUE self)
{
    wxStopWatch *ptr;
    Data_Get_Struct(self, wxStopWatch, ptr);
    return INT2NUM(ptr->Time());
}


