/**********************************************************************

  textctrl.cpp -

  $Author: phasis68 $
  $Date: 2003/05/22 01:16:49 $
  created at: 2003-04-14 11:02

  Copyright (C) 2003  Park Heesob

**********************************************************************/


#include "wx.h"
#include "textctrl.h"

VALUE
WxTextCtrl::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxTextCtrl::init(int argc, VALUE *argv, VALUE self)
{
    wxWindow* parent;
    wxWindowID id;
    wxString value = "";
    wxPoint pos = wxDefaultPosition;
    wxSize size = wxDefaultSize;
    long style = 0;
//    wxValidator validator = wxDefaultValidator;
//    name = wxTextCtrlNameStr;

    if(argc>0 && TYPE(argv[0])==T_DATA) {
	Data_Get_Struct(argv[0], wxWindow, parent);
    }
    if(argc>1 && TYPE(argv[1])==T_FIXNUM)
      id = NUM2INT(argv[1]);
    if(argc>2 && TYPE(argv[2])==T_STRING)
      value = wxString(StringValuePtr(argv[2]));
    if(argc>3 && TYPE(argv[3])==T_DATA) {
        wxPoint *ptr;
	Data_Get_Struct(argv[3], wxPoint, ptr);
	pos = *ptr;
    }
    if(argc>4 && TYPE(argv[4])==T_DATA) {
        wxSize *ptr;
	Data_Get_Struct(argv[4], wxSize, ptr);
	size = *ptr;
    }
    if(argc>5 && TYPE(argv[5])==T_FIXNUM)
      style = NUM2INT(argv[5]);

    wxTextCtrl *ptr;
    Data_Get_Struct(self, wxTextCtrl, ptr);
    ptr = new wxTextCtrl(parent,id,value,pos,size,style);

    VALUE vdata = rb_hash_new();
    rb_hash_aset(vdata,rb_str_new2("self"),self);
    ptr->SetClientData((void*)vdata);

    DATA_PTR(self) = ptr;

    return self;
}

VALUE
WxTextCtrl::LoadFile(VALUE self,VALUE vfilename)
{
    wxString filename = wxString(StringValuePtr(vfilename));
    wxTextCtrl *ptr;
    Data_Get_Struct(self, wxTextCtrl, ptr);
    return INT2NUM(ptr->LoadFile(filename));
}

VALUE
WxTextCtrl::SaveFile(VALUE self,VALUE vfilename)
{
    wxString filename = wxString(StringValuePtr(vfilename));
    wxTextCtrl *ptr;
    Data_Get_Struct(self, wxTextCtrl, ptr);
    return INT2NUM(ptr->SaveFile(filename));
}

VALUE
WxTextCtrl::IsModified(VALUE self)
{
    wxTextCtrl *ptr;
    Data_Get_Struct(self, wxTextCtrl, ptr);
    return (ptr->IsModified() ? Qtrue : Qfalse);
}

void
WxTextCtrl::DiscardEdits(VALUE self)
{
    wxTextCtrl *ptr;
    Data_Get_Struct(self, wxTextCtrl, ptr);
    ptr->DiscardEdits();
}

VALUE
WxTextCtrl::GetNumberOfLines(VALUE self)
{
    wxTextCtrl *ptr;
    Data_Get_Struct(self, wxTextCtrl, ptr);
    return INT2NUM(ptr->GetNumberOfLines());
}

VALUE
WxTextCtrl::op_append(VALUE self,VALUE value)
{
    wxTextCtrl *ptr;
    Data_Get_Struct(self, wxTextCtrl, ptr);
    if(TYPE(value)==T_STRING)
      *ptr << StringValuePtr(value);
    else if(TYPE(value)==T_FIXNUM)
      *ptr << NUM2INT(value);
    else if(TYPE(value)==T_FLOAT)
      *ptr << (double)(RFLOAT(value)->value);
    return self;
}

VALUE
WxTextCtrl::XYToPosition(VALUE self,VALUE vx,VALUE vy)
{
    long x = NUM2INT(vx);
    long y = NUM2INT(vy);
    wxTextCtrl *ptr;
    Data_Get_Struct(self, wxTextCtrl, ptr);
    return INT2NUM(ptr->XYToPosition(x,y));
}

void
WxTextCtrl::SetInsertionPoint(VALUE self,VALUE vpos)
{
    long pos = NUM2INT(vpos);
    wxTextCtrl *ptr;
    Data_Get_Struct(self, wxTextCtrl, ptr);
    ptr->SetInsertionPoint(pos);
}

VALUE
WxTextCtrl::GetValue(VALUE self)
{
    wxTextCtrl *ptr;
    Data_Get_Struct(self, wxTextCtrl, ptr);
    return rb_str_new2(ptr->GetValue());
}

void
WxTextCtrl::SetValue(VALUE self,VALUE vvalue)
{
    wxString value = StringValuePtr(vvalue);
    wxTextCtrl *ptr;
    Data_Get_Struct(self, wxTextCtrl, ptr);
    ptr->SetValue(value);
}

void
WxTextCtrl::AppendText(VALUE self,VALUE vtext)
{
    wxString text = StringValuePtr(vtext);
    wxTextCtrl *ptr;
    Data_Get_Struct(self, wxTextCtrl, ptr);
    ptr->AppendText(text);
}

void
WxTextCtrl::WriteText(VALUE self,VALUE vtext)
{
    wxString text = StringValuePtr(vtext);
    wxTextCtrl *ptr;
    Data_Get_Struct(self, wxTextCtrl, ptr);
    ptr->WriteText(text);
}

VALUE
WxTextCtrl::CanCopy(VALUE self)
{
    wxTextCtrl *ptr;
    Data_Get_Struct(self, wxTextCtrl, ptr);
    return (ptr->CanCopy() ? Qtrue : Qfalse);
}

VALUE
WxTextCtrl::CanCut(VALUE self)
{
    wxTextCtrl *ptr;
    Data_Get_Struct(self, wxTextCtrl, ptr);
    return (ptr->CanCut() ? Qtrue : Qfalse);
}

VALUE
WxTextCtrl::CanPaste(VALUE self)
{
    wxTextCtrl *ptr;
    Data_Get_Struct(self, wxTextCtrl, ptr);
    return (ptr->CanPaste() ? Qtrue : Qfalse);
}

VALUE
WxTextCtrl::CanRedo(VALUE self)
{
    wxTextCtrl *ptr;
    Data_Get_Struct(self, wxTextCtrl, ptr);
    return (ptr->CanRedo() ? Qtrue : Qfalse);
}

VALUE
WxTextCtrl::CanUndo(VALUE self)
{
    wxTextCtrl *ptr;
    Data_Get_Struct(self, wxTextCtrl, ptr);
    return (ptr->CanUndo() ? Qtrue : Qfalse);
}

void
WxTextCtrl::Clear(VALUE self)
{
    wxTextCtrl *ptr;
    Data_Get_Struct(self, wxTextCtrl, ptr);
    ptr->Clear();
}

void
WxTextCtrl::Copy(VALUE self)
{
    wxTextCtrl *ptr;
    Data_Get_Struct(self, wxTextCtrl, ptr);
    ptr->Copy();
}

void
WxTextCtrl::Cut(VALUE self)
{
    wxTextCtrl *ptr;
    Data_Get_Struct(self, wxTextCtrl, ptr);
    ptr->Cut();
}


VALUE
WxTextCtrl::init0(wxTextCtrl *textCtrl)
{
    extern VALUE rb_cWxTextCtrl;
    VALUE self = Data_Wrap_Struct(rb_cWxTextCtrl, 0, 0, 0);
    DATA_PTR(self) = textCtrl;
    return self;
}

