/**********************************************************************

  sizer.cpp -

  $Author: phasis68 $
  $Date: 2003/05/22 01:16:48 $
  created at: 2003-04-14 11:02

  Copyright (C) 2003  Park Heesob

**********************************************************************/


#include "wx.h"
#include "size.h"
#include "sizer.h"
#include "notebook.h"

VALUE
WxSizer::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxSizer::init(VALUE self)
{
    return self;
}

VALUE
WxSizer::init0(wxSizer *sizer)
{
    extern VALUE rb_cWxSizer;
    VALUE self = Data_Wrap_Struct(rb_cWxSizer, 0, 0, 0);
    DATA_PTR(self) = sizer;
    return self;
}

void
WxSizer::Add(int argc, VALUE *argv, VALUE self)
{
    wxWindow *window;
    wxSizer *sizer;
    int width;
    int height;
    int option = 0;
    int flag = 0;
    int border = 0;
    wxObject* userData = NULL;

    wxSizer *ptr;
    Data_Get_Struct(self, wxSizer, ptr);
    if(TYPE(argv[0])==T_DATA) {
      if(argc>1 && TYPE(argv[1])==T_FIXNUM)
        option = NUM2INT(argv[1]);
      if(argc>2 && TYPE(argv[2])==T_FIXNUM)
        flag = NUM2INT(argv[2]);
      if(argc>3 && TYPE(argv[3])==T_FIXNUM)
        border = NUM2INT(argv[3]);

      if(strstr(rb_class2name(CLASS_OF(argv[0])),"Sizer")) {
        Data_Get_Struct(argv[0], wxSizer, sizer);
        ptr->Add(sizer,option,flag,border,userData);
      } else {
        Data_Get_Struct(argv[0], wxWindow, window);
        ptr->Add(window,option,flag,border,userData);
      }
    } else {
      if(argc>0 && TYPE(argv[0])==T_FIXNUM)
        width = NUM2INT(argv[0]);
      if(argc>1 && TYPE(argv[1])==T_FIXNUM)
        height = NUM2INT(argv[1]);
      if(argc>2 && TYPE(argv[2])==T_FIXNUM)
        option = NUM2INT(argv[2]);
      if(argc>3 && TYPE(argv[3])==T_FIXNUM)
        flag = NUM2INT(argv[3]);
      if(argc>4 && TYPE(argv[4])==T_FIXNUM)
        border = NUM2INT(argv[4]);

      ptr->Add(width,height,option,flag,border,userData);
    }
}

VALUE
WxSizer::Fit(VALUE self,VALUE vwindow)
{
    wxWindow* window;
    Data_Get_Struct(vwindow, wxWindow, window);
    wxSizer *ptr;
    Data_Get_Struct(self, wxSizer, ptr);
    return WxSize::init0(ptr->Fit(window));
}

void
WxSizer::FitInside(VALUE self,VALUE vwindow)
{
    wxWindow* window;
    Data_Get_Struct(vwindow, wxWindow, window);
    wxSizer *ptr;
    Data_Get_Struct(self, wxSizer, ptr);
    ptr->FitInside(window);
}

void
WxSizer::SetSizeHints(VALUE self,VALUE vwindow)
{
    wxWindow* window;
    Data_Get_Struct(vwindow, wxWindow, window);
    wxSizer *ptr;
    Data_Get_Struct(self, wxSizer, ptr);
    ptr->SetSizeHints(window);
}

void
WxSizer::SetVirtualSizeHints(VALUE self,VALUE vwindow)
{
    wxWindow* window;
    Data_Get_Struct(vwindow, wxWindow, window);
    wxSizer *ptr;
    Data_Get_Struct(self, wxSizer, ptr);
    ptr->SetVirtualSizeHints(window);
}

void
WxSizer::Remove(VALUE self,VALUE argv)
{
    wxSizer *ptr;
    Data_Get_Struct(self, wxSizer, ptr);
    if(TYPE(argv)==T_FIXNUM) {
        int nth = NUM2INT(argv);
        ptr->Remove(nth);
    }
    else if(strstr(rb_class2name(CLASS_OF(argv)),"Sizer")) {
        wxSizer* sizer;
        Data_Get_Struct(argv, wxSizer, sizer);
        ptr->Remove(sizer);
    } else {
        wxWindow* window;
        Data_Get_Struct(argv, wxWindow, window);
        ptr->Remove(window);
    }
}

void
WxSizer::Insert(int argc, VALUE *argv, VALUE self)
{
    int before = NUM2INT(argv[0]);
    wxWindow *window;
    wxSizer *sizer;
    int width;
    int height;
    int option = 0;
    int flag = 0;
    int border = 0;
    wxObject* userData = NULL;

    wxSizer *ptr;
    Data_Get_Struct(self, wxSizer, ptr);
    if(TYPE(argv[1])==T_DATA) {
      if(argc>2 && TYPE(argv[2])==T_FIXNUM)
        option = NUM2INT(argv[2]);
      if(argc>3 && TYPE(argv[3])==T_FIXNUM)
        flag = NUM2INT(argv[3]);
      if(argc>4 && TYPE(argv[4])==T_FIXNUM)
        border = NUM2INT(argv[4]);

      if(strstr(rb_class2name(CLASS_OF(argv[1])),"Sizer")) {
        Data_Get_Struct(argv[1], wxSizer, sizer);
        ptr->Insert(before,sizer,option,flag,border,userData);
      } else {
        Data_Get_Struct(argv[1], wxWindow, window);
        ptr->Insert(before,window,option,flag,border,userData);
      }
    } else {
      if(argc>1 && TYPE(argv[1])==T_FIXNUM)
        width = NUM2INT(argv[1]);
      if(argc>2 && TYPE(argv[2])==T_FIXNUM)
        height = NUM2INT(argv[2]);
      if(argc>3 && TYPE(argv[3])==T_FIXNUM)
        option = NUM2INT(argv[3]);
      if(argc>4 && TYPE(argv[4])==T_FIXNUM)
        flag = NUM2INT(argv[4]);
      if(argc>5 && TYPE(argv[5])==T_FIXNUM)
        border = NUM2INT(argv[5]);

      ptr->Insert(before,width,height,option,flag,border,userData);
    }
}

void
WxSizer::Show(int argc, VALUE *argv, VALUE self)
{
    wxWindow *window;
    wxSizer *sizer;
    bool show = TRUE;
    if(argc>1 && argv[1]==Qfalse) show = FALSE;

    wxSizer *ptr;
    Data_Get_Struct(self, wxSizer, ptr);

    if(strstr(rb_class2name(CLASS_OF(argv[0])),"Sizer")) {
        Data_Get_Struct(argv[0], wxSizer, sizer);
        ptr->Show(sizer,show);
    } else {
        Data_Get_Struct(argv[0], wxWindow, window);
        ptr->Show(window,show);
    }
}

void
WxSizer::Layout(VALUE self)
{
    wxSizer *ptr;
    Data_Get_Struct(self, wxSizer, ptr);
    ptr->Layout();
}

//--------------------------------------------------------------------------------
VALUE
WxGridSizer::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxGridSizer::init(int argc, VALUE *argv, VALUE self)
{
    int rows;
    int cols;
    int vgap = 0;
    int hgap = 0;
    wxGridSizer *ptr;
    Data_Get_Struct(self, wxGridSizer, ptr);
    if(argc==4) {
      rows = NUM2INT(argv[0]);
      cols = NUM2INT(argv[1]);
      vgap = NUM2INT(argv[2]);
      hgap = NUM2INT(argv[3]);
      ptr = new wxGridSizer(rows,cols,vgap,hgap);
    } else {
      cols = NUM2INT(argv[0]);
      if(argc>1) vgap = NUM2INT(argv[1]);
      if(argc>2) hgap = NUM2INT(argv[2]);
      ptr = new wxGridSizer(cols,vgap,hgap);
    }
    DATA_PTR(self) = ptr;

    return self;
}

void
WxGridSizer::RecalcSizes(VALUE self)
{
    wxGridSizer *ptr;
    Data_Get_Struct(self, wxGridSizer, ptr);
    ptr->RecalcSizes();
}

VALUE
WxGridSizer::CalcMin(VALUE self)
{
    wxGridSizer *ptr;
    Data_Get_Struct(self, wxGridSizer, ptr);
    return WxSize::init0(ptr->CalcMin());
}

void
WxGridSizer::SetCols(VALUE self,VALUE vcols)
{
    int cols = NUM2INT(vcols);

    wxGridSizer *ptr;
    Data_Get_Struct(self, wxGridSizer, ptr);
    ptr->SetCols(cols);
}
void
WxGridSizer::SetRows(VALUE self,VALUE vrows)
{
    int rows = NUM2INT(vrows);

    wxGridSizer *ptr;
    Data_Get_Struct(self, wxGridSizer, ptr);
    ptr->SetRows(rows);
}
void
WxGridSizer::SetVGap(VALUE self,VALUE vgap)
{
    int gap = NUM2INT(vgap);

    wxGridSizer *ptr;
    Data_Get_Struct(self, wxGridSizer, ptr);
    ptr->SetVGap(gap);
}
void
WxGridSizer::SetHGap(VALUE self,VALUE vgap)
{
    int gap = NUM2INT(vgap);

    wxGridSizer *ptr;
    Data_Get_Struct(self, wxGridSizer, ptr);
    ptr->SetHGap(gap);
}

VALUE
WxGridSizer::GetCols(VALUE self)
{
    wxGridSizer *ptr;
    Data_Get_Struct(self, wxGridSizer, ptr);
    return NUM2INT(ptr->GetCols());
}

VALUE
WxGridSizer::GetRows(VALUE self)
{
    wxGridSizer *ptr;
    Data_Get_Struct(self, wxGridSizer, ptr);
    return NUM2INT(ptr->GetRows());
}
VALUE
WxGridSizer::GetVGap(VALUE self)
{
    wxGridSizer *ptr;
    Data_Get_Struct(self, wxGridSizer, ptr);
    return NUM2INT(ptr->GetVGap());
}
VALUE
WxGridSizer::GetHGap(VALUE self)
{
    wxGridSizer *ptr;
    Data_Get_Struct(self, wxGridSizer, ptr);
    return NUM2INT(ptr->GetHGap());
}

//--------------------------------------------------------------------------------
VALUE
WxFlexGridSizer::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxFlexGridSizer::init(int argc, VALUE *argv, VALUE self)
{
    int rows;
    int cols;
    int vgap = 0;
    int hgap = 0;
    wxFlexGridSizer *ptr;
    Data_Get_Struct(self, wxFlexGridSizer, ptr);
    if(argc==4) {
      rows = NUM2INT(argv[0]);
      cols = NUM2INT(argv[1]);
      vgap = NUM2INT(argv[2]);
      hgap = NUM2INT(argv[3]);
      ptr = new wxFlexGridSizer(rows,cols,vgap,hgap);
    } else {
      cols = NUM2INT(argv[0]);
      if(argc>1) vgap = NUM2INT(argv[1]);
      if(argc>2) hgap = NUM2INT(argv[2]);
      ptr = new wxFlexGridSizer(cols,vgap,hgap);
    }
    DATA_PTR(self) = ptr;

    return self;
}

void
WxFlexGridSizer::RecalcSizes(VALUE self)
{
    wxFlexGridSizer *ptr;
    Data_Get_Struct(self, wxFlexGridSizer, ptr);
    ptr->RecalcSizes();
}

VALUE
WxFlexGridSizer::CalcMin(VALUE self)
{
    wxFlexGridSizer *ptr;
    Data_Get_Struct(self, wxFlexGridSizer, ptr);
    return WxSize::init0(ptr->CalcMin());
}

void
WxFlexGridSizer::AddGrowableRow(VALUE self,VALUE vidx)
{
    size_t idx = (size_t)NUM2INT(vidx);
    wxFlexGridSizer *ptr;
    Data_Get_Struct(self, wxFlexGridSizer, ptr);
    ptr->AddGrowableRow(idx);
}

void
WxFlexGridSizer::RemoveGrowableRow(VALUE self,VALUE vidx)
{
    size_t idx = (size_t)NUM2INT(vidx);
    wxFlexGridSizer *ptr;
    Data_Get_Struct(self, wxFlexGridSizer, ptr);
    ptr->RemoveGrowableRow(idx);
}

void
WxFlexGridSizer::AddGrowableCol(VALUE self,VALUE vidx)
{
    size_t idx = (size_t)NUM2INT(vidx);
    wxFlexGridSizer *ptr;
    Data_Get_Struct(self, wxFlexGridSizer, ptr);
    ptr->AddGrowableCol(idx);
}

void
WxFlexGridSizer::RemoveGrowableCol(VALUE self,VALUE vidx)
{
    size_t idx = (size_t)NUM2INT(vidx);
    wxFlexGridSizer *ptr;
    Data_Get_Struct(self, wxFlexGridSizer, ptr);
    ptr->RemoveGrowableCol(idx);
}

//--------------------------------------------------------------------------------
VALUE
WxBoxSizer::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxBoxSizer::init(VALUE self,VALUE vorient)
{
    int orient = NUM2INT(vorient);

    wxBoxSizer *ptr;
    Data_Get_Struct(self, wxBoxSizer, ptr);
    ptr = new wxBoxSizer(orient);
    DATA_PTR(self) = ptr;

    return self;
}

void
WxBoxSizer::RecalcSizes(VALUE self)
{
    wxBoxSizer *ptr;
    Data_Get_Struct(self, wxBoxSizer, ptr);
    ptr->RecalcSizes();
}


void
WxBoxSizer::SetOrientation(VALUE self,VALUE vorient)
{
    int orient = NUM2INT(vorient);

    wxBoxSizer *ptr;
    Data_Get_Struct(self, wxBoxSizer, ptr);
    ptr->SetOrientation(orient);
}

VALUE
WxBoxSizer::GetOrientation(VALUE self)
{
    wxBoxSizer *ptr;
    Data_Get_Struct(self, wxBoxSizer, ptr);
    return NUM2INT(ptr->GetOrientation());
}

VALUE
WxBoxSizer::CalcMin(VALUE self)
{
    wxBoxSizer *ptr;
    Data_Get_Struct(self, wxBoxSizer, ptr);
    return WxSize::init0(ptr->CalcMin());
}

//--------------------------------------------------------------------------------
VALUE
WxStaticBoxSizer::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxStaticBoxSizer::init(VALUE self,VALUE vbox,VALUE vorient)
{
    wxStaticBox* box;
    Data_Get_Struct(vbox, wxStaticBox, box);
    int orient = NUM2INT(vorient);

    wxStaticBoxSizer *ptr;
    Data_Get_Struct(self, wxStaticBoxSizer, ptr);
    ptr = new wxStaticBoxSizer(box,orient);
    DATA_PTR(self) = ptr;

    return self;
}
//-----------------------------------------------------------------------------------
VALUE
WxNotebookSizer::alloc(VALUE self)
{
    return Data_Wrap_Struct(self, 0, 0, 0);
}

VALUE
WxNotebookSizer::init(VALUE self,VALUE vnb)
{
    wxNotebook *nb;
    Data_Get_Struct(vnb, wxNotebook, nb);
    wxNotebookSizer *ptr;
    Data_Get_Struct(self, wxNotebookSizer, ptr);
    ptr = new wxNotebookSizer(nb);
    DATA_PTR(self) = ptr;

    return self;
}

void
WxNotebookSizer::RecalcSizes(VALUE self)
{
    wxNotebookSizer *ptr;
    Data_Get_Struct(self, wxNotebookSizer, ptr);
    ptr->RecalcSizes();
}

VALUE
WxNotebookSizer::CalcMin(VALUE self)
{
    wxNotebookSizer *ptr;
    Data_Get_Struct(self, wxNotebookSizer, ptr);
    return WxSize::init0(ptr->CalcMin());
}

VALUE
WxNotebookSizer::GetNotebook(VALUE self)
{
    wxNotebookSizer *ptr;
    Data_Get_Struct(self, wxNotebookSizer, ptr);
    return WxNotebook::init0(ptr->GetNotebook());
}



